<?php
require_once('sonots/sonots.class.php');   // sonots' func collection
require_once('sonots/option.class.php');   // option parser func collection
require_once('sonots/toc.class.php');      // table of contents class
require_once('sonots/metapage.class.php'); // toc requires
//error_reporting(E_ALL);

/**
 * Table of Contents Plugin
 *
 * @package    plugin
 * @license    http://www.gnu.org/licenses/gpl.html    GPL
 * @author     sonots <http://lsx.sourceforge.jp>
 * @link       http://contentsy.sourceforge.jp/?Plugin%2Fcontentsy.inc.php
 * @version    $Id: contentsy.inc.php,v 2.0 2008-05-31 11:14:46 sonots $
 * @require    sonots/sonots     v 1.9
 * @require    sonots/option     v 1.5
 * @require    sonots/toc        v 1.3
 * @require    sonots/metapage   v 1.4
 */
class PluginContentsy
{
    function PluginContentsy()
    {
        // Configure options
        // array(type, default, config)
        static $conf_options = array(
            'page'      => array('string',   null),
            'fromhere'  => array('bool',     true),
            'hierarchy' => array('bool',     true),
            'compact'   => array('bool',     true),
            'num'       => array('interval', null),
            'depth'     => array('interval', null),
            'except'    => array('string',   null),
            'filter'    => array('string',   null),
            'include'   => array('bool',     true),
            'cache'     => array('bool',     true),
            'link'      => array('enum',     'on',  array('on', 'off', 'anchor', 'page')),
        );
        // Configuration
        static $conf = array(
            'use_session'      => TRUE, // action
            'use_authlog'      => TRUE, // action
        );
        $this->conf            = &$conf;
        $this->conf_options    = &$conf_options;
        

        // init
        if (extension_loaded('mbstring')) {
            mb_regex_encoding(SOURCE_ENCODING);
        }
    }
    
    // static
    var $conf;
    var $conf_options;
    var $plugin = "contentsy";
    // var

    /**
     * Block Plugin Main Function
     */
    function convert()
    {
        sonots::init_myerror(); do { // try
            global $vars, $defaultpage;
            $args = func_get_args(); $line = csv_implode(',', $args);
            $options = PluginSonotsOption::parse_option_line($line);
            list($options, $unknowns) = PluginSonotsOption::evaluate_options($options, $this->conf_options);
            $options = PluginContentsy::check_options($options, $unknowns);
            if (sonots::mycatch()) break;

            $html = PluginContentsy::display_toc($options['page'], $options);
            if ($html != '') {
            $html = '<table border="0" class="toc"><tbody>' . "\n"
                . '<tr><td class="toctitle">' . "\n"
                . '<span>' . _('Table of Contents') . "</span>\n"
                . "</td></tr>\n"
                . '<tr><td class="toclist">' . "\n"
                . $html 
                . "</td></tr>\n"
                . "</tbody></table>\n";
            }
            return $html;
        } while (false);
        if (sonots::mycatch()) { // catch
            return '<p>#contentsy(): ' . sonots::mycatch() . '</p>';
        }
    }

    /**
     * Display Table of Contents
     *
     * @access static
     * @param string $page
     * @param array $options
     * @return string html
     */
    function display_toc($page, $options)
    {
        $toc = new PluginSonotsToc($page, $options['cache']);
        $mb = extension_loaded('mbstring') ? 'mb_' : '';

        if ($options['fromhere']) {
            $toc->grep_by('fromhere', 'eq', TRUE);
        }
        if (! $options['include']) {
            $toc->grep_by('page', 'eq', $page);
        }
        if (isset($options['filter'])) {
            $toc->grep_by('string', $mb . 'ereg', $options['filter']);
        }
        if (isset($options['except'])) {
            $toc->grep_by('string', $mb . 'ereg', $options['except'], TRUE); // inverse
        }
        if (is_array($options['depth'])) {
            list($offset, $length) = $options['depth'];
            // Do not use negative offsets
            list($min, $max) = PluginSonotsOption::conv_interval($offset, $length, 1, PHP_INT_MAX);
            $toc->grep_by('depth', 'ge', $min);
            $toc->grep_by('depth', 'le', $max);
        }
        if (is_array($options['num'])) {
            list($offset, $length) = $options['num'];
            $toc->slice($offset, $length);
        }
        
        if ($options['hierarchy']) {
            if ($options['include']) {
                $toc->shift_depth();
            }
            if ($options['compact']) {
                $toc->compact_depth();
            }
        } else {
            $toc->flat_depth();
        }
        $html = $toc->display_toc('contentsy', $options['link']);
        return $html;
    }
    
    /**
     * Check validity and compatibility of options
     *
     * @access static
     * @param array $options
     * @param array $unknowns
     * @return $options
     */
    function check_options($options, $unknowns)
    {
        if (count($unknowns) > 0) {
            $line = PluginSonotsOption::glue_option_line($unknowns);
            sonots::mythrow('Argument(s) "' . htmlspecialchars($line) . '" are invalid.');
            return;
        }
        global $vars, $defaultpage;
        if (! isset($options['page'])) {
            $options['page'] = isset($vars['page']) ? $vars['page'] : $defaultpage;
        } else {
            $options['page'] = get_fullname($options['page'], $vars['page']);
            $options['fromhere'] = FALSE;
        }
        if (! is_page($options['page'])) {
            sonots::mythrow('Page "' . htmlspecialchars($options['page']) . '" does not exist.');
            return;
        }
        if (! check_readable($options['page'], FALSE, FALSE)) {
            sonots::mythrow('Page "' . htmlspecialchars($options['page']) . '" is not readable.');
            return;
        }
        // link=on is flexible. Set to true value. 
        if ($options['link'] === 'on') {
            if ($options['page'] === $vars['page']) {
                $options['link'] = 'anchor';
            } else {
                $options['link'] = 'page';
            }
        }
        return $options;
    }

    /**
     * Action Plugin Main Function
     */
    function action() // clean cache
    {
        global $vars;

        if (sonots::is_admin($vars['pass'], $this->conf['use_session'], $this->conf['use_authlog']) && 
            $vars['pcmd'] == 'clean') {
            $html = $this->clean_cache();
        } else {
            $basehref = get_script_uri() . '?cmd=contentsy&pcmd=clean';
            $html = sonots::display_password_form($basehref);
        }
        return array('msg'=>'Clean Contentsy Caches', 'body'=>$html);
    }

    /**
     * Clean Table of Contents Cache Files
     */
    function clean_cache()
    {
        set_time_limit(0);
        global $vars;

        $page = isset($vars['page']) ? $vars['page'] : '';
        if ($page != '') {
            $toc = new PluginSonotsToc();
            $file = $toc->syntax['cachefile']($page);
            @unlink($file);
            if (exec_page($page, '/^#contentsy/')) {
                $body = 'Recreated a cache of ';
            } else {
                $body = 'No #contentsy in ';
            }
            $body .= make_pagelink($page);
        } else {
            $toc = new PluginSonotsToc();
            $file = $toc->syntax['cachefile']('hoge');
            $suffix = substr($file, strrpos($file, '.'));
            // remove all files
            $files = sonots::get_existfiles(CACHE_DIR, $suffix);
            foreach ($files as $file) {
                unlink($file);
            }
            // execute all pages
            $exec_pages = sonots::exec_existpages('', '/^#contentsy/');
            $links = array_map('make_pagelink', $exec_pages);
            $body = '<p>Following pages were executed to assure:</p>'
                . '<p>' . implode("<br />\n", $links) . '</p>';
        }
        return $body;
    }
}

///////////////////////////////////////////
function plugin_contentsy_init()
{
    global $plugin_contentsy_name;
    if (class_exists('PluginContentsyUnitTest')) {
        $plugin_contentsy_name = 'PluginContentsyUnitTest';
    } elseif (class_exists('PluginContentsyUser')) {
        $plugin_contentsy_name = 'PluginContentsyUser';
    } else {
        $plugin_contentsy_name = 'PluginContentsy';
    }
}
function plugin_contentsy_action()
{
    global $plugin_contentsy, $plugin_contentsy_name;
    $plugin_contentsy = new $plugin_contentsy_name();
    return call_user_func(array(&$plugin_contentsy, 'action'));
}
function plugin_contentsy_convert()
{
    global $plugin_contentsy, $plugin_contentsy_name;
    $plugin_contentsy = new $plugin_contentsy_name();
    $args = func_get_args();
    return call_user_func_array(array(&$plugin_contentsy, 'convert'), $args);
}

if (! defined('INIT_DIR')) // if not Plus! 
    if (file_exists(DATA_HOME . 'init/contentsy.ini.php')) 
        include_once(DATA_HOME . 'init/contentsy.ini.php');

?>
