CREATE OR REPLACE FUNCTION
    pgs2insert(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2insert'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    _pgs2insert(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', '_pgs2insert'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2beginscan(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2beginscan'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2gettuple(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2gettuple'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2getmulti(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2getmulti'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2rescan(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2rescan'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2endscan(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2endscan'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2markpos(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2markpos'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2restrpos(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2restrpos'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2build(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2build'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    _pgs2build(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', '_pgs2build'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2buildb(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2buildb'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    _pgs2buildb(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', '_pgs2buildb'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2buildu(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2buildu'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    _pgs2buildu(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', '_pgs2buildu'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2bulkdelete(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2bulkdelete'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    _pgs2bulkdelete(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', '_pgs2bulkdelete'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2vacuumcleanup(INTERNAL, INTERNAL) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2vacuumcleanup'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2costestimate(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2costestimate'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2contain(TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', 'pgs2contain'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    _pgs2contain(_TEXT, TEXT) RETURNS BOOLEAN
    AS '$libdir/pgsenna2', '_pgs2contain'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2nop(TEXT) RETURNS TEXT
    AS '$libdir/pgsenna2', 'pgs2nop'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2getscore(tid, TEXT) RETURNS INT
    AS '$libdir/pgsenna2', 'pgs2getscore'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2getscore(tid) RETURNS INT
    AS '$libdir/pgsenna2', 'pgs2getscore_simple'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2getnhits() RETURNS INT
    AS '$libdir/pgsenna2', 'pgs2getnhits'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2options() RETURNS INT
    AS '$libdir/pgsenna2', 'pgs2options'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2indexcache(OUT relid TEXT, OUT namespace TEXT, OUT name TEXT,
     OUT previous TEXT, OUT this TEXT, OUT next TEXT)
    RETURNS SETOF RECORD
    AS '$libdir/pgsenna2', 'pgs2indexcache'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2destroy() RETURNS INT
    AS '$libdir/pgsenna2', 'pgs2destroy'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2indexinfo(OUT filename TEXT, OUT dead_flag integer,
    OUT key_size integer, OUT flags integer,
    OUT initial_n_segments integer, OUT encoding integer,
    OUT nrecords_keys bigint, OUT file_size_keys bigint,
    OUT nrecords_lexicon bigint, OUT file_size_lexicon bigint,
    OUT inv_seg_size bigint , OUT inv_chunk_size bigint)
    RETURNS SETOF record
    AS '$libdir/pgsenna2', 'pgs2indexinfo'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2indexinfodb(OUT filename TEXT, OUT dead_flag integer,
    OUT key_size integer, OUT flags integer,
    OUT initial_n_segments integer, OUT encoding integer,
    OUT nrecords_keys bigint, OUT file_size_keys bigint,
    OUT nrecords_lexicon bigint, OUT file_size_lexicon bigint,
    OUT inv_seg_size bigint , OUT inv_chunk_size bigint)
    RETURNS SETOF record
    AS '$libdir/pgsenna2', 'pgs2indexinfodb'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2getlexicon(IN filename TEXT,
    OUT id TEXT, OUT lexicon TEXT, OUT flag integer)
    RETURNS SETOF record
    AS '$libdir/pgsenna2', 'pgs2getlexicon'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2version() RETURNS TEXT
    AS '$libdir/pgsenna2', 'pgs2version'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2seninfo(OUT version TEXT, OUT configure_option TEXT,
    OUT config_path TEXT, OUT default_encoding TEXT,
    OUT initial_n_segments TEXT, OUT partial_match_threshold TEXT)
    RETURNS record
    AS '$libdir/pgsenna2', 'pgs2seninfo'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2getoption(OUT max_n_sort_result TEXT,
    OUT enable_seqscan TEXT, OUT seqscan_flags TEXT, OUT sen_index_flags TEXT,
    OUT max_n_index_cache TEXT, OUT initial_n_segments TEXT)
    RETURNS record
    AS '$libdir/pgsenna2', 'pgs2getoption'
LANGUAGE 'C' STRICT;

CREATE OR REPLACE FUNCTION
    pgs2pdftotext1(TEXT) RETURNS TEXT
    AS '$libdir/pgsenna2', 'pgs2pdftotext1'
LANGUAGE 'C' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION
    pgs2pdftotext2(BYTEA) RETURNS TEXT
    AS '$libdir/pgsenna2', 'pgs2pdftotext2'
LANGUAGE 'C' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION
    pgs2snippet1(INT, INT, INT, TEXT, TEXT, INT, TEXT, TEXT)
    RETURNS TEXT
    AS '$libdir/pgsenna2', 'pgs2snippet1'
LANGUAGE 'C' STRICT;

INSERT INTO pg_am VALUES('fulltext','1','1','0','f','t','t','t','f','f','pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','pgs2build','pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltexta','1','1','0','f','t','t','t','f','f','_pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','_pgs2build','_pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltextb','1','1','0','f','t','t','t','f','f','pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','pgs2buildb','pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltextab','1','1','0','f','t','t','t','f','f','_pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','_pgs2build','_pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltextu','1','1','0','f','t','t','t','f','f','pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','pgs2buildu','pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltextau','1','1','0','f','t','t','t','f','f','_pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','_pgs2build','_pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltextr','1','1','0','f','f','t','t','f','f','pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','pgs2build','pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltextrb','1','1','0','f','f','t','t','f','f','pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','pgs2buildb','pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

INSERT INTO pg_am VALUES('fulltextru','1','1','0','f','f','t','t','f','f','pgs2insert','pgs2beginscan','pgs2gettuple','pgs2getmulti','pgs2rescan','pgs2endscan','pgs2markpos','pgs2restrpos','pgs2buildu','pgs2bulkdelete','pgs2vacuumcleanup','pgs2costestimate','pgs2options');

CREATE OPERATOR @@ (
        LEFTARG = text,
        RIGHTARG = text,
        PROCEDURE = pgs2contain,
        COMMUTATOR = '@@',
        RESTRICT = contsel,
        JOIN = contjoinsel
);

CREATE OPERATOR @@ (
        LEFTARG = _text,
        RIGHTARG = text,
        PROCEDURE = _pgs2contain,
        COMMUTATOR = '@@',
        RESTRICT = contsel,
        JOIN = contjoinsel
);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE text USING fulltext AS
        OPERATOR 1 @@,
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE text USING fulltextb AS
        OPERATOR 1 @@,
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE text USING fulltextu AS
        OPERATOR 1 @@,
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE _text USING fulltexta AS
        OPERATOR 1 @@ (_text, text),
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE _text USING fulltextab AS
        OPERATOR 1 @@ (_text, text),
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE _text USING fulltextau AS
        OPERATOR 1 @@ (_text, text),
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE text USING fulltextr AS
        OPERATOR 1 @@ RECHECK,
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE text USING fulltextrb AS
        OPERATOR 1 @@ RECHECK,
        FUNCTION 1 pgs2nop (text);

CREATE OPERATOR CLASS text_ops
    DEFAULT FOR TYPE text USING fulltextru AS
        OPERATOR 1 @@ RECHECK,
        FUNCTION 1 pgs2nop (text);
