/*
 *  m2m_caster.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <stdint.h>
#include <pthread.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <unistd.h>
#include "m2m.h"
#include "m2m_descripter.h"
#include "m2m_playlist.h"

static int sd=-1;
static int start_title=1;

static int recv_hello(int fd)
{
  int n;
  char buf[2048];
  int i;
  for( i=0 ; i<sizeof(buf) ;i++ )
  {
    n=recv(fd,buf+i,1,0);
    if ( n != 1 ){ perror("recv"); return -1; }
    if ( buf[i] == '\n' ) break;
  }
  buf[i]=0x0;
fprintf(stderr,"recv_hello:received[%s]\n",buf);
  if ( strncmp(buf,"HELLO",5) != 0 ) return -1;
  return 0;
}

static inline int m2m_init_caster( char ip_addr[] , unsigned short port )
{
  struct sockaddr_in addr;
  int status;

  sd = socket(PF_INET, SOCK_STREAM , 0);
  if ( sd <= -1 ){ perror("socket"); return -1; }
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr=INADDR_ANY;
  addr.sin_port = htons(port);
  status = bind(sd, (struct sockaddr *) &addr, sizeof(addr));
  if ( status <= -1 ){ perror("bind"); return -2; }
  status = listen( sd,2 );
fprintf(stderr,"m2m_join2caster:listen done.%d\n",status);
  if ( status <= -1 ){ perror("ilisten"); return -3; }
  return 0;
}

static inline int m2m_accept( void )
{
  struct sockaddr_in addr;
  int len;
  int fd;

  while(1){
    memset(&addr, 0, sizeof(addr));
    len=sizeof(addr);
    fd = accept( sd,(struct sockaddr *)&addr,&len );
fprintf(stderr,"m2m_join2caster:accept done.%d\n",fd);
    if ( fd <= -1 ){ perror("accept"); return -4; }
    if( recv_hello(fd) == 0 ) break;
    close(fd);
  }
  return fd;

/*
  sd = socket(PF_INET, SOCK_STREAM , 0);
  if ( sd  == -1 ){ perror("socket"); return -1; }
  memset(&addr, 0, sizeof(addr));
  addr.sin_port = htons(port);
  addr.sin_family = AF_INET;
  inet_pton( AF_INET,ip_addr,&addr.sin_addr );
  status = connect( sd, (struct sockaddr *)&addr, sizeof(addr));
  if ( status == -1 ){ perror("conect" ); return -5; }
  return 0;
*/
}

static int m2m_write_sector_stdout(int dummy,char in_buf[] , int len )
{
  return fwrite( in_buf,1,len, stdout );
}
static int m2m_write_sector_sock(int fd,char in_buf[] , int len )
{
  return send(fd, in_buf, len, 0);
}

static inline void m2m_cast( int fd,int (*m2m_write_sector)(int,char [],int) )
{
  m2m_playlist_entry_t * top=m2m_add_playlist_from_properties();
  struct timeval st;
  struct timeval ed;
  int i=0;
  if ( top == NULL ) return;
  gettimeofday( &st,NULL );
  while (1)
  {
    m2m_playlist_entry_t * cur;
    m2m_get_playlist_length();
    for( cur=top ; cur; cur=cur->next )
    {
      uint8_t buf[2048];
      int len=sizeof(buf);
      if ( start_title > 2 ){
          --start_title;
          continue;
      }
      cur->descripter->seek( cur->descripter , cur->descripter->st );
      while( len == sizeof(buf) )
      {
        cur->descripter->read( cur->descripter , buf,&len );
        if ( m2m_write_sector(fd,buf, len) < 0 ) return;
/*
        if ( ++i > 250 ){
          gettimeofday( &ed,NULL );
          fprintf( stderr,"send:%8.1lf KByte/sec\r", i*2/(ed.tv_sec-st.tv_sec+(ed.tv_usec-st.tv_usec)/1000000.0));
          st=ed;
          i=0;
        }
*/
      }
      memset( buf,0xff,sizeof(buf) );
      buf[0]=buf[1]=0x0; buf[2]=0x01; buf[3]=0x0f2; buf[4]=0x08; buf[5]=0x0;
      if ( m2m_write_sector(fd,buf,2048) < 0 ) return;
fprintf( stderr,"send EOF\n" );
    }
  }
}

static inline void m2m_cast_close(){
  close(sd);
  sd=-1;
}

int hadle_args( int argc,char *argv[] )
{
  char *default_device="/dev/dvd";
  int i;
  int show_prop=0;
  int help=0;
  int isStdout=0;
  char *dvd=NULL;
  char * prop=NULL;

  for ( i=1 ; i< argc ; i++ )
  {
      if( argv[i][0] != '-' ) continue;
      if( argv[i][1] == 0x0 )
      {
          isStdout=1;
      }else
      if( strncmp(argv[i],"--title=",8) == 0 && argv[i][8] != 0x0 )
      {
          start_title=atol(argv[i]+8);
      }else
      if( strcmp(argv[i],"-t") == 0 && i+1 < argc && argv[i+1][0] != '-' )
      {
          i++;
          start_title=atol(argv[i]);
      }else
      if( strncmp(argv[i],"--device=",9) == 0 && argv[i][9] != 0x0 )
      {
          dvd = argv[i]+9;
      }else
      if ( strcmp(argv[i],"--device") == 0 || strcmp(argv[i],"-d") == 0 )
      {
          dvd=default_device;
          if ( i+1 < argc && argv[i+1][0] != '-' )
          {
              i++;
              dvd=argv[i];
          }
      }else
      if ( strcmp(argv[i],"--conf") == 0 && i+1 < argc && argv[i+1][0] != '-' )
      {
          i++;
          prop=argv[i];
      }else
      if ( strcmp(argv[i],"--showconf") == 0 )
      {
          show_prop=1;
      }else
      if ( strcmp(argv[i],"--help") == 0 || strcmp(argv[i],"-h") == 0 )
      {
          help=1;
      }
  }
  m2m_load_properties( prop );
  if ( dvd ) m2m_add_playlist_from_ifo(dvd);
  if ( show_prop ) m2m_write_properties( 1 );
  if ( help ) {
    printf( "Usage:%s options... \n",argv[0] );
    printf( "options:\n" );
    printf( "  --device -d [devicename]  : do dvd.\n" );
    printf( "  --conf config_file        : chose a config.\n" );
    printf( "  --showconf                : show config.\n" );
    exit(0);
  }
  return isStdout;
}

void * m2m_new_caster( void *fd )
{
  m2m_cast( (int)fd, m2m_write_sector_sock );
  close((int)fd);
}
int main( int argc,char *argv[] )
{
  if ( hadle_args(argc,argv ) )
  {
    m2m_cast( 1,m2m_write_sector_stdout);
    return 0;
  }else
  if ( m2m_init_caster( m2m_get_property("CAST_IP") ,
                        atoi(m2m_get_property("CAST_PORT"))) )
  {
    perror("init:");
    return -1;
  }

  signal( SIGPIPE,SIG_IGN );
  while(1){
     int fd;
     pthread_t thr;
     pthread_attr_t attr;
     pthread_attr_init( &attr );
     pthread_attr_setscope( &attr , PTHREAD_SCOPE_SYSTEM );
     fd= m2m_accept( );
     pthread_create( &thr , &attr  , m2m_new_caster , (void *)fd );
fprintf( stderr,"branched\n" );
  }
  return 0;
}

