/*
 *  m2m_listener.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <stdint.h>
#include "m2m.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pthread.h>
#include <mpeg2dec/mm_accel.h>
#include "video_out/video_out.h"
#include <mpeg2dec/mpeg2.h>


#define BUFFER_SIZE 2048

static int is_stdin=0;
static int sd=-1;
static struct ip_mreq stMreq;
mpeg2dec_t mpeg2dec;
vo_instance_t * vo_instance=NULL;
char *vo_driver=NULL;
char *ao_driver=NULL;
int m2m_brightness =135;
int m2m_contrast =127;
int m2m_ad_sync =100;
int m2m_ad_late =500;
int m2m_ad_skip =500000;
int audio_no=1;
int audio_rate=0;
uint32_t commandline_params=0;
#ifdef HAVE_ESOUND
char *esd_host=NULL;
#endif

void m2m_leave_caster(){
  setsockopt(sd, IPPROTO_IP, IP_DROP_MEMBERSHIP, (char*) &stMreq, sizeof(stMreq));
  close(sd);
  sd=-1;
}

void m2m_sighanhler( int signum )
{
fprintf( stderr,"catched signal %d\n",signum );
  mpeg2_close (&mpeg2dec);
  vo_close (vo_instance);
  m2m_leave_caster();
  kill( getpid(),SIGQUIT );
}

int m2m_join2caster( char ip_addr[] , unsigned short port ) {
  struct sockaddr_in addr;
  int status;
  int len;

  if ( sd != -1 ) m2m_leave_caster();

fprintf(stderr,"m2m_join2caster(%s,%d)\n",ip_addr,port);
  sd = socket(PF_INET, SOCK_STREAM , 0);
  if ( sd  == -1 ){ perror("socket"); return -1; }
  memset(&addr, 0, sizeof(addr));
  addr.sin_port = htons(port);
  addr.sin_family = AF_INET;
  inet_pton( AF_INET,ip_addr,&addr.sin_addr );
  status = connect( sd, (struct sockaddr *)&addr, sizeof(addr));
  if ( status == -1 ){ perror("conect" ); return -5; }
  status = send(sd,"HELLO \r\n",8,0);
  if ( status < 1 ){ perror("send" ); return -6; }
  return 0;

/*
  sd = socket(PF_INET, SOCK_STREAM , 0);
  if ( sd <= -1 ){ perror("socket"); return -1; }
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr=INADDR_ANY;
  addr.sin_port = htons(port);
  status = bind(sd, (struct sockaddr *) &addr, sizeof(addr));
fprintf(stderr,"m2m_join2caster:bind done.%d\n",status);
  if ( status <= -1 ){ perror("bind"); return -2; }
  status = listen( sd,2 );
fprintf(stderr,"m2m_join2caster:listen done.%d\n",status);
  if ( status <= -1 ){ perror("ilisten"); return -3; }
  memset(&addr, 0, sizeof(addr));
  len=sizeof(addr);
  fd = accept( sd,(struct sockaddr *)&addr,&len );
fprintf(stderr,"m2m_join2caster:accept done.%d\n",fd);
  if ( fd <= -1 ){ perror("accept"); return -4; }
*/
}

int read_sector( uint8_t buf[] ){
    int ret=0;
    int status;
    while( ret < 2048 ){
        if ( is_stdin )
        {
            ret += fread( buf+ret, 1,2048-ret,stdin );
        }else{
            status = recv( sd,buf+ret, 2048-ret,0 );
            if ( status == -1 ) { perror("recv" ); exit(1); }
            ret += status;
        }
    }
    return ret;
}

static int m2m_init( int argc,char *argv[] )
{
    int i;
    uint32_t accel = mm_accel () | MM_ACCEL_MLIB;
    vo_driver_t * drivers = vo_drivers();

    printf(" mpeg2dec: (C) 1999 Aaron Holtzman <aholtzma@ess.engr.uvic.ca>\n");
    printf(" m2m : (C) 2000 Taichi Nakamura <pdf30044@biglobe.ne.jp>\n");

    vo_accel (accel);
    vo_instance = NULL;
    for ( i=0 ; vo_driver && drivers[i].name ; i++ )
    {
        if ( strcmp(vo_driver,drivers[i].name)==0 )
        {
            vo_instance = vo_open (drivers[i].open);
if ( vo_instance ) fprintf( stderr,"select video driver=%s\n",drivers[i].name);
            break;
        }
    }
    if ( vo_instance == NULL ) vo_instance = vo_open (drivers[0].open);
    if ( vo_instance == NULL ) return -1;
    mpeg2_init( &mpeg2dec , accel, vo_instance );
    for( i=0 ; i<100 ; i++ ) m2m_fill_buffer(0);
}

int main( int argc,char *argv[] ){
    if ( argc > 1 && argv[1][0] == '-' && argv[1][1] == 0x0 )
    {
        is_stdin=1;
    }
    else
    {
        m2m_load_properties( (argc<=1)?NULL:argv[1] );
        if ( m2m_join2caster( m2m_get_property("CAST_IP") ,
                              atoi(m2m_get_property("CAST_PORT"))) )
        {
            exit(1);
        }
    }
    signal( SIGINT,SIG_IGN);
    signal( SIGHUP,m2m_sighanhler);
    signal( SIGABRT,m2m_sighanhler);
    signal( SIGPIPE,m2m_sighanhler);
    signal( SIGTSTP,m2m_sighanhler);
    m2m_init(argc,argv);
    m2m_thread_control( M2M_AUDIO_THREAD_ID,1 );
    video_thread(NULL);
    m2m_leave_caster();
    mpeg2_close (&mpeg2dec);
    vo_close (vo_instance);
}




#define ARCH_X86
#ifdef ARCH_X86
static uint32_t x86_accel (void)
{
    uint32_t eax, ebx, ecx, edx;
    int AMD;
    uint32_t caps;

#define cpuid(op,eax,ebx,ecx,edx)	\
    asm ("cpuid"			\
	 : "=a" (eax),			\
	   "=b" (ebx),			\
	   "=c" (ecx),			\
	   "=d" (edx)			\
	 : "a" (op)			\
	 : "cc")

    asm ("pushfl\n\t"
	 "popl %0\n\t"
	 "movl %0,%1\n\t"
	 "xorl $0x200000,%0\n\t"
	 "pushl %0\n\t"
	 "popfl\n\t"
	 "pushfl\n\t"
	 "popl %0"
         : "=a" (eax),
	   "=b" (ebx)
	 :
	 : "cc");

    if (eax == ebx)		/* no cpuid */
	return 0;

    cpuid (0x00000000, eax, ebx, ecx, edx);
    if (!eax)			/* vendor string only */
	return 0;

    AMD = (ebx == 0x68747541) && (ecx == 0x444d4163) && (edx == 0x69746e65);

    cpuid (0x00000001, eax, ebx, ecx, edx);
    if (! (edx & 0x00800000))	/* no MMX */
	return 0;

    caps = MM_ACCEL_X86_MMX;
    if (edx & 0x02000000)	/* SSE - identical to AMD MMX extensions */
	caps = MM_ACCEL_X86_MMX | MM_ACCEL_X86_MMXEXT;

    cpuid (0x80000000, eax, ebx, ecx, edx);
    if (eax < 0x80000001)	/* no extended capabilities */
	return caps;

    cpuid (0x80000001, eax, ebx, ecx, edx);

    if (edx & 0x80000000)
	caps |= MM_ACCEL_X86_3DNOW;

    if (AMD && (edx & 0x00400000))	/* AMD MMX extensions */
	caps |= MM_ACCEL_X86_MMXEXT;

    return caps;
}
#endif

uint32_t mm_accel (void)
{
#ifdef ARCH_X86
    static int got_accel = 0;
    static uint32_t accel;

    if (!got_accel) {
	got_accel = 1;
	accel = x86_accel ();
    }

    return accel;
#else
    return 0;
#endif
}

