/*
 *  m2m_nav.c:
 *     Infomation handling for DVD navigation.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif

#include <features.h>
#include <stdio.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <pthread.h>
#include <string.h>
#include <ifo.h>

#include "config.h"
#include <mpeg2dec/video_out.h>
#include <mpeg2dec/mpeg2.h>
#include <mpeg2dec/mm_accel.h>
#include <dvd_udf.h>
#include "m2m.h"
#include "m2m_descripter.h"
#include "m2m_playlist.h"
#include "m2m_ifo.h"

#define FILE_IFO "/VIDEO_TS/VIDEO_TS.IFO"
#define PREAD64

static m2m_ifo_t **handle_ifo=NULL;
static int n_handle_ifo=0;

void m2m_close_ifo ( char * devicename )
{
    int i,j;
    for ( i=0 ; i<n_handle_ifo && handle_ifo ; i++ ){
        if ( handle_ifo[i] == NULL ) continue;
        if ( strcmp(devicename,handle_ifo[i]->path) == 0 )
            break;
    }
    if ( i >= n_handle_ifo || handle_ifo == NULL ) return;
    for( j=0 ; handle_ifo[i]->ifo_s && handle_ifo[i]->ifo_s[j] ; j++ ){
      ifoClose( handle_ifo[i]->ifo_s[j] );
    }
    free ( handle_ifo[i]->ifo_s );
    free ( handle_ifo[i]->chapters );
    free ( handle_ifo[i]->path );
    free ( handle_ifo[i] );
    handle_ifo[i]=handle_ifo[n_handle_ifo-1];
    handle_ifo[n_handle_ifo-1]=NULL;
    n_handle_ifo--;
}

static void m2m_check_cell_dvd( m2m_dvddesc_t *chap )
{
    m2m_ifo_t *m2mifo=chap->ifo;
    uint32_t st,ed,off;
    int i;

    if ( ! chap->chain_info_low ) return;
    if ( m2mifo->current_cell )
    {
        st= htonl(m2mifo->current_cell->start);
        ed= htonl(m2mifo->current_cell->end);
    }

    off = (m2mifo->pos>>11) - chap->title_start;
    if ( m2mifo->current_cell == NULL || off < st || off > ed )
    {
        m2mifo->current_cell=chap->cells;
        do {
            st= htonl(m2mifo->current_cell->start);
            ed= htonl(m2mifo->current_cell->end);
            if ( off <= ed && off >= st ) break;
            if ( m2mifo->current_cell == chap->last_cell ) m2mifo->current_cell=chap->cells;
            else m2mifo->current_cell++;
        } while ( m2mifo->current_cell != chap->cells );
        if ( m2mifo->current_cell == chap->cells )
            return;
    }
 
    if ( off == ed )
    {
        // check multi-angle !!
        switch ( chap->chain_info_low ) 
        {
            case 0x0c:
fprintf( stderr,"chain %02x skip  .cell[%08lx,%08lx]llast[%08lx,%08lx] %08lx\n",chap->chain_info_low,(long)htonl(m2mifo->current_cell->start),htonl(m2mifo->current_cell->end),(long)htonl(chap->last_cell->start),htonl(chap->last_cell->end),(long)htonl(chap->pgci_cells[i].vobu_last_end) );
            {
                if ( ++m2mifo->current_cell != chap->last_cell && off > (st=htonl(m2mifo->current_cell->start)) )
                if ( ++m2mifo->current_cell != chap->last_cell && off > (st=htonl(m2mifo->current_cell->start)) )
                if ( ++m2mifo->current_cell != chap->last_cell && off > (st=htonl(m2mifo->current_cell->start)) )
                if ( ++m2mifo->current_cell != chap->last_cell && off > (st=htonl(m2mifo->current_cell->start)) )
                    return;
                m2mifo->current_cell--;
fprintf( stderr,"chain %02x skiped.cell[%08lx,%08lx]llast[%08lx,%08lx] %08lx\n",chap->pgci_cells[i].chain_info,(long)htonl(m2mifo->current_cell->start),htonl(m2mifo->current_cell->end),(long)htonl(chap->last_cell->start),htonl(chap->last_cell->end),(long)htonl(chap->pgci_cells[i].vobu_last_end) );
                //m2mifo->pos += ( st +chap->title_start -lba )*2048-step;
                m2mifo->pos = ( st +chap->title_start )*2048;
                break;
            }
            case 0x0e: // non equivalent interleave
fprintf( stderr,"chain %02x\n",chap->chain_info_low );
            {
                ifo_cell_addr_t *c=m2mifo->current_cell;
                for ( i=chap->pgci_cell_index+1; i < chap->n_pgci_cells; i++ )
                {
fprintf( stderr,"chain %02x check..cell[%08lx,%08lx]c[%08lx,%08lx] %08lx\n",chap->pgci_cells[i].chain_info,(long)htonl(m2mifo->current_cell->start),htonl(m2mifo->current_cell->end),(long)htonl(c->start),htonl(c->end),(long)htonl(chap->pgci_cells[i].vobu_last_end) );
                    if ( chap->pgci_cells[i].chain_info < 0x0c ) break;
                    if ( htonl(chap->pgci_cells[i].vobu_last_end) > htonl(c->end) )
                    {
                        m2mifo->current_cell++;
                        c++;
                    }
                    c++;
                }
fprintf( stderr,"chain %02x checked\n",chap->pgci_cells[i].chain_info );
                //m2mifo->pos += (htonl(m2mifo->current_cell->start) +chap->title_start -lba_idx) *2048 -step;
                m2mifo->pos = (htonl(m2mifo->current_cell->start) +chap->title_start ) *2048 ;
                break;
            }
            case 0x5f: // multi angle
fprintf( stderr,"chain %02x\n",chap->chain_info_low );
            {
                //i = (chap->title_start + htonl(m2mifo->current_cell[1].start) - lba_idx) *2048-step;
                i = (chap->title_start + htonl(m2mifo->current_cell[1].start) ) *2048-m2mifo->pos;
                if ( i >= 0 ) m2mifo->pos += i;
                //else m2mifo->pos += ( chap->title_start + htonl( chap->pgci_cells[chap->pgci_cell_index] .vobu_last_end ) + 1 - lba_idx )*2048-step;
                else m2mifo->pos = ( chap->title_start + htonl( chap->pgci_cells[chap->pgci_cell_index] .vobu_last_end ) + 1 )*2048;
                break;
            }
            default:
fprintf( stderr,"chain %02x\n",chap->chain_info_low );
                // check next cell
                //if ( (st= htonl(m2mifo->current_cell[1].start)) == htonl(m2mifo->current_cell->start) )
                //    step = (htonl(m2mifo->current_cell[2].start)+chap->title_start)-lba_idx;
                //else
                //    step = (st+chap->title_start)-lba_idx;
                break;
        }
    }
    return;
}

static int m2m_read_dvd( m2m_descripter_t *_desc ,uint8_t buf[],int * size )
{
    m2m_dvddesc_t *chap=(m2m_dvddesc_t *)_desc;
    m2m_ifo_t *m2mifo=chap->ifo;
    int bytes_read;
    off64_t lba = m2mifo->pos >> 11;
 
    if ( m2mifo->pos-2048 == _desc->ed ){
      return *size=0;
    }
    if ( _desc->st > m2mifo->pos  || m2mifo->pos > _desc->ed )
      return -1;
    if ( *size < 2048 )
      return -2;
#ifdef USE_css_auth
    if ( m2mifo->current_title_set != chap->title_set ){
      extern int init_css_by_lba( char [],int,unsigned char [] );
      unsigned long int partition_offset;
      struct AD File;
      char vob_fn[64];
      sprintf( vob_fn,"VIDEO_TS/VTS_%02d_1.VOB",chap->title_set+1 );
fprintf( stderr,"find[%s]\n",vob_fn );
      if ( !UDFFindFileEntry(0,vob_fn,&partition_offset,&File)) {
                return -1;
      }
fprintf( stderr,"css[%s]\n",vob_fn );
      init_css_by_lba( m2mifo->path,(int)(partition_offset+File.Location),m2mifo->title_key );
      m2mifo->current_title_set = chap->title_set;
    }
#endif
    *size = UDFReadLB( lba, 1,buf);
#ifdef USE_css_auth
    if ( (buf[4]&0xf0)==0x40  //mpeg2
     &&  buf[20] & 0x30 ){
        extern void css_descramble(unsigned char *,unsigned char *);
        css_descramble( buf, m2mifo->title_key);
        buf[20] &= 0xcf;
    }
#endif
    m2m_check_cell_dvd( chap );
    m2mifo->pos += *size;
 }

static int m2m_seek_dvd( struct m2m_desctipter_s *_desc,off64_t pos )
{
  m2m_dvddesc_t *desc = (m2m_dvddesc_t *)_desc ;
fprintf(stderr,"seek %lx:",(uint32_t)pos );
  if ( pos < _desc->st || pos > _desc->ed ) return -1;
  lseek64( desc->ifo->fd , pos , SEEK_SET );
  desc->ifo->pos=pos;
  m2m_check_cell_dvd( desc );
  return 0;
}

static void m2m_close_dvd( struct m2m_desctipter_s *_desc )
{
}

static void m2m_eject_dvd( struct m2m_desctipter_s *_desc )
{
   m2m_close_ifo ( ((m2m_dvddesc_t *)_desc)->ifo->path );
}

m2m_ifo_t * m2m_open_ifo( char *devicename )
{
    __off64_t lba;
    unsigned long int partition_offset,pos=0;
    struct AD file_entry;
    int i,j,k,l,tno,cno,ntitle,n;
    ifo_ptt_t *ptt;
    //ifo_t * ifo_s =NULL;
    m2m_ifo_t * ret =NULL;
    m2m_dvddesc_t wkchap[250];

    for ( i=0 ; i<n_handle_ifo && handle_ifo ; i++ ){
        if ( handle_ifo[i] == NULL ) continue;
        if ( strcmp(devicename,handle_ifo[i]->path) == 0 )
            return  handle_ifo[i];
    }

    ret=(m2m_ifo_t *)malloc( sizeof(m2m_ifo_t) );
    memset( ret,0x0, sizeof(m2m_ifo_t) );
    ret->path=(char *)malloc( (strlen(devicename)+1)*sizeof(char) );
    strcpy(ret->path,devicename);

    if( (ret->fd=UDFOpenDisc( ret->path )) == -1 ) {
            free(ret->path);
            free(ret);
            return NULL;
    }

#if 0
    if (!UDFFindFileEntry(0,FILE_IFO,&partition_offset,&file_entry) )
        return -1;
    lba=partition_offset+file_entry.Location;
    if (!(ifo_s = ifoOpen(ret->fd, lba * DVD_VIDEO_LB_LEN)))
        return -2;

    {
        u_char *ptr=NULL;
        u_int offset;
        ifoGetVMGPTT ((ifo_hdr_t *)ifo_s->data[ID_PTT], (char **) &ptr);
        offset  = ptr[ 8] << 24;
        offset |= ptr[ 9] << 16;
        offset |= ptr[10] << 8;
        offset |= ptr[11];
        lba += offset;
    }
    ntitle=ifoGetNumberOfTitles (ifo_s);
    ifoClose (ifo_s);
#endif

    ret->nchapters=0;
    for( tno=1;;tno++ )
    {
        ifo_cell_addr_t *cells=NULL;
        char titlename[32];
        sprintf(titlename,"/VIDEO_TS/VTS_%02d_0.IFO",tno );
        if (!UDFFindFileEntry(0,titlename,&partition_offset,&file_entry) )
            break;
        lba=partition_offset+file_entry.Location;

        ret->ifo_s=(ifo_t **)realloc( ret->ifo_s , (tno+1)*sizeof(ifo_t *) );
        ret->ifo_s[tno]=NULL;
        if (!(ret->ifo_s[tno-1] = ifoOpen (ret->fd, lba * DVD_VIDEO_LB_LEN)) )
        {
            free(ret->ifo_s);
            free(ret->path);
            free(ret);
            return NULL;
        }
        lba += ifoGetVOBStart(ret->ifo_s[tno-1]);
        ifoGetCellAddr( (char *) ret->ifo_s[tno-1]->data[ID_TITLE_CELL_ADDR],
                        (char **) &cells );

        // scan program chain
        if ( !(ptt = ifo_get_ptt(ret->ifo_s[tno-1])) )
            return NULL;

        cno=1;
        for ( i=0 ; i<ptt->num ; i++ ) /* earch title ? */
        {
            for ( j=0 ; j<ptt->title[i].num ; j++ ) /* earch chapter */
            {
                int num_cells;
                char *pgci;
                ifo_pgc_cell_pos_t *cell_pos=NULL;
                ifo_pgci_cell_addr_t *pgci_cells=NULL;

                ifoGetPGCI( (ifo_hdr_t *)ret->ifo_s[tno-1]->data[ID_TITLE_PGCI],
                            ptt->title[i].data[j].pgc-1,&pgci);
                num_cells = ifoGetCellPos (pgci, (u_char **) &cell_pos);
                num_cells = ifoGetCellAddrNum(
                                  (char *)ret->ifo_s[tno-1]->data[ID_TITLE_CELL_ADDR]);
                n = ifoGetCellPlayInfo( pgci, (u_char **) &pgci_cells );
                for ( k=0 ; k<n ; k++ )
                {
                    wkchap[ret->nchapters].ifo=ret;
                    wkchap[ret->nchapters].desc.type=1;
                    wkchap[ret->nchapters].desc.read=m2m_read_dvd;
                    wkchap[ret->nchapters].desc.seek=m2m_seek_dvd;
                    wkchap[ret->nchapters].desc.close=m2m_close_dvd;
                    wkchap[ret->nchapters].desc.eject=m2m_eject_dvd;
                    wkchap[ret->nchapters].desc.st=(htonl(pgci_cells[k].vobu_start   )+lba)*DVD_VIDEO_LB_LEN;
                    wkchap[ret->nchapters].desc.ed=(htonl(pgci_cells[k].vobu_last_end)+lba)*DVD_VIDEO_LB_LEN;
                    wkchap[ret->nchapters].title_set=tno-1;
                    wkchap[ret->nchapters].title=ptt->title[i].data[j].pgc-1;
                    wkchap[ret->nchapters].chapter=cno;
                    wkchap[ret->nchapters].title_start=lba;
                    wkchap[ret->nchapters].cells=cells;
                    wkchap[ret->nchapters].last_cell=cells+num_cells;
                    wkchap[ret->nchapters].n_pgci_cells=n;
                    wkchap[ret->nchapters].pgci_cells=pgci_cells;
                    wkchap[ret->nchapters].pgci_cell_index=k;
                    wkchap[ret->nchapters].chain_info_low=
                               pgci_cells[k].chain_info & 0x0ff;
                    sprintf( wkchap[ret->nchapters].name,"dvd:%d-%d-%d-%d",tno,i+1,j+1,k+1);
                    for ( l=0 ; l<ret->nchapters ; l++ )
                        if ( wkchap[ret->nchapters].desc.st == wkchap[l].desc.st )
                            break;
                    if( l >= ret->nchapters )
                    {
//fprintf(stderr,"cell:%d:%d:%ld %ld \n",tno,cno,(long)wkchap[ret->nchapters].lba_st,(long)wkchap[ret->nchapters].lba_ed);
                        ret->nchapters++;
                        cno++;
                    }
                }
            }
        }
        //ifoClose (ret->ifo_s[tno-1]);
    }
    if( ret->nchapters <= 0 )
        return NULL;

    ret->chapters=(m2m_dvddesc_t *)malloc( sizeof(m2m_dvddesc_t)*ret->nchapters );
    memcpy( ret->chapters,wkchap,sizeof(m2m_dvddesc_t)*ret->nchapters );
    ret->current_cell=NULL;
    ret->current_title_set=-1;
    ret->pos=0;

    handle_ifo=(m2m_ifo_t **)realloc(handle_ifo,(n_handle_ifo+1)*sizeof(m2m_ifo_t *));
    handle_ifo[n_handle_ifo]=ret;
    n_handle_ifo++;
    return ret;
}

m2m_playlist_entry_t * m2m_get_playlist_by_ifo( char *devicename )
{
    m2m_ifo_t * m2mifo=m2m_open_ifo( devicename );
    m2m_playlist_entry_t *ret=NULL;
    m2m_playlist_entry_t *cur=NULL;
    int i;

    if ( m2mifo == NULL || m2mifo->chapters == NULL || m2mifo->nchapters < 1 )
        return NULL;

    for( i=0 ; i<m2mifo->nchapters ; i++ ){
        if ( cur == NULL ){
            ret=cur=(m2m_playlist_entry_t*)malloc(sizeof(m2m_playlist_entry_t));
        }else{
            cur->next=(m2m_playlist_entry_t *)malloc(sizeof(m2m_playlist_entry_t));
            cur=cur->next;
        }
        cur->next=NULL;
        cur->name=m2mifo->chapters[i].name;
        cur->path=m2mifo->path;
        cur->isES=1;
        cur->descripter=&(m2mifo->chapters[i].desc);
        cur->st=0;
        cur->ed=0;
    }
    return ret;
}

m2m_playlist_entry_t * m2m_get_playlist_entry_by_chapter( char *devicename , char *name )
{
    m2m_ifo_t * m2mifo=m2m_open_ifo( devicename );
    int i;

    if ( m2mifo == NULL || m2mifo->chapters == NULL || m2mifo->nchapters < 1 )
        return NULL;

    for( i=0 ; i<m2mifo->nchapters ; i++ ){
        if ( strcmp(name,m2mifo->chapters[i].name) == 0 ){
            m2m_playlist_entry_t *ret =(m2m_playlist_entry_t*)
                                   malloc(sizeof(m2m_playlist_entry_t));
            ret->next=NULL;
            ret->name=m2mifo->chapters[i].name;
            ret->path=m2mifo->path;
            ret->isES=1;
            ret->descripter=&(m2mifo->chapters[i].desc);
            ret->st=0;
            ret->ed=0;
            return ret;
        }
    }
    return NULL;
}

/*
static inline int lba2chapter_index( m2m_ifo_t *m2mifo , __off64_t lba )
{
    int i=m2mifo->last_chapter;
    if ( i >= 0 && i < m2mifo->nchapters
     && lba >= m2mifo->chapters[i].desc.st
     && lba <= m2mifo->chapters[i].desc.ed )
        return i;
    while ( ++i < m2mifo->nchapters )
	if ( lba >= m2mifo->chapters[i].desc.st
	  && lba <= m2mifo->chapters[i].desc.ed )
            return m2mifo->last_chapter=i;
    i=m2mifo->last_chapter;
    while ( --i >= 0 )
	if ( lba >= m2mifo->chapters[i].desc.st
	  && lba <= m2mifo->chapters[i].desc.ed )
            return m2mifo->last_chapter=i;
    return m2mifo->last_chapter=i;
}

int lba2chapter( m2m_ifo_t *m2mifo , __off64_t lba )
{
    int i=lba2chapter_index(m2mifo,lba);
    return (i<0)?-1:m2mifo->chapters[i].title*256+m2mifo->chapters[i].chapter ;
}

__off64_t chapter_lba( m2m_ifo_t *m2mifo , __off64_t lba ,int offset_chapter )
{
    int i=lba2chapter_index(m2mifo,lba);
    if( i < 0 || i >= m2mifo->nchapters ) return -1;
    return m2mifo->chapters[i].desc.st;
}

int get_menu_vob( vob_file_t **menus )
{
    off64_t j;
    int i,nmenu,div_flg=0;
    struct AD file_entry;
    unsigned long int partition_offset=0,pos=0;
    vob_file_t wkvob[100];
    char titlename[32];
    nmenu=0;
    for( i=0;;i++ )
    {
        sprintf(titlename,"/VIDEO_TS/VTS_%02d_0.VOB",i+1 );
        if (!UDFFindFileEntry(0,titlename,&partition_offset,&file_entry) )
            break;
        if ( file_entry.Length < 2048 ) continue;
        wkvob[nmenu].lbnum = partition_offset+file_entry.Location;
        wkvob[nmenu].st = pos ;
        wkvob[nmenu].ed = (pos+=file_entry.Length/2048) ;
        wkvob[nmenu].name = "menu";
#if 0
fprintf( stderr,"menu %d:ln=%ld st=%ld ed=%ld \n",nmenu,(long)wkvob[nmenu].lbnum,(long)wkvob[nmenu].st,(long)wkvob[nmenu].ed );
        for ( j=0 ; j<file_entry.Length/2048 ; j++ )
        {
            unsigned char local_buf[2048];
            unsigned char *pes;
            if ( UDFReadLB( wkvob[nmenu].lbnum +j, 1,local_buf) != 2048 )
                break;
            pes = local_buf + 14 + (local_buf[13] & 7) ;
            if ( pes[0] != 0x00 || pes[1] != 0x00 || pes[2] != 0x01 )
                continue;

            if ( pes[3] == 0x0bb )
            {
                pes += ( pes[4] << 8 ) + pes[5] + 6 ;
                if ( pes[0] != 0x00 || pes[1] != 0x00 || pes[2] != 0x01 )
                        continue;
            }
        }
#endif
        if ( wkvob[nmenu].st  != wkvob[nmenu].ed ) nmenu++;
//fprintf( stderr,"menu %d:ln=%ld st=%ld ed=%ld \n",nmenu,(long)wkvob[nmenu].lbnum,(long)wkvob[nmenu].st,(long)wkvob[nmenu].ed );
    }

    *menus=(vob_file_t *)malloc( sizeof(vob_file_t)*nmenu );
    memcpy( *menus , wkvob , sizeof(vob_file_t)*nmenu );
    return nmenu;
}

void chapter2voblist( vob_file_t ** vobfiles ,int * in_nchapter , int * nmenus )
{
    int i;
    __off64_t pos=0;
    vob_file_t *menus=NULL;
    vob_file_t *ret=NULL;

    *in_nchapter=nchapter;
    if ( nchapter < 1 ) return;
    if ( nmenus )
    {
        *nmenus= get_menu_vob( &menus );
        ret=(vob_file_t *)malloc( sizeof(vob_file_t)*(nchapter+*nmenus) );
        memset ( ret,0x0, sizeof(vob_file_t)*(nchapter+*nmenus) );
    }
    else
    {
        ret=(vob_file_t *)malloc( sizeof(vob_file_t)*nchapter );
        memset( ret,0x0 , sizeof(vob_file_t)*nchapter );
    }

    for( i=0 ; i<nchapter ; i++ )
    {
        ret[i].lbnum = chapter_rec[i].lba_st ;
        ret[i].st = pos ;
        pos += chapter_rec[i].lba_ed - chapter_rec[i].lba_st + 1;
        ret[i].ed = pos ;
        ret[i].name = (char *)malloc( strlen(chapter_rec[i].name)+1 ); ;
        strcpy( ret[i].name , chapter_rec[i].name ); ;
    }

    for( ; nmenus && i<nchapter+*nmenus ; i++ )
    {
        ret[i].lbnum = menus[i-nchapter].lbnum ;
        ret[i].st = pos ;
        pos += menus[i-nchapter].ed - menus[i-nchapter].st + 1;
        ret[i].ed = pos ;
    }
    if ( menus ) free( menus );
    *vobfiles = ret;
    return ;
}
__off64_t *seekpos,int step,__off64_t lba_idx )
*/

