#!/bin/sh -x

rm -fR m2m m2rip m2div *.o core *.core config.* stamp* .deps .libs lib* *.m4 \
       p? configure configure.scan Makefile Makefile.in ltconfig ltmain.sh \
       intl drivers install-sh mkinstalldirs missing COPYING NEWS ABOUT-NLS \
       configure.in~ ChangeLog~ */Makefile confdefs.h manifest log \
       */*.o */*.lo */*.la */.libs */.deps m4/*
[ -f Makefile.am~ -a -f origs_diffs/m2rip.patch ] && patch -R < origs_diffs/m2rip.patch && rm -f Makefile.am~
rm -f m2rip.c*
[ "x$1" = "x--clean" ] && rm -f MANIFEST && find * -type f > MANIFEST
[ "x$1" = "x--clean" ] && exit 0

####### build directory
[ ! -d libm2m ] && mkdir libm2m

[ "x$ACLOCAL_M4_DIR" = "x"     ] && ACLOCAL_M4_DIR="/usr/share/aclocal"
[ "x$AUTOMAKE_DIR" = "x"       ] && AUTOMAKE_DIR="/usr/share/automake"
[ "x$LIBTOOL_DIR" = "x"        ] && LIBTOOL_DIR="/usr/share/libtool"
[ ! -d $ACLOCAL_M4_DIR         ] && exit 1
[ ! -d $AUTOMAKE_DIR           ] && exit 2
[ ! -d $LIBTOOL_DIR            ] && exit 3
[ -f $ACLOCAL_M4_DIR/glib.m4   ] && cat $ACLOCAL_M4_DIR/glib.m4 > acinclude.m4
[ -f $ACLOCAL_M4_DIR/gtk.m4    ] && cat $ACLOCAL_M4_DIR/gtk.m4 >> acinclude.m4
[ -f $AUTOMAKE_DIR/COPYING     ] && cp $AUTOMAKE_DIR/COPYING .
[ -f $AUTOMAKE_DIR/missing     ] && cp $AUTOMAKE_DIR/missing .
[ -f $AUTOMAKE_DIR/install-sh  ] && cp $AUTOMAKE_DIR/install-sh .
[ -f $AUTOMAKE_DIR/mkinstalldirs ] && cp $AUTOMAKE_DIR/mkinstalldirs .
[ -f $LIBTOOL_DIR/config.guess ] && cp $LIBTOOL_DIR/config.guess .
[ -f $LIBTOOL_DIR/config.sub   ] && cp $LIBTOOL_DIR/config.sub .
[ -f $LIBTOOL_DIR/ltconfig     ] && cp $LIBTOOL_DIR/ltconfig .
[ -f $LIBTOOL_DIR/ltmain.sh    ] && cp $LIBTOOL_DIR/ltmain.sh .
touch NEWS


####### for XFree86 4.0
LIBS_ADD=""
[ -f /usr/X11R6/lib/libXv.a ] && LIBS_ADD="-L/usr/X11R6/lib -lXv"

####### extract sources
SUBDIR="ac3dec css-auth dvd_udf ifo"
PATCH="m2m-diff1.patch"
for i in $SUBDIR 
do
  [ ! -d libm2m/$i -a -f origs_diffs/${i}*.tar.bz2 ] && (
   cd libm2m 
   bzip2 -dc ../origs_diffs/${i}*.tar.bz2 | tar xvf -
   [ -f ../origs_diffs/$PATCH ] && patch -p0 -b < ../origs_diffs/$PATCH
  ) 
  [ ! -d libm2m/$i -a -f origs_diffs/${i}*.tar.gz ] && (
   cd libm2m 
   gzip -dc ../origs_diffs/${i}*.tar.gz | tar xvf -
   [ -f ../origs_diffs/$PATCH ] && patch -p0 -b < ../origs_diffs/$PATCH
  ) 
  PATCH=`echo $PATCH|sed -e 's/6/7/' -e 's/5/6/' -e 's/4/5/' -e 's/3/4/' -e 's/f2/f3/' -e 's/1/2/' `
done

####### core modules
[ -d libm2m/ifo/src/libifo   ] && cp -r libm2m/ifo/src/libifo .
[ -d libm2m/css-auth -a ! -f Makefile.am~ ] && which m2rip > /dev/null 2>&1 && patch -b < origs_diffs/m2rip.patch

####### for aclocale
rm -f config.aclw
cp configure.in config.aclw 
if [ -f $ACLOCAL_M4_DIR/sdl.m4   ] ; then
  sed '1,$s/^dnl[ 	]*AM_PATH_SDL/  AM_PATH_SDL/' config.aclw > configure.in
else
  sed '1,$s/^[ 	]*AM_PATH_SDL/dnl &/' config.aclw > configure.in
fi
rm -f config.aclw
cp configure.in config.aclw 
if [ -f $ACLOCAL_M4_DIR/alsa.m4   ] ; then
  sed '1,$s/^dnl[ 	]*AM_PATH_ALSA/  AM_PATH_ALSA/' config.aclw > configure.in
else
  sed '1,$s/^[ 	]*AM_PATH_ALSA/dnl &/' config.aclw > configure.in
fi
rm -f config.aclw
cp configure.in config.aclw 
if [ -f $ACLOCAL_M4_DIR/esd.m4   ] ; then
  sed '1,$s/^dnl[ 	]*AM_PATH_ESD/  AM_PATH_ESD/' config.aclw > configure.in
else
  sed '1,$s/^[ 	]*AM_PATH_ESD/dnl &/' config.aclw > configure.in
fi
rm -f config.aclw

( cd libm2m ; sh ../mksyms )

mkdir m4
aclocal -I m4 || exit 4
gettextize     || exit 5
cp m2m.ja.po po/ja.po
cp Makevars po/.
\rm -f po/Makevars.template
ls -1 *.[ch] > po/POTFILES.in
autoconf       || exit 6
touch aclocal.m4
autoheader     || exit 7
automake       || exit 8

