/*
 *  m2m_thread.c:
 *     pthread(POSIX thread) routines.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#ifndef _LARGEFILE64_SOURCE
#define _LARGEFILE64_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif

#include <features.h>
#include <stdio.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <pthread.h>
#include <string.h>

#include "video_out/video_out.h"
#include <mpeg2dec/mpeg2.h>
#include <mpeg2dec/mm_accel.h>
#include "m2m.h"
#include <sys/types.h>
#include <dvd_udf.h>


/* current time stamp */
uint32_t volatile ts_v; /* video frame   DTS/PTS */
uint32_t volatile ts_a; /* audio(master) PTS  */
static struct timeval tv_a;
static struct timeval tv_v;


void *audio_thread( void *arg )
{
    extern void ao_play_pcm( void * ,void * , int );
    extern void  * audio_out_a52_init( void );
    extern void a52_decode_data (void * ,uint8_t * , uint8_t * );
    FILE *fp=NULL;
    m2m_buf_t * buf=NULL;
    // lpcm
    void  * ao= audio_out_a52_init();

    for(;;){
        if ( buf ) m2m_free_buffer( buf );
        buf= m2m_next_buffer( 0 );
if ( buf == NULL ) {
 sched_yield();
 continue;
}
        if ( buf->ts ){
extern int vcnt,acnt;
long slow;
          ts_a=buf->ts;
          gettimeofday( &tv_a,NULL);
          //slow=(tv_a.tv_sec-tv_v.tv_sec)*1000000.0+tv_a.tv_usec-tv_v.tv_usec;
          slow = (long)ts_a - (long)ts_v  - 500000L ;
          if ( slow > 100000L ) slow = 100000L;
          if ( slow < 10000L || ts_v == 0 || ts_a == 0 ) slow=0L;
          if ( slow > 100L ){
            m2m_check_fill_buffer( 0,0 );
            sched_yield();
            if ( slow > 1000L ) usleep( slow-1000L );
//fprintf(stderr,"          a     %8ld %8ld %8ld \n",ts_v,ts_a,slow );
          }
        }
//fprintf(stderr," TS(%lx) MPEG AUDIO\n",ts_a );
        if ( buf->ch +1 != audio_no ) continue;
        switch ( buf->type ){
          case 0x080: // a52
            a52_decode_data(ao,buf->pos,buf->pos+buf->len);
            break;
          case 0x0a0: // pcm
            ao_play_pcm( ao,buf->pos , buf->len/4);
            break;
          case 0x0c0: // mpeg
            if( fp==NULL ) fp=popen("mpg123 - ","w");
            fwrite(buf->pos,1,buf->len,fp);
            break;
        }

    }
}

static pthread_t m2m_thread[8];
static uint8_t do_thread_flag=0;
static void *(*m2m_thread_functions[8])(void *)={
        video_thread,
        audio_thread,
        m2m_reader_thread,
        NULL
};

inline int m2m_thread_control( int type,int isCreate )
{
    if( type >= 8 ) return;
    if ( isCreate )
    {
        pthread_attr_t attr;
        uint8_t        mask=1<<type;
        if ( mask&do_thread_flag )
            return;
        do_thread_flag |= mask;
        pthread_attr_init( &attr );
        pthread_attr_setscope( &attr , PTHREAD_SCOPE_SYSTEM );
        return pthread_create( m2m_thread+type , &attr  , m2m_thread_functions[type] , NULL );
    }
    else
    {
        uint8_t        mask=1<<type;
        do_thread_flag &= ~mask;
        pthread_join( m2m_thread[type] ,NULL );
        return 0;
    }
}

void *video_thread( void *arg )
{
    extern mpeg2dec_t mpeg2dec;
    extern int m2m_ad_sync;
    extern int m2m_ad_late;
    extern int m2m_ad_skip;
    int is_initialized;
    int i,n;
    int drop=100;
    int fcnt=0;
    int bcnt=0;
    int vfcnt=0;
    double usec;
    long slow=0L;
    struct timeval tv;
    struct timeval tv_bak;
    m2m_buf_t * buf=NULL;

    gettimeofday( &tv_bak,NULL );
    is_initialized=0;
    for ( ;; )
    {
        if ( buf ) m2m_free_buffer( buf );
        buf= m2m_next_buffer( 1 );
if ( buf == NULL ) {
 sched_yield();
 continue;
}
        n=mpeg2_decode_data(&mpeg2dec,buf->pos,buf->pos+buf->len );
        if ( buf->ts ){
          extern mpeg2dec_t mpeg2dec;

          ts_v=buf->ts;
          gettimeofday( &tv_v,NULL );
          slow=(tv_v.tv_sec-tv_a.tv_sec)*1000000L+tv_v.tv_usec-tv_a.tv_usec
             +(long)ts_v -(long)ts_a ;
          drop=slow/22000L+14L ;
fprintf(stderr,"           v    %8ld %8ld %8ld %ld %lf\n",ts_v,ts_a,slow,drop,12.0/drop );
          fcnt=bcnt=0;
          if ( slow > 1000000L ) slow = 1000000L;
          if ( slow < 0L || ts_v == 0 || ts_a == 0 ) slow=0L;
          slow /= 4L;
        }
        if( n ){
          if ( ((++fcnt)&3) != 1 )
          if ( ++bcnt > drop ){
            mpeg2_drop (&mpeg2dec, -1 );
            bcnt=0;
          }else{
            mpeg2_drop (&mpeg2dec, 0 );
          }
          if ( slow > 0L ){
            usleep( slow*n );
          }
          gettimeofday( &tv,NULL );
          if ( ts_v > ts_a ){
            usec = n*33333L
                 -(tv.tv_sec-tv_bak.tv_sec)*1000000L+tv.tv_usec-tv_bak.tv_usec;
if ( usec > 0.0 ) fprintf(stderr,"%8ld\n",usec );
            if ( usec > n*66666 ) usleep(n*66666);
            else
            if ( usec > 1000L ) usleep(usec-1000L);
          }
          tv_bak=tv;
        }
    }
    return NULL;
}


