/*
 *  m2m_main.c:
 *     main and GUI.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Mar 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */

#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199506L
#endif
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  500
#endif

#include <pthread.h>
#include <sys/time.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <locale.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtk/gtkenums.h>
#include "pics/menu.xpm"
#include "pics/play.xpm"
#include "pics/step.xpm"
#include "pics/rew.xpm"
#include "pics/prev.xpm"
#include "pics/next.xpm"
#include "pics/loop.xpm"
#include "pics/no_loop.xpm"
#include "pics/window.xpm"
#include "config.h"
#include "m2m.h"
#include "m2m_command.h"

#define FABS(X) ((X)>=0.0)?(X):-(X)
#define TOL 10.0

static GtkAdjustment *adjust_time=NULL;
static GtkAdjustment *adjust_brightness=NULL;
static GtkAdjustment *adjust_contrast=NULL;
static GtkAdjustment *adjust_audio_no=NULL;
static GtkAdjustment *adjust_ad_sync=NULL;
static GtkAdjustment *adjust_ad_late=NULL;
static GtkAdjustment *adjust_ad_skip=NULL;
static GtkLabel *pg_echo=NULL;
static GtkWidget *handles[5];

static int child_pid=-1;
static int pipe_in=-1;
static int pipe_out=-1;
static struct ip_mreq stMreq;
static int id=-1;
static char **list=NULL;
static char *dvd_device=NULL;

static inline void m2m_leave_caster(){
  setsockopt(pipe_in, IPPROTO_IP, IP_DROP_MEMBERSHIP, (char*) &stMreq, sizeof(stMreq));
  close(pipe_in);
  if ( pipe_in != pipe_out ) close(pipe_out);
  pipe_in=pipe_out=-1;
}

static inline int m2m_connect2caster( char ip_addr[] , unsigned short port )
{
  struct sockaddr_in addr;
  int status;
  if ( pipe_in != -1 ) m2m_leave_caster();
  pipe_in = socket(PF_INET, SOCK_STREAM , 0);
  if ( pipe_in == -1 ){ perror("socket"); return -1; }
  pipe_out=pipe_in;
  memset(&addr, 0, sizeof(addr));
  addr.sin_port = htons(port);
  addr.sin_family = AF_INET;
  status = inet_pton( AF_INET,ip_addr,&addr.sin_addr );
  if ( status == 0 ){
    struct hostent * entry=gethostbyname(ip_addr);
    if ( entry ){
      addr.sin_addr.s_addr =*((in_addr_t *)entry->h_addr_list[0]);
      //free(entry);
    }
  }
  status = connect( pipe_in, (struct sockaddr *)&addr, sizeof(addr));
  if ( status == -1 ) {
    system("m2caster &");
    sleep(2);
    status = connect( pipe_in, (struct sockaddr *)&addr, sizeof(addr));
    if ( status == -1 ) {
      perror("connect:");
      return -4;
    }
  }
  pipe_out=pipe_in;
  return 0;
}

/* public function */
void sync_adjust_value(float v)
{
    if( adjust_time )
        gtk_adjustment_set_value( adjust_time, 0 );
}
void set_brightness(int v)
{
}
void set_contrast(int v)
{
}

void chapter_echo( int chapter_no , int number_of_chapter )
{
    char str[32];
#ifdef M2M_OLD_PULLDOWN
    GtkWidget *menu=NULL;
    while ( pg_pulldown == NULL ) sched_yield();
    menu=gtk_option_menu_get_menu( pg_pulldown ) ;
    sprintf( str,"%02d/%02d ",chapter_no,number_of_chapter );
    gtk_label_set_text( GTK_LABEL(pg_pulldown->button.child),str );
    gtk_menu_set_active( GTK_MENU(menu) , chapter_no-1 );
#else
    sprintf( str,"%02d/%02d ",chapter_no,number_of_chapter );
    gtk_label_set_text( pg_echo,str );
#endif

}

/* private functions */
static void destroy( GtkWidget *widget, gpointer   data )
{
    m2m_leave_caster();
    if( child_pid > 0 ) kill(child_pid,SIGHUP);
    gtk_main_quit();
}

static gint delete_event( GtkWidget *widget, GdkEvent *event, gpointer data )
{
    destroy( widget, data );
    return TRUE ;
}

static void loop_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    static GtkWidget *loop_l=NULL;
    GdkBitmap *mask;
    GdkPixmap *pixmap;
    GDK_THREADS_ENTER();
    if ( loop_l ) gtk_container_remove( GTK_CONTAINER(widget),loop_l );
    loop_l=NULL;

    if ( 1 )
    {
        pixmap=gdk_pixmap_create_from_xpm_d( widget->window,
                                             &mask,NULL,loop_xpm );
        loop_l=gtk_pixmap_new( pixmap , mask );
        gtk_widget_show( loop_l );
        gtk_container_add( GTK_CONTAINER(widget),loop_l );
    }
    else
    {
        pixmap=gdk_pixmap_create_from_xpm_d( widget->window,
                                             &mask,NULL,no_loop_xpm );
        loop_l=gtk_pixmap_new( pixmap , mask );
        gtk_widget_show( loop_l );
        gtk_container_add( GTK_CONTAINER(widget),loop_l );
    }
    gtk_widget_show( widget );
    GDK_THREADS_LEAVE();
}

static void window_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    //vo_instance->next_window_mode(vo_instance);
}

static void tool_cb( GtkWidget *widget, int no )
{
    static char *show_names[]={
            "menu bar" ,
            "Show controller buttons" ,
            "Show program select buttons" ,
            "Show indicator" ,
            "Show advanced controlls"
    };
    static char *hide_names[]={
            "menu bar" ,
            "Hide controller buttons" ,
            "Hide program select buttons" ,
            "Hide indicator" ,
            "Hide advanced controlls"
    };
    static GtkWidget *labels[]={NULL,NULL,NULL,NULL,NULL};
    static int show_flag[]={1,1,1,1,0};
    if ( labels[no] ) gtk_container_remove( GTK_CONTAINER(widget),labels[no] );
    labels[no]=NULL;
    labels[no]=gtk_label_new( show_flag[no]?show_names[no]:hide_names[no] );
    gtk_widget_show( labels[no] );
    gtk_container_add( GTK_CONTAINER(widget),labels[no] );
    show_flag[no]=1-show_flag[no];
    if ( show_flag[no] ) gtk_widget_show( handles[no] );
    else                 gtk_widget_hide( handles[no] );
}
static void tool1_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    tool_cb( widget, 1 );
}
static void tool2_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    tool_cb( widget, 2 );
}
static void tool3_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    tool_cb( widget, 3 );
}
static void tool4_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    tool_cb( widget, 4 );
}

static void map_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    char **xpm[]={ menu_xpm,play_xpm,step_xpm,prev_xpm,rew_xpm,next_xpm,loop_xpm,window_xpm,NULL };
    char *label[]={ NULL,NULL   , NULL   , NULL   , NULL  , NULL   ,NULL,NULL };
    int n=1+(int)data;
    GtkWidget *inner_widget;
    if ( n<0 )
    {
        tool_cb( widget, -n );
        tool_cb( widget, -n );
        return;
    }
    if ( xpm[n] == loop_xpm )
    {
        loop_cb( widget, event, data );
        loop_cb( widget, event, data );
        return;
    }
    if ( xpm[n] )
    {
        GdkBitmap *mask;
        GdkPixmap *pixmap;
        pixmap=gdk_pixmap_create_from_xpm_d(widget->window,&mask,NULL,xpm[n]);
        inner_widget=gtk_pixmap_new( pixmap , mask );
    }
    else
    {
        inner_widget=gtk_label_new( label[n] );
    }
    gtk_widget_show( inner_widget );
    gtk_container_add( GTK_CONTAINER(widget),inner_widget );
    gtk_widget_show( widget );
}

static void menu_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
}

static void b1_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
  int status;
  char **result=NULL;
  char *ip=m2m_get_property("CAST_IP") ;
  int play_status;
  int port=atoi(m2m_get_property("CAST_PORT"));

  if ( m2m_connect2caster( ip ,port ) < 0 ) return;
  status= request_command(pipe_in,pipe_out,id,M2M_CMD_GET_CURRENT_INFO,NULL,&result);
  m2m_leave_caster();
  if ( status < 0 || result == NULL || result[0] == NULL ){
    free_result( &result );
    return;
  }
  sscanf(result[0],"%ld",&play_status);
  free_result( &result );
  if ( play_status !=0 && play_status != 1 ) return;

  if ( m2m_connect2caster( ip ,port ) < 0 ) return;
  status= request_command(pipe_in,pipe_out,id,play_status?M2M_CMD_PAUSE:M2M_CMD_START,NULL,&result);
  m2m_leave_caster();
  free_result( &result );

}

static void b2_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
}

static void b3_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
  char **result=NULL;
  char *ip=m2m_get_property("CAST_IP") ;
  int port=atoi(m2m_get_property("CAST_PORT"));
  if ( m2m_connect2caster( ip ,port ) < 0 ) return;
  request_command(pipe_in,pipe_out,id,M2M_CMD_JUMP_TITLE,"-1",&result);
  m2m_leave_caster();
  free_result( &result );
}

static void b4_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
  char **result=NULL;
  char *ip=m2m_get_property("CAST_IP") ;
  int port=atoi(m2m_get_property("CAST_PORT"));
  if ( m2m_connect2caster( ip ,port ) < 0 ) return;
  request_command(pipe_in,pipe_out,id,M2M_CMD_JUMP_TITLE,"+0",&result);
  m2m_leave_caster();
  free_result( &result );
}

static void b5_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
  char **result=NULL;
  char *ip=m2m_get_property("CAST_IP") ;
  int port=atoi(m2m_get_property("CAST_PORT"));
  if ( m2m_connect2caster( ip ,port ) < 0 ) return;
  request_command(pipe_in,pipe_out,id,M2M_CMD_JUMP_TITLE,"+1",&result);
  m2m_leave_caster();
  free_result( &result );
}

static void pgpd_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    int i = (int)gtk_object_get_data( GTK_OBJECT (widget), "no" );
}
static void pgbtn_cb( GtkWidget *widget, GdkEvent *event, gpointer   data )
{
    int i ,idx;
    GList *child = gtk_container_children( GTK_CONTAINER(widget->parent) );
    for ( i=0,idx=-1 ; child ; i++ ) {
        if ( child->data == widget ) idx=i;
        child = g_list_remove_link( child,child );
    }
    if ( idx >= 0 ){
      char buf[32];
      char **result=NULL;
      char *ip=m2m_get_property("CAST_IP") ;
      int port=atoi(m2m_get_property("CAST_PORT"));
      sprintf(buf,"%ld",idx);
      if ( m2m_connect2caster( ip ,port ) < 0 ) return;
      request_command(pipe_in,pipe_out,id,M2M_CMD_JUMP_TITLE,buf,&result);
      m2m_leave_caster();
      free_result( &result );
    }

}

static void an_cb( GtkObject *obj, gpointer   data )
{
}
static void br_cb( GtkObject *obj, gpointer   data )
{
}
static void cn_cb( GtkObject *obj, gpointer   data )
{
}
static void ad_sync_cb( GtkObject *obj, gpointer   data )
{
}
static void ad_late_cb( GtkObject *obj, gpointer   data )
{
}
static void ad_skip_cb( GtkObject *obj, gpointer   data )
{
}

static void sc_cb( GtkObject *obj, gpointer   data )
{
}

static int adjustor_sync( void *arg )
{
    sync_adjust_value(0);
    return TRUE;
}

static int panel_create( int argc, char *argv[] )
{
    int i;
    long ed=0L;
    GtkWidget *window;
    GtkWidget *form1;
    GtkWidget *form2;
    GtkWidget *form3;
    GtkWidget *spin;
    GtkWidget *scale;
    GtkWidget *button;
    GtkWidget *menubar;
    GtkWidget *submenu;
    GtkWidget *item;
    GtkTooltips *tip;
    GtkAccelGroup *accel;

fprintf(stderr,"ed=%ld\n",ed );
    gtk_set_locale();
    gtk_init(&argc, &argv);
    gtk_rc_parse("~/.gtkrc");
    tip = gtk_tooltips_new();
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

    accel = gtk_accel_group_new();
    gtk_window_add_accel_group( GTK_WINDOW(window),accel );

    //gtk_widget_set_usize( GTK_WIDGET ( window ) , 500 , 60 );
    gtk_signal_connect( GTK_OBJECT (window), "delete_event",
                        GTK_SIGNAL_FUNC (delete_event), NULL);
    gtk_signal_connect( GTK_OBJECT (window), "destroy_event",
                        GTK_SIGNAL_FUNC (destroy), NULL);
    gtk_signal_connect( GTK_OBJECT (window), "destroy",
                        GTK_SIGNAL_FUNC (destroy), NULL);
    gtk_container_set_border_width (GTK_CONTAINER (window), 0);
    handles[1]=gtk_handle_box_new();
    form1=gtk_vbox_new(0,0);
    form2=gtk_hbox_new(0,0);
    gtk_container_set_border_width (GTK_CONTAINER (form1), 0);
    gtk_container_set_border_width (GTK_CONTAINER (form2), 4);
    gtk_container_add (GTK_CONTAINER (window), form1);

    adjust_audio_no = (GtkAdjustment *)gtk_adjustment_new(1,
                                                 1, 9, 1, 1, 1 );
    adjust_brightness = (GtkAdjustment *)gtk_adjustment_new( 128,
                                                 0, 255, 1, 5, 10 );
    adjust_contrast = (GtkAdjustment *)gtk_adjustment_new( 128,
                                                 0, 256, 1, 5, 10 );
    adjust_ad_sync = (GtkAdjustment *)gtk_adjustment_new(500,
                                                 0, 999, 1, 5, 10 );
    adjust_ad_late = (GtkAdjustment *)gtk_adjustment_new(500,
                                                 0, 999, 1, 5, 10 );
    adjust_ad_skip = (GtkAdjustment *)gtk_adjustment_new( 500,
                                                 0, 999, 1, 5, 10 );
    gtk_signal_connect( GTK_OBJECT (adjust_audio_no), "value_changed",
                        GTK_SIGNAL_FUNC (an_cb), NULL);
    gtk_signal_connect( GTK_OBJECT (adjust_brightness), "value_changed",
                        GTK_SIGNAL_FUNC (br_cb), NULL);
    gtk_signal_connect( GTK_OBJECT (adjust_contrast), "value_changed",
                        GTK_SIGNAL_FUNC (cn_cb), NULL);
    gtk_signal_connect( GTK_OBJECT (adjust_ad_sync), "value_changed",
                        GTK_SIGNAL_FUNC (ad_sync_cb), NULL);
    gtk_signal_connect( GTK_OBJECT (adjust_ad_late), "value_changed",
                        GTK_SIGNAL_FUNC (ad_late_cb), NULL);
    gtk_signal_connect( GTK_OBJECT (adjust_ad_skip), "value_changed",
                        GTK_SIGNAL_FUNC (ad_skip_cb), NULL);
    adjust_time = (GtkAdjustment *)gtk_adjustment_new(0, 0, ed, 1, 5, 10);
    gtk_signal_connect( GTK_OBJECT (adjust_time), "value_changed",
                        GTK_SIGNAL_FUNC (sc_cb), NULL);
    if ( 1 )
    {
        button = gtk_button_new();
        gtk_signal_connect( GTK_OBJECT (button), "map_event",
                            GTK_SIGNAL_FUNC (map_cb), (gpointer)-1 );
        gtk_signal_connect( GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (menu_cb), NULL );
        gtk_box_pack_start( GTK_BOX (form2), button,FALSE,FALSE,0 );
        gtk_widget_show ( button );
        gtk_tooltips_set_tip(tip,button,_("menu"),"");
    }
    for( i=0 ; ; i++ )
    {
        void (*cb[])(GtkWidget*,GdkEvent*,gpointer)=
                 {b1_cb,b2_cb,b3_cb,b4_cb,b5_cb,loop_cb,window_cb,NULL};
        if ( cb[i] == NULL ) break;
        button = gtk_button_new();
        gtk_signal_connect( GTK_OBJECT (button), "map_event",
                            GTK_SIGNAL_FUNC (map_cb), (gpointer)i );
        gtk_signal_connect( GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (cb[i]), NULL );
        gtk_box_pack_start( GTK_BOX (form2), button,FALSE,FALSE,0 );
        gtk_widget_show ( button );
        switch(i)
        {
            case 0: gtk_tooltips_set_tip(tip,button,_("play/stop"),""); break;
            case 1: gtk_tooltips_set_tip(tip,button,_("step")     ,""); break;
            case 2: gtk_tooltips_set_tip(tip,button,_("prev")     ,""); break;
            case 3: gtk_tooltips_set_tip(tip,button,_("rewind")   ,""); break;
            case 4: gtk_tooltips_set_tip(tip,button,_("next")     ,""); break;
            case 5: gtk_tooltips_set_tip(tip,button,_("loop")     ,""); break;
            case 6: gtk_tooltips_set_tip(tip,button,_("disp mode"),""); break;
        }
        if( i == 3 )
        {
#ifdef M2M_OLD_PULLDOWN
            GtkMenu *menu;
            int pg,npg;
            pg_pulldown = GTK_OPTION_MENU(button = gtk_option_menu_new()) ;
            menu=GTK_MENU(gtk_menu_new());
            npg=get_number_of_chapter();
            for( pg=0 ; pg<npg ; pg++ )
            {
                char str[32];
                sprintf( str,"%02d/%02d ",pg+1,npg );
                item=gtk_menu_item_new_with_label(str);
                gtk_object_set_data( GTK_OBJECT (item), "no",(gpointer)pg );
                gtk_signal_connect( GTK_OBJECT (item), "activate",
                                    GTK_SIGNAL_FUNC (pgpd_cb), NULL );
                gtk_menu_append( menu,item );
                gtk_widget_show ( item );
            }
            gtk_option_menu_set_menu(GTK_OPTION_MENU(button),GTK_WIDGET(menu));
            gtk_widget_show ( GTK_WIDGET(menu) );
            gtk_box_pack_start( GTK_BOX (form2), button,FALSE,FALSE,0 );
            gtk_widget_show ( button );
            gtk_tooltips_set_tip(tip,button,_("program"),"");
#else
            pg_echo = GTK_LABEL(gtk_label_new("00/00"));
            gtk_widget_show ( GTK_WIDGET(pg_echo) );
            gtk_box_pack_start( GTK_BOX(form2),GTK_WIDGET(pg_echo),
                                FALSE,FALSE,0);
#endif
        }
    }
    spin = gtk_spin_button_new( GTK_ADJUSTMENT(adjust_audio_no),0,0 );
    gtk_spin_button_set_wrap( GTK_SPIN_BUTTON(spin),FALSE );
    gtk_box_pack_start (GTK_BOX (form2), spin, FALSE,FALSE,0 );
    gtk_widget_show ( spin );
    gtk_tooltips_set_tip(tip,spin,_("audio track"),"");
    spin = gtk_spin_button_new( GTK_ADJUSTMENT(adjust_brightness),0,0 );
    gtk_spin_button_set_wrap( GTK_SPIN_BUTTON(spin),FALSE );
    gtk_box_pack_start (GTK_BOX (form2), spin, FALSE,FALSE,0 );
    gtk_widget_show ( spin );
    gtk_tooltips_set_tip(tip,spin,_("brightness"),"");
    spin = gtk_spin_button_new( GTK_ADJUSTMENT(adjust_contrast),0,0 );
    gtk_spin_button_set_wrap( GTK_SPIN_BUTTON(spin),FALSE );
    gtk_box_pack_start (GTK_BOX (form2), spin, FALSE,FALSE,0 );
    gtk_widget_show ( spin );
    gtk_tooltips_set_tip(tip,spin,_("contrast"),"");
    gtk_widget_show( form2 );
    gtk_container_add( GTK_CONTAINER(handles[1]),form2 );
    gtk_widget_show( handles[1] );

    handles[2]=gtk_handle_box_new();
    form2=gtk_scrolled_window_new( NULL,NULL );
    gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW(form2),
                             GTK_POLICY_ALWAYS,GTK_POLICY_NEVER );
    form3=gtk_hbox_new(0,0);
    gtk_container_set_border_width (GTK_CONTAINER (form3), 0);
    for( i=0 ; list && list[i] ; i++ )
    {
       char str[32];
       sprintf( str,"%02d",i+1 );
       button=gtk_button_new_with_label(str);
       gtk_signal_connect( GTK_OBJECT (button), "clicked",
                           GTK_SIGNAL_FUNC (pgbtn_cb), NULL );
       gtk_tooltips_set_tip(tip,button,list[i],"");
       gtk_box_pack_start (GTK_BOX (form3), button, FALSE,FALSE,0 );
       gtk_widget_show ( button );
    }
    gtk_widget_show( form3 );
    gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW(form2),form3 );
    gtk_widget_show( form2 );
    gtk_container_add( GTK_CONTAINER(handles[2]),form2 );
    gtk_widget_show( handles[2] );

    handles[3]=gtk_handle_box_new();
    scale = gtk_hscale_new( GTK_ADJUSTMENT(adjust_time) );
    gtk_widget_set_usize( GTK_WIDGET ( scale ) , 480 , 24 );
    gtk_scale_set_draw_value( GTK_SCALE( scale ) , FALSE );
    gtk_scale_set_value_pos( GTK_SCALE(scale), GTK_POS_LEFT );
    gtk_widget_show( scale );
    gtk_container_add( GTK_CONTAINER(handles[3]),scale );
    gtk_widget_show( handles[3] );

    handles[4]=gtk_handle_box_new();
    form2=gtk_hbox_new(0,0);
    gtk_container_set_border_width (GTK_CONTAINER (form2), 0);
    gtk_container_add( GTK_CONTAINER(handles[4]),form2 );
    spin = gtk_spin_button_new( GTK_ADJUSTMENT(adjust_ad_sync),0,0 );
    gtk_spin_button_set_wrap( GTK_SPIN_BUTTON(spin),FALSE );
    gtk_box_pack_start (GTK_BOX (form2), spin, FALSE,FALSE,0 );
    gtk_widget_show ( spin );
    gtk_tooltips_set_tip(tip,spin,_("sync"),"");
    spin = gtk_spin_button_new( GTK_ADJUSTMENT(adjust_ad_late),0,0 );
    gtk_spin_button_set_wrap( GTK_SPIN_BUTTON(spin),FALSE );
    gtk_box_pack_start (GTK_BOX (form2), spin, FALSE,FALSE,0 );
    gtk_widget_show ( spin );
    gtk_tooltips_set_tip(tip,spin,_("late"),"");
    spin = gtk_spin_button_new( GTK_ADJUSTMENT(adjust_ad_skip),0,0 );
    gtk_spin_button_set_wrap( GTK_SPIN_BUTTON(spin),FALSE );
    gtk_box_pack_start (GTK_BOX (form2), spin, FALSE,FALSE,0 );
    gtk_widget_show ( spin );
    gtk_tooltips_set_tip(tip,spin,_("skip"),"");
    gtk_widget_show( form2 );

    handles[0]=gtk_handle_box_new();
    menubar=gtk_menu_bar_new();
    submenu=gtk_menu_new();
    item=gtk_menu_item_new_with_label( "Quit" );
    gtk_menu_append( GTK_MENU(submenu),item );
    gtk_widget_add_accelerator( item,"activate",accel,'Q',GDK_CONTROL_MASK,1 );
    gtk_signal_connect( GTK_OBJECT (item), "activate",
                        GTK_SIGNAL_FUNC (destroy), NULL);
    gtk_widget_show(item);
    item=gtk_menu_item_new_with_label( "File" );
    gtk_widget_show(item);
    gtk_menu_item_set_submenu( GTK_MENU_ITEM(item),submenu );
    gtk_menu_bar_append( GTK_MENU_BAR(menubar),item );
    submenu=gtk_menu_new();
    item=gtk_menu_item_new_with_label( "Preferences..." );
    gtk_menu_append( GTK_MENU(submenu),item );
    //gtk_signal_connect( GTK_OBJECT (item), "activate",
    //                    GTK_SIGNAL_FUNC (pref_cb), NULL);
    gtk_widget_show(item);
    item=gtk_menu_item_new_with_label( "Edit" );
    gtk_widget_show(item);
    gtk_menu_item_set_submenu( GTK_MENU_ITEM(item),submenu );
    gtk_menu_bar_append( GTK_MENU_BAR(menubar),item );
    submenu=gtk_menu_new();
    item=gtk_menu_item_new( );
    gtk_menu_append( GTK_MENU(submenu),item );
    gtk_signal_connect( GTK_OBJECT (item), "activate",
                        GTK_SIGNAL_FUNC (tool1_cb), NULL );
    gtk_signal_connect( GTK_OBJECT (item), "map_event",
                        GTK_SIGNAL_FUNC (map_cb), (gpointer)-2 );
    gtk_widget_show(item);
    item=gtk_menu_item_new( );
    gtk_menu_append( GTK_MENU(submenu),item );
    gtk_signal_connect( GTK_OBJECT (item), "activate",
                        GTK_SIGNAL_FUNC (tool2_cb), NULL );
    gtk_signal_connect( GTK_OBJECT (item), "map_event",
                        GTK_SIGNAL_FUNC (map_cb), (gpointer)-3 );
    gtk_widget_show(item);
    item=gtk_menu_item_new( );
    gtk_menu_append( GTK_MENU(submenu),item );
    gtk_signal_connect( GTK_OBJECT (item), "activate",
                        GTK_SIGNAL_FUNC (tool3_cb), NULL );
    gtk_signal_connect( GTK_OBJECT (item), "map_event",
                        GTK_SIGNAL_FUNC (map_cb), (gpointer)-4 );
    gtk_widget_show(item);
    item=gtk_menu_item_new( );
    gtk_menu_append( GTK_MENU(submenu),item );
    gtk_signal_connect( GTK_OBJECT (item), "activate",
                        GTK_SIGNAL_FUNC (tool4_cb), NULL );
    gtk_signal_connect( GTK_OBJECT (item), "map_event",
                        GTK_SIGNAL_FUNC (map_cb), (gpointer)-5 );
    gtk_widget_show(item);
    item=gtk_menu_item_new_with_label( "Tool" );
    gtk_widget_show(item);
    gtk_menu_item_set_submenu( GTK_MENU_ITEM(item),submenu );
    gtk_menu_bar_append( GTK_MENU_BAR(menubar),item );
    submenu=gtk_menu_new();
    item=gtk_menu_item_new_with_label( "About..." );
    gtk_menu_append( GTK_MENU(submenu),item );
    //gtk_signal_connect( GTK_OBJECT (item), "activate",
    //                    GTK_SIGNAL_FUNC (about_cb), NULL);
    gtk_widget_show(item);
    item=gtk_menu_item_new_with_label( "Help" );
    gtk_widget_show(item);
    gtk_menu_item_set_submenu( GTK_MENU_ITEM(item),submenu );
    gtk_menu_bar_append( GTK_MENU_BAR(menubar),item );
    gtk_widget_show( menubar );
    gtk_container_add( GTK_CONTAINER(handles[0]),menubar );
    gtk_widget_show( handles[0] );

    gtk_box_pack_start (GTK_BOX (form1), handles[0], FALSE,FALSE,0 );
    gtk_box_pack_start (GTK_BOX (form1), handles[1], FALSE,FALSE,0 );
    gtk_box_pack_start (GTK_BOX (form1), handles[2], TRUE,FALSE,3 );
    gtk_box_pack_start (GTK_BOX (form1), handles[3], TRUE,FALSE,3 );
    gtk_box_pack_start (GTK_BOX (form1), handles[4], TRUE,TRUE,3 );
    gtk_range_set_update_policy( GTK_RANGE(scale), GTK_UPDATE_DELAYED );
    gtk_widget_show( form1 );
    if ( 1 )
        gtk_widget_show( window );
    gtk_timeout_add(1000,adjustor_sync,NULL );
    return 0;
}

static void replace_intvalue( char *p , int *val )
{
    int new_val,i;
    for ( new_val=0,i=0 ; p[i] >= '0' && p[i] <= '9' ; i++ ) 
        new_val = new_val * 10 + p[i] - '0' ;
    if ( new_val > 0 && val ) *val=new_val;
}

static void m2m_sighanhler( int signum )
{
  m2m_leave_caster();
  if( child_pid > 0 ) kill(child_pid,SIGHUP);
  gtk_main_quit();
  exit(1);
}


static inline int m2m_join2caster( char ip_addr[] , unsigned short port )
{
  char **result=NULL;
  int status;
  if ( m2m_connect2caster( ip_addr , port ) < 0 ) return -1 ;
  status= request_command(pipe_in,pipe_out,0,M2M_CMD_GET_LINSTENER_LIST,NULL,&result);
  m2m_leave_caster();
  if ( status < 0 || result == NULL || result[0] == NULL ){
    free_result( &result );
    if ( (child_pid=fork()) == 0 ){ // child
      static char arg1[32];
      static char arg2[32];
      static char *args[]={"m2listener","--pause","-h",arg1,"-p",arg2,NULL};
      snprintf( arg1,sizeof(arg1),"%s",ip_addr );
      snprintf( arg2,sizeof(arg2),"%d",port );
      execvp("m2listener",args);
      perror("execvp");
      exit(-1);
    }else if ( child_pid == -1 ){
      perror("fork:");
      fprintf(stderr,"can not start listener\n" );
      return -4;
    }
    sleep(2);
    if ( m2m_connect2caster( ip_addr , port ) < 0 ) return -1 ;
    status= request_command(pipe_in,pipe_out,0,M2M_CMD_GET_LINSTENER_LIST,NULL,&result);
    m2m_leave_caster();
    if ( result == NULL || result[0] == NULL ){
      fprintf(stderr,"no listener\n" );
      free_result( &result );
      return -5;
    }
  }
  id=atoi(result[0]);
  free_result( &result );

  if ( dvd_device ){
    if ( m2m_connect2caster( ip_addr , port ) < 0 ) return -1 ;
    status= request_command(pipe_in,pipe_out,id,M2M_CMD_ATTACH_DVD,dvd_device,&result);
    m2m_leave_caster();
    free_result( &result );
  }

  if ( m2m_connect2caster( ip_addr , port ) < 0 ) return -1 ;
  status= request_command(pipe_in,pipe_out,id,M2M_CMD_GET_PLAYLIST,NULL,&result);
  m2m_leave_caster();
  if ( status < 0 || result == NULL || result[0] == NULL ){
    fprintf(stderr,"no playlist.%d %d %d\n",status,result,result[0] );
    free_result( &result );
    return -6;
  }
  list=result;

  return 0;
}

static inline int handle_args( int argc,char *argv[] )
{
  int i;
  int show_prop=0;
  int help=0;
  uint16_t port=0;
  char * host=NULL;
  char * prop=NULL;

  for ( i=1 ; i< argc ; i++ )
  {
      if( argv[i][0] != '-' )
      {
          continue;
      }
      if( strncmp(argv[i],"--device=",9) == 0 && argv[i][9] != 0x0 )
      {
          dvd_device = argv[i]+9;
      }else
      if ( strcmp(argv[i],"--device") == 0 || strcmp(argv[i],"-d") == 0 )
      {
          dvd_device="/dev/dvd";
          if ( i+1 < argc && argv[i+1][0] != '-' )
          {
              i++;
              dvd_device=argv[i];
          }
      }else
      if( strncmp(argv[i],"--host=",9) == 0 && argv[i][9] != 0x0 )
      {
          host = argv[i]+9;
      }else
      if ( strcmp(argv[i],"--host") == 0 || strcmp(argv[i],"-h") == 0 
       &&  i+1 < argc && argv[i+1][0] != '-' )
      {
          i++;
          host=argv[i];
      }else
      if( strncmp(argv[i],"--port=",9) == 0 && argv[i][9] != 0x0 )
      {
          port = atol(argv[i]+9);
      }else
      if ( strcmp(argv[i],"--port") == 0 || strcmp(argv[i],"-p") == 0 
       &&  i+1 < argc && argv[i+1][0] != '-' )
      {
          i++;
          port=atol(argv[i]);
      }else
      if ( strcmp(argv[i],"--conf") == 0 && i+1 < argc && argv[i+1][0] != '-' )
      {
          i++;
          prop=argv[i];
      }else
      if ( strcmp(argv[i],"--showconf") == 0 )
      {
          show_prop=1;
      }else
      if ( strcmp(argv[i],"--help") == 0 || strcmp(argv[i],"-h") == 0 )
      {
          help=1;
      }
  }
  m2m_load_properties( prop );
  if( host ) m2m_set_property( "CAST_IP",host );
  if( port ){
    char wk[8];
    snprintf(wk,8,"%d",port);
    m2m_set_property( "CAST_PORT",wk );
  }
  if ( show_prop ) m2m_write_properties( 1 );
  if ( help ) {
    printf( "Usage:%s - \n",argv[0] );
    printf( "Usage:%s files... \n",argv[0] );
    printf( "Usage:%s options... \n",argv[0] );
    printf( "options:\n" );
    printf( "  -d device                 : dvd device.\n" );
    printf( "  --device=devicename       : dvd device.\n" );
    printf( "  -t titleno                : start title no.\n" );
    printf( "  -title=titleno            : start title no.\n" );
    printf( "  -h caster_host            : connect caster.\n" );
    printf( "  --host=caster_host        : connect caster.\n" );
    printf( "  -p caster_port            : connect caster.\n" );
    printf( "  --port=caster_port        : connect caster.\n" );
    printf( "  --help                    : this message.\n" );
    exit(0);
  }
  return 0;
}

int main( int argc,char *argv[] ){
    if ( handle_args( argc,argv ) == 0
      && m2m_join2caster( m2m_get_property("CAST_IP") ,
                          atoi(m2m_get_property("CAST_PORT"))) )
    {
        exit(1);
    }
    //signal( SIGINT,SIG_IGN);
    signal( SIGINT,m2m_sighanhler);
    signal( SIGHUP,m2m_sighanhler);
    signal( SIGABRT,m2m_sighanhler);
    signal( SIGPIPE,m2m_sighanhler);
    signal( SIGTSTP,m2m_sighanhler);

    printf(" mpeg2dec: (C) 1999 Aaron Holtzman <aholtzma@ess.engr.uvic.ca>\n");
    printf(" m2m : (C) 2000 Taichi Nakamura <pdf30044@biglobe.ne.jp>\n");

    setlocale (LC_ALL, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
    panel_create( argc, argv );
    gtk_main ();
    m2m_leave_caster();
    return 0;
}
