package control.move;

import java.util.Random;

import util.Log;
import view.Field;
import model.Cast;

/**
 * ランダム移動のアルゴリズム
 * @author Masayasu Fujiwara
 */
public class RandomMove implements InteligentMove {
	private final Field field;
	private final Random generator;
	
	public RandomMove(Field field) {
		this.generator = new Random();
		this.field = field;
	}
	
	public boolean run(Cast predator) {
		if (predator.isMove()) {
			int direction = predator.getDirection();
			if (direction > 0) {
				if (direction == Cast.LEFT) {
					predator.moveLeft();
					return true;
				} else if (direction == Cast.RIGHT) {
					predator.moveRight();
					return true;
				}
			} else if (direction < 0) {
				if (direction == Cast.UP) {
					predator.moveUp();
					return true;
				} else if (direction == Cast.DOWN) {
					predator.moveDown();
					return true;
				}
			}
		}
		Log.out(this, "enemy turn");
		for (int i = 0; i < 5; i++) {
			switch (this.generator.nextInt(4)) {
				case 0 :
					if (this.field.checkRight(predator)) {
						predator.turnRight();
						predator.moveRight();
						return true;
					}
					break;
				case 1 :
					if (this.field.checkLeft(predator)) {
						predator.turnLeft();
						predator.moveLeft();
						return true;
					}
					break;
				case 2 :
					if (this.field.checkDown(predator)) {
						predator.turnDown();
						predator.moveDown();
						return true;
					}
					break;
				case 3 :
					if (this.field.checkUp(predator)) {
						predator.turnUp();
						predator.moveUp();
						return true;
					}
					break;
			}
		}
		return false;
	}
}
