package control.move;

import util.Log;
import view.Field;
import model.Cast;

/**
 * 追跡のアルゴリズム
 * @author Masayasu Fujiwara
 */
public class TrackingMove implements InteligentMove {
	private final Field field;
	private final Cast prey;
	
	public TrackingMove(Field field, Cast prey) {
		this.field = field;
		this.prey = prey;
	}
	
	public boolean run(Cast predator) {
		int preyX = this.prey.getX();
		int preyY = this.prey.getY();
		int predatorX = predator.getX();
		int predatorY = predator.getY();
		if (predator.isMove()) {
			Log.out(this, "predator move");
			int direction = predator.getDirection();
			if (direction > 0) {
				if (direction == Cast.LEFT) {
					if (preyX < predatorX) {
						predator.moveLeft();
						return true;
					} else if (preyX > predatorX) {
						predator.turnRight();
						return true;
					}
				} else if (direction == Cast.RIGHT) {
					if (preyX > predatorX) {
						predator.moveRight();
						return true;
					} else if (preyX < predatorX) {
						predator.turnLeft();
						return true;
					}
				}
			} else if (direction < 0) {
				if (direction == Cast.UP) {
					if (preyY < predatorY) {
						predator.moveUp();
						return true;
					} else if (preyY > predatorY){
						predator.turnDown();
						return true;
					}
				} else if (direction == Cast.DOWN) {
					if (preyY > predatorY) {
						predator.moveDown();
						return true;
					} else if (preyY < predatorY) {
						predator.turnUp();
						return true;
					}
				}
			}
		}
		int dx = preyX - predatorX;
		int dy = preyY - predatorY;
		Log.out(this, "predator turn");
		if (Math.abs(dx) > Math.abs(dy)) {
			if (preyX > predatorX && this.field.checkRight(predator)) {
				predator.turnRight();
				predator.moveRight();
				Log.out(this, "predator turn Right");
				return true;
			} else if (preyX < predatorX && this.field.checkLeft(predator)) {
				predator.turnLeft();
				predator.moveLeft();
				Log.out(this, "predator turn Left");
				return true;
			}
			if (preyY > predatorY && this.field.checkDown(predator)) {
				predator.turnDown();
				predator.moveDown();
				Log.out(this, "predator turn Down");
				return true;
			} else if (preyY < predatorY && this.field.checkUp(predator)) {
				predator.turnUp();
				predator.moveUp();
				Log.out(this, "predator turn Up");
				return true;
			}
		} else {
			if (preyY > predatorY && this.field.checkDown(predator)) {
				predator.turnDown();
				predator.moveDown();
				return true;
			} else if (preyY < predatorY && this.field.checkUp(predator)) {
				predator.turnUp();
				predator.moveUp();
				return true;
			}
			if (preyX > predatorX && this.field.checkRight(predator)) {
				predator.turnRight();
				predator.moveRight();
				return true;
			} else if (preyX < predatorX && this.field.checkLeft(predator)) {
				predator.turnLeft();
				predator.moveLeft();
				return true;
			}
		}
		return false;
	}
}
