package model;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

import view.Field;

/**
 * プレイヤー
 * @author ma38su
 */
public class Cast {

	/**
	 * 上方向
	 */
	public static final int UP = -1;

	/**
	 * 下方向
	 */
	public static final int DOWN = -2;
	
	/**
	 * 左方向
	 */
	public static final int LEFT = 1;

	/**
	 * 右方向
	 */
	public static final int RIGHT = 2;

	/**
	 * 向いている方向
	 */
	private int direction;
	
	/**
	 * 下方向へ移動する画像
	 */
	private final Image[] IMG_DOWN;

	/**
	 * 左方向へ移動する画像
	 */
	private final Image[] IMG_LEFT;
	
	/**
	 * 右方向へ移動する画像
	 */
	private final Image[] IMG_RIGHT;

	/**
	 * 上方向へ移動する画像
	 */
	private final Image[] IMG_UP;

	/**
	 * フロアとフレームとのX座標方向のズレ
	 */
	private final int MARGIN_X = Field.FLOOR_SIZE - Field.CLIPPING_X;

	private final int IMG_PADDING_Y = 10;

	/**
	 * フロアとフレームとのY座標方向のズレ
	 */
	private final int MARGIN_Y = Field.FLOOR_SIZE - Field.CLIPPING_Y - this.IMG_PADDING_Y;
	
	/**
	 * プレイヤーの名前
	 */
	private String name;

	/**
	 * 移動する単位（ピクセル）
	 */
	private int speed;

	/**
	 * X座標
	 */
	private int x;

	/**
	 * Y座標
	 */
	private int y;

	public Cast(String name) throws IOException {
		this.name = name;
		this.speed = 1;
		this.IMG_DOWN = new Image[3];
		this.IMG_DOWN[0] = ImageIO.read(Cast.class.getResource("/img/kitsune0.png"));
		this.IMG_DOWN[1] = ImageIO.read(Cast.class.getResource("/img/kitsune1.png"));
		this.IMG_DOWN[2] = ImageIO.read(Cast.class.getResource("/img/kitsune2.png"));
		this.IMG_LEFT = new Image[3];
		this.IMG_LEFT[0] = ImageIO.read(Cast.class.getResource("/img/kitsune3.png"));
		this.IMG_LEFT[1] = ImageIO.read(Cast.class.getResource("/img/kitsune4.png"));
		this.IMG_LEFT[2] = ImageIO.read(Cast.class.getResource("/img/kitsune5.png"));
		this.IMG_UP = new Image[3];
		this.IMG_UP[0] = ImageIO.read(Cast.class.getResource("/img/kitsune6.png"));
		this.IMG_UP[1] = ImageIO.read(Cast.class.getResource("/img/kitsune7.png"));
		this.IMG_UP[2] = ImageIO.read(Cast.class.getResource("/img/kitsune8.png"));
		this.IMG_RIGHT = new Image[3];
		this.IMG_RIGHT[0] = ImageIO.read(Cast.class.getResource("/img/kitsune9.png"));
		this.IMG_RIGHT[1] = ImageIO.read(Cast.class.getResource("/img/kitsune10.png"));
		this.IMG_RIGHT[2] = ImageIO.read(Cast.class.getResource("/img/kitsune11.png"));
	}

	/**
	 * プレイヤーを描画します。
	 * @param g 描画するGraphics
	 */
	public void draw(Graphics g) {
		Image image = this.IMG_DOWN[0];
		if (this.direction < 0) {
			if (this.direction == Cast.UP) {
				image = this.IMG_UP[0];
			} else if (this.direction == Cast.DOWN) {
				image = this.IMG_DOWN[0];
			}
		} else if (this.direction > 0) {
			if (this.direction == Cast.LEFT) {
				image = this.IMG_LEFT[0];
			} else if (this.direction == Cast.RIGHT) {
				image = this.IMG_RIGHT[0];
			}
		}
		g.drawImage(image, this.x, this.y, null);
		g.setColor(Color.BLACK);
		drawName(g, -1, 0);
		drawName(g, -1, 0);
		drawName(g, 1, -1);
		drawName(g, 1, 1);
		drawName(g, -1, 0);
		drawName(g, 1, 0);
		drawName(g, 0, -1);
		drawName(g, 0, 1);
		g.setColor(Color.WHITE);
		drawName(g, 0, 0);
	}

	/**
	 * 名前を描画します。
	 * 
	 * @param g グラフィクスコンテキスト
	 * @param dx x方向にずらす距離
	 * @param dy y方向にずらす距離
	 */
	private void drawName(Graphics g, int dx, int dy) {
		FontMetrics metrics = g.getFontMetrics(g.getFont());
		g.drawString(this.name, this.x + 10 - metrics.stringWidth(this.name) / 2 + dx, this.y - 2 + dy);
	}

	/**
	 * 名前を返します。
	 * @return プレイヤー名
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * 
	 * @return 移動中はtrueを返す。
	 */
	public boolean isMove() {
		if (this.direction > 0) {
			if (this.x % Field.FLOOR_SIZE != this.MARGIN_X) {
				return true;
			}		
		} else if (this.direction < 0) {
			if (this.y % Field.FLOOR_SIZE != this.MARGIN_Y) {
				return true;
			}
		}
		return false;
	}

	/**
	 * 向いている方向を返します。
	 * @return 向いている方向
	 */
	public int getDirection() {
		return this.direction;
	}
	/**
	 * 下方向へ移動させます。
	 */
	public void moveDown() {
		this.y += this.speed ;
	}

	/**
	 * 左方向へ移動させます。
	 */
	public void moveLeft() {
		this.x -= this.speed;
	}
	
	/**
	 * 右方向へ移動させます。
	 */
	public void moveRight() {
		this.x += this.speed;
	}

	/**
	 * 上方向へ移動させます。
	 */
	public void moveUp() {
		this.y -= this.speed;
	}

	/**
	 * 上を向かせます。
	 */
	public void turnUp() {
		this.direction = Cast.UP;
	}

	/**
	 * 下を向かせます。
	 */
	public void turnDown() {
		this.direction = Cast.DOWN;
	}
	
	/**
	 * 左を向かせます。
	 */
	public void turnLeft() {
		this.direction = Cast.LEFT;
	}

	/**
	 * 右を向かせます。
	 */
	public void turnRight() {
		this.direction = Cast.RIGHT;
	}

	/**
	 * 位置を設定します。
	 * @param x
	 * @param y
	 */
	public void setLocation(int x, int y) {
		this.x = x;
		this.y = y - this.IMG_PADDING_Y;
	}

	/**
	 * X座標を返します。
	 * @return X座標
	 */
	public int getX() {
		return this.x;
	}

	/**
	 * Y座標を返します。
	 * @return Y座標
	 */
	public int getY() {
		return this.y + this.IMG_PADDING_Y;
	}
}
