/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import jp.gr.java_conf.dangan.io.DisconnectableInputStream;
import jp.gr.java_conf.dangan.io.LimitedInputStream;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaInputStream
extends InputStream {
    private InputStream source;
    private boolean alreadyOpenedFirstEnrty;
    private boolean reachedEndOfArchive;
    private InputStream in;
    private LimitedInputStream limit;
    private boolean reachedEndOfEntry;
    private boolean markReachedEndOfEntry;
    private Properties property;

    private LhaInputStream() {
    }

    public LhaInputStream(InputStream in) {
        Properties property = LhaProperty.getProperties();
        try {
            this.constructerHelper(in, property);
        }
        catch (UnsupportedEncodingException exception) {
            throw new Error("Unsupported encoding \"" + property.getProperty("lha.encoding") + "\".");
        }
    }

    public LhaInputStream(InputStream in, Properties property) throws UnsupportedEncodingException {
        this.constructerHelper(in, property);
    }

    private void constructerHelper(InputStream in, Properties property) throws UnsupportedEncodingException {
        String encoding;
        if (in != null && property != null) {
            encoding = property.getProperty("lha.encoding");
            if (encoding == null) {
                encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (in == null) {
                throw new NullPointerException("in");
            }
            throw new NullPointerException("property");
        }
        encoding.getBytes(encoding);
        this.source = in.markSupported() ? in : new BufferedInputStream(in);
        this.in = null;
        this.limit = null;
        this.property = (Properties)property.clone();
        this.reachedEndOfEntry = false;
        this.reachedEndOfArchive = false;
    }

    public int read() throws IOException {
        if (this.in != null) {
            int ret = this.in.read();
            if (ret < 0) {
                this.reachedEndOfEntry = true;
            }
            return ret;
        }
        throw new IOException("no entry");
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int index, int length) throws IOException {
        if (this.in != null) {
            int ret = this.in.read(buffer, index, length);
            if (ret < 0) {
                this.reachedEndOfEntry = true;
            }
            return ret;
        }
        throw new IOException("no entry");
    }

    public long skip(long length) throws IOException {
        if (this.in != null) {
            if (0L < length) {
                long len = this.in.skip(length - 1L);
                int ret = this.in.read();
                if (ret < 0) {
                    this.reachedEndOfEntry = true;
                    return len;
                }
                return len + 1L;
            }
            return 0L;
        }
        throw new IOException("no entry");
    }

    public void mark(int readLimit) {
        if (this.in == null) {
            throw new IllegalStateException();
        }
        this.in.mark(readLimit);
        this.markReachedEndOfEntry = this.reachedEndOfEntry;
    }

    public void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("no entry");
        }
        this.in.reset();
        this.reachedEndOfEntry = this.markReachedEndOfEntry;
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int available() throws IOException {
        if (this.in != null) {
            return this.reachedEndOfEntry ? 0 : 1;
        }
        throw new IOException("no entry");
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.limit = null;
            this.in = null;
        }
        this.source.close();
        this.source = null;
    }

    public LhaHeader getNextEntry() throws IOException {
        if (!this.reachedEndOfArchive) {
            byte[] HeaderData;
            if (this.in != null) {
                this.closeEntry();
            }
            if (this.alreadyOpenedFirstEnrty) {
                HeaderData = LhaHeader.getNextHeaderData(this.source);
            } else {
                HeaderData = LhaHeader.getFirstHeaderData(this.source);
                this.alreadyOpenedFirstEnrty = true;
            }
            if (HeaderData != null) {
                LhaHeader header = LhaHeader.createInstance(HeaderData, this.property);
                this.in = new DisconnectableInputStream(this.source);
                this.limit = new LimitedInputStream(this.in, header.getCompressedSize());
                this.in = CompressMethod.connectDecoder(this.limit, header.getCompressMethod(), this.property, header.getOriginalSize());
                this.reachedEndOfEntry = false;
                this.markReachedEndOfEntry = false;
                return header;
            }
            this.reachedEndOfArchive = true;
            return null;
        }
        return null;
    }

    public LhaHeader getNextEntryWithoutExtract() throws IOException {
        if (!this.reachedEndOfArchive) {
            byte[] HeaderData;
            if (this.in != null) {
                this.closeEntry();
            }
            if (this.alreadyOpenedFirstEnrty) {
                HeaderData = LhaHeader.getNextHeaderData(this.source);
            } else {
                HeaderData = LhaHeader.getFirstHeaderData(this.source);
                this.alreadyOpenedFirstEnrty = true;
            }
            if (HeaderData != null) {
                LhaHeader header = LhaHeader.createInstance(HeaderData, this.property);
                this.in = new DisconnectableInputStream(this.source);
                this.limit = new LimitedInputStream(this.in, header.getCompressedSize());
                this.in = this.limit;
                this.reachedEndOfEntry = false;
                this.markReachedEndOfEntry = false;
                return header;
            }
            this.reachedEndOfArchive = true;
            return null;
        }
        return null;
    }

    public void closeEntry() throws IOException {
        if (this.in != null) {
            while (this.limit.read() >= 0) {
                this.limit.skip(Long.MAX_VALUE);
            }
            this.in.close();
            this.in = null;
            this.limit = null;
        }
    }
}

