package store;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.ma38su.util.Log;

import map.DataCity;
import map.store.ChainStore;

/**
 * 松屋の店舗情報を取得するクラス
 * @author Masayasu Fujiwara
 *
 */
public class MatsuyaPlugin extends ChainStore {
	private final Pattern ADDRESS_PARSER;

	public MatsuyaPlugin() {
		super("松屋");
		this.ADDRESS_PARSER = Pattern.compile("<td class=\"cell_cream\">([^\\d][^<>]+)</td>");
	}

	@Override
	protected URL getURL(DataCity city, int page) {
		URL url = null;
		try {
			url = new URL("http://sp.chizumaru.com/dbh/matsuyaf/list.aspx?account=matsuyaf&accmd=0&arg=&c1=&c2=&c3=&c4=&c5=&c6=&c7=&c8=&c9=&c10=&c11=&c12=&c13=&c14=&c15=&c16=&c17=&c18=&c19=&c20=&c21=&c22=&c23=&c24=&c25=&c26=&c27=&c28=&c29=&c30=&pg=" + page + "&adr="+ DataCity.cityFormat(city.getCode()));
		} catch (MalformedURLException e) {
			Log.err(this, e);
		}
		return url;
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.ADDRESS_PARSER.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
}
