package tsp;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;


public class Node {
	private int x;
	private int y;
	public Node(int x, int y) {
		this.x = x;
		this.y = y;
		this.edge = new HashSet<Node>();
	}
	
	public void clear() {
		this.edge.clear();
	}
	
	public Set<Node> edge;
	public boolean connect(Node node) {
		return this.edge.add(node);
	}
	
	public boolean hasEdge(Node node) {
		return this.edge.contains(node);
	}
	
	public boolean disconnect(Node node) {
		return this.edge.remove(node) && node.edge.remove(this);
	}
	
	public Collection<Node> getEdge() {
		return this.edge;
	}
	public int getConnection() {
		return this.edge.size();
	}
	public int getX() {
		return this.x;
	}
	public int getY() {
		return this.y;
	}

	private static final int SIZE = 10;

	public void draw(Graphics2D g, Color color) {
		g.setColor(color);
		int centerX = this.x - SIZE / 2;
		int centerY = this.y - SIZE / 2;
		g.fillOval(centerX, centerY, SIZE, SIZE);
		g.setColor(Color.BLACK);
		g.drawOval(centerX, centerY, SIZE, SIZE);
	}

	/**
	 * 頂点間の直線距離を計算します。
	 * @param node 距離を計算する頂点
	 * @return 頂点間の直線距離
	 */
	public double getDistance(Node node) {
		int dx = this.x - node.x;
		int dy = this.y - node.y;
		return Math.sqrt(dx * dx + dy * dy);
	}
	
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Node) {
			Node node = (Node) obj;
			return this.x == node.x && this.y == node.y;
		}
		return false;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("(");
		sb.append(this.x);
		sb.append(",");
		sb.append(this.y);
		sb.append(")");
		return sb.toString();
	}
}
