package tsp;

import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

import javax.swing.JLabel;

public class StatusBar extends JLabel implements Observer {
	public StatusBar() {
		super(" ");
		this.setText();
	}
	
	private int nodes;
	private double route;
	@SuppressWarnings("unchecked")
	public void update(Observable o, Object arg) {
		if (arg instanceof Set) {
			Collection collection = (Collection) arg;
			this.nodes = collection.size();
		} else if (arg instanceof List) {
			List<Node> list = (List<Node>) arg;
			if (list.size() == 0) {
				this.route = 0;
			} else {
				Node n0 = list.get(list.size() - 1);
				double length = 0;
				for (Node node : list) {
					length += n0.getDistance(node);
					n0 = node;
				}
				this.route = (int) (length * 100 + 0.5) / 100D;
			}
		}
		this.setText();
	}
	private void setText() {
		this.setText("  頂点数： "+ this.nodes + " / 巡回路： "+ this.route);
	}
}
