package tsp;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;

import javax.swing.JComponent;

/**
 * 巡回セールスマン問題を表示するパネルです。
 * @author ma38su 
 */
public class TspPanel extends JComponent {
	private Image offs;
	
	private Observable observable;
	private Set<Node> nodes;

	public TspPanel(Observable observable) {
		this.observable = observable;
		this.nodes = new HashSet<Node>();
		this.route = new ArrayList<Node>();
	}
	
	public void add(int x, int y) {
		if (this.screen.contains(x, y)) {
			this.nodes.add(new Node(x, y));
			this.observable.notifyObservers(this.nodes);
			this.repaint();
		}
	}

	public Collection<Node> getNodes() {
		return this.nodes;
	}

	public void clearRoute() {
		for (Node node : this.nodes) {
			node.clear();
		}
		this.repaint();
	}

	public void clear() {
		this.nodes.clear();
		this.route.clear();
		this.observable.notifyObservers(this.nodes);
		this.observable.notifyObservers(this.route);
		this.repaint();
	}
	
	private final int MARGIN = 5;
	private Rectangle screen;

	private List<Node> route;
	public void add(List<Node> route) {
		synchronized (this.route) {
			this.route.clear();
			synchronized (route) {
				this.route.addAll(route);
			}
		}
		this.repaint();
	}
	
	@Override
	protected void paintComponent(Graphics g) {
		if (this.offs == null || this.getWidth() != this.offs.getWidth(null) || this.getHeight() != this.offs.getHeight(null)) {
			this.offs = this.createImage(this.getWidth(), this.getHeight());
			this.screen = new Rectangle(this.MARGIN, this.MARGIN, this.getWidth() - this.MARGIN * 2, this.getHeight() - this.MARGIN * 2);
		}
		Graphics2D g2 = (Graphics2D) this.offs.getGraphics();
		g2.setColor(Color.WHITE);
		g2.fill(this.screen);
		g2.setClip(this.screen);
		
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

		g2.setColor(Color.BLACK);
		synchronized (this.route) {
			if (!this.route.isEmpty()) {
				Node n0 = this.route.get(this.route.size() - 1);
				for (Node node : this.route) {
					RouteEntry entry = new RouteEntry(n0, node);
					entry.draw(g2);
					n0 = node;
				}
			}
		}
		for (Node node : this.nodes) {
			if (node.getConnection() % 2 == 0) {
				node.draw(g2, Color.ORANGE);
			} else {
				node.draw(g2, Color.RED);
			}
		}
		g2.setClip(0, 0, this.getWidth(), this.getHeight());
		g2.setColor(Color.BLACK);
		g2.draw(this.screen);
		g.drawImage(this.offs, 0, 0, null);
	}
}
