package tsp.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import tsp.Node;

/**
 * nearest neighborによる巡回セールスマン問題の構築法です。
 * @author ma38su
 */
public class NearestNeighbor implements TspConstruction {
	public List<Node> method(Collection<Node> place) {
		Set<Node> nodes = new HashSet<Node>(place);
		List<Node> route = new ArrayList<Node>(nodes.size() + 1);
		Set<Node> vp = new HashSet<Node>(nodes.size());
		Iterator<Node> itr = nodes.iterator();
		if (itr.hasNext()) {
			Node start = itr.next();
			Node node = start;
			while (!nodes.isEmpty()) {
				route.add(node);
				vp.add(node);
				if (nodes.remove(node) && nodes.isEmpty()) {
					break;
				}
				Node tmp = null;
				double min = Double.POSITIVE_INFINITY;
				for (Node terminal : nodes) {
					if (!node.equals(terminal) && !vp.contains(terminal)) {
						double distance = node.getDistance(terminal);
						if (min > distance) {
							min = distance;
							tmp = terminal;
						}
					}
				}
				assert tmp != null;
				node = tmp;
			}
		}
		return route;
	}

	@Override
	public String toString() {
		return "nearest neighbor";
	}
}
