import gui.DemoPanel;
import gui.StatusBar;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import controller.Controller;
import method.GraphDemonstration;
import method.MinimumSpanningTree;
import method.tsp.CheapestInsertion;
import method.tsp.HeldKarp;
import method.tsp.ImproveRoutine;
import method.tsp.NearestAddition;
import method.tsp.NearestInsertion;
import method.tsp.NearestNeighbor;
import method.tsp.NoImprovement;
import method.tsp.OneTree;
import method.tsp.Opt2;
import method.tsp.Opt3;
import method.tsp.OrOpt;
import method.tsp.TspConstruction;
import method.tsp.TspImprovement;
import model.Node;


/**
 * 起動のためのクラスです。
 * GUIの構築を行います。
 * @author ma38su
 */
public class Main {
	private static final String TITLE = "Graph Demonstration";

	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		final List<GraphDemonstration> demoType = new ArrayList<GraphDemonstration>();
		demoType.add(new HeldKarp());
		demoType.add(new MinimumSpanningTree());
		demoType.add(new OneTree());
		
		final List<TspConstruction> tspConstruct = new ArrayList<TspConstruction>();
		tspConstruct.add(new NearestNeighbor());
		tspConstruct.add(new NearestInsertion());
		tspConstruct.add(new CheapestInsertion());
		tspConstruct.add(new NearestAddition());

		final List<TspImprovement> tspImprovement = new ArrayList<TspImprovement>();
		Opt2 opt2 = new Opt2();
		Opt3 opt3 = new Opt3();
		OrOpt optOr = new OrOpt();
		tspImprovement.add(new NoImprovement());
		tspImprovement.add(opt2);
		tspImprovement.add(opt3);
		tspImprovement.add(optOr);
		tspImprovement.add(new ImproveRoutine(opt2, optOr));
		tspImprovement.add(new ImproveRoutine(opt2, opt3));
		tspImprovement.add(new ImproveRoutine(opt3, optOr));

		final JFrame frame = new JFrame(TITLE);

		JMenuBar menubar = new JMenuBar();
		frame.setJMenuBar(menubar);
		JMenu menu1 = new JMenu("File");
		
		JMenuItem menu1_1 = new JMenuItem("Save");
		menu1_1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		menu1.add(menu1_1);
		menubar.add(menu1);
		
		menu1.addSeparator();
		
		JMenuItem menu1_2 = new JMenuItem("Exit");
		menu1_2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		menu1.add(menu1_2);
		menubar.add(menu1);
		
		frame.setLayout(new BorderLayout());
		final Observable observable = new Observable() {
			@Override
			public void notifyObservers(Object arg) {
				super.setChanged();
				super.notifyObservers(arg);
			}
		};

		final DemoPanel panel = new DemoPanel(observable);
		Controller controller = new Controller(panel);
		panel.addMouseListener(controller);
		frame.add(panel, BorderLayout.CENTER);

		JPanel subPanel = new JPanel(new BorderLayout());
		StatusBar statusbar = new StatusBar();
		observable.addObserver(statusbar);
		
		subPanel.add(statusbar, BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		subPanel.add(buttonPanel, BorderLayout.EAST);

		JButton startButton = new JButton("Run");
		buttonPanel.add(startButton);
		final boolean[] isImprove = new boolean[tspImprovement.size()];
		final boolean[] isConstract = new boolean[tspConstruct.size()];
		final boolean[] isDemoType = new boolean[demoType.size()];

		isDemoType[0] = true;
		isImprove[0] = true;
		final ActionListener calc = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new Thread() {
					@Override
					public void run() {
						panel.clearRoute();
						for (int i = 0; i < isConstract.length; i++) {
							if (isConstract[i]) {
								TspConstruction constraction = tspConstruct.get(i);
								final List<Node> route = constraction.method(panel);
								for (int j = 0; j < tspImprovement.size(); j++) {
									if (isImprove[j]) {
										final TspImprovement tsp = tspImprovement.get(j);
										if (j == 0) {
											frame.setTitle(TITLE + " - "+ constraction);
										} else {
											frame.setTitle(TITLE + " - "+ constraction + " + "+ tsp);
										}
										panel.set(route);
										observable.notifyObservers(route);
										while (tsp.method(route)) {
											panel.set(route);
										}
										observable.notifyObservers(route);
									}
								}
								return;
							}
						}
						for (int i = 0; i < isDemoType.length; i++) {
							if (isDemoType[i]) {
								GraphDemonstration demo = demoType.get(i);
								demo.method(panel);
								for (int j = 0; j < demoType.size(); j++) {
									if (isDemoType[j]) {
										final GraphDemonstration tsp = demoType.get(j);
										if (j == 0) {
											frame.setTitle(TITLE + " - "+ demo);
										} else {
											frame.setTitle(TITLE + " - "+ demo + " + "+ tsp);
										}
									}
								}
								return;
							}
						}
					}
				}.start();
			}
		};
		startButton.addActionListener(calc);

		JButton clearButton = new JButton("Clear");
		buttonPanel.add(clearButton);
		clearButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clear();
			}
		});

		JMenu menu2 = new JMenu("View");
		ButtonGroup group2 = new ButtonGroup();
		int timeIndex = 3;
		final int[] time = new int[]{0, 10, 50, 100, 500, 1000, 2500, 5000};
		panel.setInterval(time[timeIndex]);
		for (int i = 0; i < time.length; i++) {
			final int j = i;
			final JCheckBoxMenuItem item = new JCheckBoxMenuItem(Integer.toString(time[i]) + "ms", i == timeIndex);
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					panel.setInterval(time[j]);
				}
			});
			group2.add(item);
			menu2.add(item);
		}
		menubar.add(menu2);

		JMenu menu3 = new JMenu("Type");
		ButtonGroup demoGroup = new ButtonGroup();
		for (int i = 0; i < demoType.size(); i++) {
			final JCheckBoxMenuItem item = new JCheckBoxMenuItem(demoType.get(i).toString(), isDemoType[i]);
			final int index = i;
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					for (int i = 0; i < isConstract.length; i++) {
						isConstract[i] = false;
					}
					for (int i = 0; i < isDemoType.length; i++) {
						isDemoType[i] = false;
					}
					isDemoType[index] = item.isSelected();
					calc.actionPerformed(null);
				}
			});
			demoGroup.add(item);
			menu3.add(item);
		}
		menubar.add(menu3);
		
		JMenu menu4 = new JMenu("構築法");
		for (int i = 0; i < tspConstruct.size(); i++) {
			final JCheckBoxMenuItem item = new JCheckBoxMenuItem(tspConstruct.get(i).toString(), isConstract[i]);
			final int index = i;
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					for (int i = 0; i < isConstract.length; i++) {
						isConstract[i] = false;
					}
					for (int i = 0; i < isDemoType.length; i++) {
						isDemoType[i] = false;
					}
					isConstract[index] = item.isSelected();
					calc.actionPerformed(null);
				}
			});
			demoGroup.add(item);
			menu4.add(item);
		}
		menubar.add(menu4);

		JMenu menu5 = new JMenu("改善法");
		ButtonGroup group5 = new ButtonGroup();
		for (int i = 0; i < tspImprovement.size(); i++) {
			final JCheckBoxMenuItem item = new JCheckBoxMenuItem(tspImprovement.get(i).toString(), isImprove[i]);
			final int index = i;
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					for (int i = 0; i < isImprove.length; i++) {
						isImprove[i] = false;
					}
					isImprove[index] = item.isSelected();
					calc.actionPerformed(null);
				}
			});
			group5.add(item);
			menu5.add(item);
		}
		menubar.add(menu5);
		
		frame.add(subPanel, BorderLayout.SOUTH);
		frame.setSize(600, 400);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}

	public static double getLength(List<Node> route) {
		double length = 0;
		if (route.size() > 0) {
			Node n0 = route.get(route.size() - 1);
			for (Node node : route) {
				length += n0.getDistance(node);
				n0 = node;
			}
		}
		return length;
	}
}
