<?php	get_header();
	vicuna_column_module('index');
?>
	<title><?php bloginfo('name'); ?></title>
</head>
<body class="mainIndex <?php vicuna_layout('index'); ?>">
<div id="header">
	<p class="siteName"><a href="<?php bloginfo('home'); ?>"><?php bloginfo('name'); ?></a></p>
	<?php vicuna_description(); ?>
<?php vicuna_global_navigation() ?>
</div>

<div id="content">
	<div id="main">
		<p class="topicPath"><a href="<?php bloginfo('home'); ?>" title="Home">Home</a></p>
		<h1><?php bloginfo('name'); ?></h1>
<?php
	if (have_posts()) :
		while (have_posts()) {
			the_post();
			$title = get_the_title();
?>

		<div class="section entry" id="entry<?php the_ID(); ?>">
			<h2><a href="<?php the_permalink() ?>"><?php echo $title; ?></a></h2>
			<ul class="info">
				<li class="date"><?php the_time('Y-m-d (D)') ?></li>
				<li class="category"><?php the_category(' | ') ?></li>
				<?php if (function_exists('the_tags')) : the_tags('<li class="tags">', ' | ', '</li>'); endif; ?>
				<?php edit_post_link('Edit.', '<li class="admin">', '</li>'); ?>
			</ul>
			<div class="textBody">
<?php the_content('Continue reading'); ?>
			</div>
			<ul class="reaction">
<?php
			$trackpingCount = get_vicuna_pings_count();
			$commentCount = (int) get_comments_number() - (int) $trackpingCount;
			if ('open' == $post->comment_status) : ?>
				<li class="comment"><a href="<?php the_permalink() ?>#comments" title="<?php printf(__('Comments on %s', 'vicuna'), $title); ?>" rel="nofollow">Comments</a>: <span class="count"><?php echo $commentCount; ?></span></li>
<?php			else : ?>
				<li>Comments (Close): <span class="count"><?php echo $commentCount; ?></span></li>
<?php
			endif;
			if ('open' == $post->ping_status) :
?>
				<li class="trackback"><a href="<?php the_permalink() ?>#trackback" title="<?php printf(__('Trackbacks to %s', 'vicuna'), $title); ?>" rel="nofollow">Trackback</a>: <span class="count"><?php echo $trackpingCount; ?></span></li>
<?php			else : ?>
				<li>Trackback (Close): <span class="count"><?php echo $trackpingCount; ?></span></li>
<?php			endif ?>
				
			</ul>
		</div>
<?php
		}
	endif;
?>
<?php vicuna_paging_link('next_label=Older Entries&prev_label=Newer Entries&indent=2') ?>
		<p class="topicPath"><a href="<?php bloginfo('home'); ?>" title="Home">Home</a></p>
	</div><!-- end main-->

<?php	get_sidebar(); ?>

<?php	get_footer(); ?>
