<?php
/* Header and Footer of Widget */
register_sidebar(array(
	'name' => 'navi',
	'before_widget' => "\t\t<dt id=\"".'%1$s'."\" class=\"widget ".'%1$s'."\">",
	'after_widget' => "\t\t</dd>\n",
	'before_title' => '',
	'after_title' => "</dt>\n\t\t<dd>\n",
));
register_sidebar(array(
	'name' => 'others',
	'before_widget' => "\t\t<dt id=\"".'%1$s'."\" class=\"widget ".'%1$s'."\">",
	'after_widget' => "\t\t</dd>\n",
	'before_title' => '',
	'after_title' => "</dt>\n\t\t<dd>\n",
));

/**
 * Display a widget of calendar.
 */
function vicuna_widget_calendar($args) {
	extract($args);
	$options = get_option('widget_calendar');
	$title = empty($options['title']) ? __('Calendar', 'vicuna') : $options['title'];
	echo $before_widget . $before_title . $title . $after_title;
	vicuna_calendar();
	echo $after_widget;
}

/**
 * Display a widget of search form.
 */
function vicuna_widget_search($args) {
	extract($args);
	$options = get_option('widget_search');
	$title = empty($options['title']) ? __('Search', 'vicuna') : $options['title'];
	echo $before_widget . $before_title . $title . $after_title;
?>
				<form method="get" action="<?php bloginfo('home'); ?>/">
					<fieldset>
						<legend><label for="searchKeyword"><?php printf(__('Search %s', 'vicuna'), get_bloginfo('name')); ?></label></legend>
						<div>
							<input type="text" class="inputField" id="searchKeyword"  name="s" size="10" onfocus="if (this.value == 'Keyword(s)') this.value = '';" onblur="if (this.value == '') this.value = 'Keyword(s)';" value="<?php if ( is_search() ) echo wp_specialchars($s, 1); else echo 'Keyword(s)'; ?>" />
							<input type="submit" class="submit" id="submit" value="Search" />
						</div>
					</fieldset>
				</form>
<?php
	echo $after_widget;
}

/**
 * Display a widget of meta
 */
function vicuna_widget_meta($args) {
	extract($args);
	$options = get_option('widget_meta');
	$title = empty($options['title']) ? __('Meta', 'vicuna') : $options['title'];
	echo $before_widget . $before_title . $title . $after_title;
?>
			<ul>
				<li><a href="http://validator.w3.org/check/referer" title="This page validates as XHTML 1.0 Strict" rel="nofollow">Valid <abbr title="eXtensible HyperText Markup Language">XHTML</abbr></a></li>
<?php	wp_register(); ?>
				<li><?php wp_loginout(); ?></li>
<?php	wp_meta(); ?>
			</ul>
<?php
	echo $after_widget;
}

/* Widget Override */
wp_register_sidebar_widget('calendar', __('Calendar', 'vicuna'), 'vicuna_widget_calendar');
wp_register_sidebar_widget('search', __('Search', 'vicuna'), 'vicuna_widget_search');
wp_register_sidebar_widget('meta', __('Meta', 'vicuna'), 'vicuna_widget_meta');
?>
