<?php	get_header();
	vicuna_column_module('search');
?>
	<title><?php vicuna_title(__('Search Result', 'vicuna')); ?></title>
</head>
<body class="individual <?php vicuna_layout('search'); ?>" id="siteSearch">
<div id="header">
	<p class="siteName"><a href="<?php bloginfo('home'); ?>" title="<?php printf(__('Return to %s index', 'vicuna'), get_bloginfo('name')); ?>"><?php bloginfo('name'); ?></a></p>
	<?php vicuna_description(); ?>
<?php vicuna_global_navigation() ?>
</div>

<div id="content">
	<div id="main">
		<p class="topicPath"><a href="<?php bloginfo('home'); ?>">Home</a> &gt; <span class="current">Search</span></p>
		<h1><?php _e('Search Result', 'vicuna'); ?></h1>
		<p><?php $allsearch =& new WP_Query("s=$s&showposts=-1"); printf(__('Result <span class="count">%s</span> for <em>%s</em>', 'vicuna'), $allsearch->post_count, wp_specialchars($s, 1)); ?></p>
<?php
	if (have_posts()) :
		while (have_posts()) {
			the_post();
			$title = get_the_title();
?>
		<div class="section entry">
			<h2><a href="<?php the_permalink() ?>"><?php echo $title; ?></a></h2>
			<ul class="info">
				<li class="date"><?php the_time('Y-m-d (D)') ?></li>
				<li class="category"><?php the_category(' | ') ?></li>
				<?php if (function_exists('the_tags')) : the_tags('<li class="tags">', ' | ', '</li>'); endif; ?>
				<?php edit_post_link('Edit.', '<li class="admin">', '</li>'); ?>
			</ul>
			<div class="textBody">
<?php the_content('Continue reading'); ?>
			</div>
			<ul class="reaction">
<?php
			$trackpingCount = get_vicuna_pings_count();
			$commentCount = (int) get_comments_number() - (int) $trakpingsCount;
			if ('open' == $post->comment_status) : ?>
				<li class="comment"><a href="<?php the_permalink() ?>#comments" title="<?php printf(__('Comments on %s', 'vicuna'), $title); ?>" rel="nofollow">Comments</a>: <span class="count"><?php echo $commentCount; ?></span></li>
<?php			else : ?>
				<li>Comments (Close): <span class="count"><?php echo $commentCount; ?></span></li>
<?php
			endif;
			if ('open' == $post->ping_status) :
?>
				<li class="trackback"><a href="<?php the_permalink() ?>#trackback" title="<?php printf(__('Trackbacks to %s', 'vicuna'), $title); ?>" rel="nofollow">TrackBack</a>: <span class="count"><?php echo $trackpingCount; ?></span></li>
<?php			else : ?>
				<li>TrackBack (Close): <span class="count"><?php echo $trackpingCount; ?></span></li>
<?php			endif ?>
			</ul>
		</div>
<?php
		}
	elseif (0) : ?>
		<div class="section entry">
			<h2><?php _e('Search Result', 'vicuna'); ?></h2>
			<div class="textBody">
				<p>検索キーワードが入力されていません。</p>
			</div>
		</div>
<?php	else : ?>
		<div class="section entry">
			<h2><?php _e('Search Result', 'vicuna'); ?></h2>
			<div class="textBody">
					<p><em><?php echo wp_specialchars($s, 1); ?></em>というキーワードを含む記事は見つかりませんでした。次項のヒントを参考にして、検索キーワードを変えてもう一度検索してみてください。</p>
					<ul>
						<li>キーワードに誤字や脱字がありませんか ?</li>
						<li>キーワードの意味はそのままで、表現や言い回しを変えてみてください。</li>
						<li>専門的なキーワードだったり、長い文字列のキーワードだったりした場合は、より一般的で短いキーワードにしてください。</li>
						<li>キーワードを複数指定している場合は、キーワードの数を減らしてみてください。</li>
					</ul>
				</div>
		</div>
<?php	endif; ?>
<?php vicuna_paging_link('next_label=Older Entries&prev_label=Newer Entries&indent=2') ?>
		<p class="topicPath"><a href="<?php bloginfo('home'); ?>">Home</a> &gt; <span class="current">Search</span></p>
	</div><!-- end main -->

<?php	get_sidebar(); ?>

<?php	get_footer(); ?>
