/* -*- mode:objc; coding:utf-8; tab-width:8; c-basic-offset:2; indent-tabs-mode:nil -*- */
/*
  Copyright (c) 2004 MacUIM Project
  http://www.digital-genes.com/~yatsu/macuim/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
*/

#import "unistd.h"
#import <uim/uim.h>
#import "Preference.h"
#import "MacUIMPrefPane.h"

@implementation MacUIMPrefPane
 
/**
 * Deallocate
 */
- (void)dealloc
{
  if (numModules > 0 && imModules) {
    int i;
    for (i = 0; i < numModules; i++) {
      free(imModules[i]->name);
      free(imModules[i]->lang);
    }
    free(imModules);
  }
  [super dealloc];
}

- (id)initWithBundle:(NSBundle *)bundle
{
  uim_context uc;

  // Initialize the location of our preferences
  if ((self = [super initWithBundle:bundle]) != nil) {
    appID = CFSTR(kAppID);
  }

  numModules = 0;
  imModules = NULL;

  uim_init();
  uc = uim_create_context(NULL, "UTF-8",
			  NULL, NULL, uim_iconv, NULL);
  if (uc) {
    numModules = uim_get_nr_im(uc);
    imModules = (IMModule **) malloc(sizeof(IMModule *) * numModules);
    if (*imModules != NULL) {
      int i;
      for (i = 0; i < numModules; i++) {
        imModules[i] = (IMModule *) malloc(sizeof(IMModule));
        if (imModules[i]) {
          imModules[i]->index = i;
          imModules[i]->name = strdup(uim_get_im_name(uc, i));
          imModules[i]->lang = strdup(uim_get_im_language(uc, i));
        }
      }
    }
    uim_release_context(uc);
  }

  return self;
}

- (void)mainViewDidLoad
{
  CFPropertyListRef imVal;
  int i;

  // Load the value
  imVal = CFPreferencesCopyAppValue(CFSTR("InputMethod"), appID);

  [imButton removeAllItems];

  for (i = 0; i < numModules; i++) {
    if (strlen(imModules[i]->lang) > 0)
      [imButton addItemWithTitle:[NSString stringWithFormat:@"%s (%s)",
                                           imModules[i]->name,
                                           imModules[i]->lang]];
    else
      [imButton addItemWithTitle:[NSString stringWithFormat:@"%s",
                                           imModules[i]->name,
                                           imModules[i]->lang]];
  }

  if (imVal && CFGetTypeID(imVal) == CFStringGetTypeID()) {
    NSString *current = (NSString *) imVal;
    for (i = 0; i < numModules; i++) {
      if ([current isEqualToString:[NSString stringWithCString:imModules[i]->name]]) {
        [imButton selectItemAtIndex:i];
        break;
      }
    }
  }
  else {
    for (i = 0; i < numModules; i++) {
      if ([[NSString stringWithCString:kDefaultIM] isEqualToString:[NSString stringWithCString:imModules[i]->name]]) {
        [imButton selectItemAtIndex:i];
        break;
      }
    }
  }

  if (imVal)
    CFRelease(imVal);

  [tab selectFirstTabViewItem:self];
}

- (void)willSelect
{
  [appletButton setState:([self isExtraLoaded:kHelperID] ? NSOnState : NSOffState)];
}

- (void)didUnselect
{
  [self prefSync];
}

/**
 * Imput method changed
 */
- (IBAction)imChange:(id)sender
{
  [self prefSync];
}

- (IBAction)appletChange:(id)sender
{
  // Extra load
  if (([appletButton state] == NSOnState)
      && ![self isExtraLoaded:kHelperID]) {
    [self loadExtra];
    if (![self isExtraLoaded:kHelperID]) {
      [appletButton setState:NSOffState];
    }
    [self prefSync];
  }
  else if (([appletButton state] == NSOffState)
           && [self isExtraLoaded:kHelperID]) {
    [self removeExtra:kHelperID];
    if ([self isExtraLoaded:kHelperID]) {
      [appletButton setState:NSOnState];
    }
  }
}

- (void)prefSync
{
  CFNotificationCenterRef center;
  CFStringRef keys[1];
  CFStringRef values[1];
  CFDictionaryRef dict;
  int i;

  //keys = (CFStringRef *) NewPtrClear(sizeof(CFStringRef));
  //values = (CFStringRef *) NewPtrClear(sizeof(CFStringRef));

  keys[0] = CFStringCreateWithCString(NULL, "IM",
                                      kCFStringEncodingMacRoman);

  values[0] = CFStringCreateWithCString(NULL, kDefaultIM,
                                        kCFStringEncodingMacRoman);

  i = [[imButton objectValue] intValue];

  CFPreferencesSetAppValue(CFSTR("InputMethod"),
                           CFSTR(kDefaultIM), appID);

  if ([[imButton objectValue] intValue] < numModules) {
    if (imModules && imModules[i]) {
      CFPreferencesSetAppValue(CFSTR("InputMethod"),
                               (CFStringRef) [NSString stringWithCString:imModules[i]->name],
                               appID);
      CFRelease(values[0]);
      values[0] = CFStringCreateWithCString(NULL, imModules[i]->name,
                                            kCFStringEncodingMacRoman);
    }
  }

  // Write out all the changes
  CFPreferencesAppSynchronize(appID);

  dict = CFDictionaryCreate(kCFAllocatorDefault, 
                            (const void **) keys, 
                            (const void **) values,
                            1, 
                            //&kCFTypeDictionaryKeyCallBacks,
                            //&kCFTypeDictionaryValueCallBacks
                            NULL, NULL);

  // Post a notification that the preferences have changed
  center = CFNotificationCenterGetDistributedCenter();
  CFNotificationCenterPostNotification(center,
                                       CFSTR("Preferences Changed"),
                                       appID, dict, TRUE);

  CFRelease(keys[0]);
  CFRelease(values[0]);
  CFRelease(dict);
}

- (void)loadExtra
{
  int sleepCount = 0;
  NSURL *crackerUrl;
  NSURL *helperUrl =
    [NSURL fileURLWithPath:[[self bundle]
                             pathForResource:@"MacUIMHelper"
                             ofType:@"menu"
                             inDirectory:@""]];

  // Try default MenuCracker installed by user
  CoreMenuExtraAddMenuExtra((CFURLRef) helperUrl,
                            0, 0, 0, 0, 0);

  while (![self isExtraLoaded:kHelperID]
         && (sleepCount < 2000000)) {
    sleepCount += 250000;
    usleep(250000);
  }

  if (![self isExtraLoaded:kHelperID]) {
    // No load
    if (![self isExtraLoaded:kMenuCrackerBundleID]) {
      // Load the cracker
      crackerUrl = [NSURL fileURLWithPath:[[self bundle] pathForResource:@"MenuCracker"
                                                         ofType:@"menu"
                                                         inDirectory:@""]];
      CoreMenuExtraAddMenuExtra((CFURLRef) crackerUrl,
                                0, 0, 0, 0, 0);
      // Load the request again
      CoreMenuExtraAddMenuExtra((CFURLRef) helperUrl,
                                0, 0, 0, 0, 0);
    }
  }

  sleepCount = 0;
  while (![self isExtraLoaded:kHelperID]
         && (sleepCount < 2000000)) {
    sleepCount += 250000;
    usleep(250000);
  }
}

- (void)removeExtra:(NSString *)extraID
{
  void *extra;

  if ((CoreMenuExtraGetMenuExtra((CFStringRef)extraID, &extra) == 0)
      && extra)
    CoreMenuExtraRemoveMenuExtra(extra, 0);
}

- (BOOL)isExtraLoaded:(NSString *)extraID
{
  void *extra;

  if (CoreMenuExtraGetMenuExtra((CFStringRef) extraID, &extra) == 0
      && extra)
    return YES;

  return NO;
}

@end
