/* -*- mode:c; coding:utf-8; tab-width:8; c-basic-offset:2; indent-tabs-mode:nil -*- */
/*
  Copyright (c) 2004 MacUIM Project
  http://www.digital-genes.com/~yatsu/macuim/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
*/

#include "MUIM.h"
#include "MUIMInputEvents.h"
#include "CocoaBundle.h"
#include "CandidateCarbon.h"


static Boolean
TrimIndex(MUIMSessionHandle inHandle);

static void
UpdateCandidate(MUIMSessionHandle inHandle);

static OSStatus 
HandleBundleCommand(int commandID);

void
LayoutCandidate(MUIMSessionHandle inHandle)
{
  TSMStat tsmStat;
  OSErr err = noErr;
  SInt16 qdX = 0, qdY = 0;

  tsmStat.fRefCon = 0;
  tsmStat.fTextOffset = 0;
  tsmStat.fSLRec.fScript = smJapanese;
  tsmStat.fSLRec.fLanguage = langJapanese;
  tsmStat.fLeadingEdge = FALSE;

  err = MUIMGetTSMStatus(inHandle, &tsmStat);
  if (err == noErr) {
    qdX = tsmStat.fReplyPoint.h;
    qdY = tsmStat.fReplyPoint.v;
  }

  //DEBUG_PRINT("LayoutCandidate() x=%hd y=%hd\n", qdX, qdY);

  ShowCandidateWindow(inHandle, qdX, qdY);
}

OSStatus
InitCandidateWindow(MUIMSessionHandle inHandle)
{
  OSStatus res = noErr;
  CFBundleRef appBundle = NULL;
  CFURLRef baseURL = NULL;
  CFURLRef baseURL2 = NULL;
  CFURLRef bundleURL = NULL;
  CFURLRef bundleURL2 = NULL;
  OSStatus (*funcPtr)(void *);

  //char buf[BUFSIZ];
  //CFIndex len;

  DEBUG_PRINT("InitCandidateWindow() fBundleRef=%p\n",
              (*inHandle)->fBundleRef);

  if ((*inHandle)->fBundleRef) return noErr;

  appBundle = CFBundleGetMainBundle();
  require(appBundle, CantFindMainBundle);
    
  //baseURL = CFBundleCopyPrivateFrameworksURL(appBundle);
  baseURL = CFURLCreateWithString(NULL,
                                  CFSTR("/Library/Components/MacUIM.component/Contents/Frameworks/"),
                                  NULL);
  baseURL2 = CFURLCreateWithString(NULL,
                                   CFSTR("/Library/Frameworks/"),
                                   NULL);
  require(baseURL, CantCopyURL);
  require(baseURL2, CantCopyURL);

  //len = CFURLGetBytes(baseURL, buf, BUFSIZ - 1);
  //buf[len] = '\0';
  //DEBUG_PRINT("InitCandidateWindow() - baseURL='%s'\n", buf);

  bundleURL =
    CFURLCreateCopyAppendingPathComponent(kCFAllocatorSystemDefault, baseURL,
                                          CFSTR("CandidateController.bundle"),
                                          false);
  require(bundleURL, CantCreateBundleURL);

  bundleURL2 =
    CFURLCreateCopyAppendingPathComponent(kCFAllocatorSystemDefault, baseURL2,
                                          CFSTR("CandidateController.bundle"),
                                          false);
  require(bundleURL2, CantCreateBundleURL);

  //len = CFURLGetBytes(bundleURL, buf, BUFSIZ - 1);
  //buf[len] = '\0';
  //DEBUG_PRINT("InitCandidateWindow() - bundleURL='%s'\n", buf);

  (*inHandle)->fBundleRef = CFBundleCreate(NULL, bundleURL);
  if (!((*inHandle)->fBundleRef))
    (*inHandle)->fBundleRef = CFBundleCreate(NULL, bundleURL2);
  require((*inHandle)->fBundleRef, CantCreateBundle);
                
  CFRelease(bundleURL);

  // call function to initialize bundle
  funcPtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                              CFSTR("initializeBundle"));
  require(funcPtr, CantFindFunction);
  DEBUG_PRINT("Initializebundle() CFBundleGetFunctionPointerForName('initializeBundle') OK\n");

  res = (*funcPtr)(HandleBundleCommand);
  require_noerr(res, CantInitializeBundle);
  DEBUG_PRINT("Initializebundle() initializebundle() OK\n");
                
 CantCreateBundleURL:
 CantCreateBundle:
  CFRelease(baseURL);
 CantCopyURL:
 CantFindMainBundle:
 CantFindFunction:
 CantInitializeBundle:

  return res;
}

OSStatus
ShowCandidateWindow(MUIMSessionHandle inHandle,
                    SInt16 inQDX, SInt16 inQDY)
{
  OSStatus res = noErr;
  UInt32 i;
  OSStatus (*showPtr)(SInt16, SInt16);

  //if ((*inHandle)->fWindowOpened)
  //  return noErr;

  TrimIndex(inHandle);

  /* XXX: Consider if display_limit == 0 */
  for (i = 0;
       i < NR_CANDIDATES && i < (*inHandle)->fDisplayLimit; i++) {
    if (i < (*inHandle)->fNRCandidates - (*inHandle)->fLayoutBegin) {
      char *newCandStr;
      UniCharPtr newCandUni = NULL;
      UniCharPtr oldCandUni = NULL;
      CFMutableStringRef cfStr;
      int len;
      UniCharPtr (*getCandPtr)(UInt32);
      uim_candidate newCand =
        uim_get_candidate((*inHandle)->fUC,
                          (*inHandle)->fLayoutBegin + i, i);
      if (!newCand) return noErr;
      
      newCandStr = (char *) uim_candidate_get_cand_str(newCand);
      cfStr = CFStringCreateMutable(NULL, 0);
      CFStringAppendCString(cfStr, newCandStr, kCFStringEncodingUTF8);
      len = CFStringGetLength(cfStr);
      newCandUni = (UniCharPtr) malloc(sizeof(UniChar) * (len + 1));
      CFStringGetCharacters(cfStr, CFRangeMake(0, len), newCandUni);
      CFRelease(cfStr);

      getCandPtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                                     CFSTR("getCandidate"));
      if (getCandPtr)
        oldCandUni = (*getCandPtr)(i);
      else
        oldCandUni = NULL;

      /* Checking old cand and new cand is the same or not. If not, call update. 
        Caching new result is good idea for speed up and should be implement. */
      if (!oldCandUni
          //|| strcmp(newCandUni, oldCandUni) != 0
          ) {
        UpdateCandidate(inHandle);
        uim_candidate_free(newCand);
        break;
      }

      uim_candidate_free(newCand);
      free(oldCandUni);
      free(newCandUni);
    }
  }

  (*inHandle)->fSelectCount = 1;

  if ((*inHandle)->fCandidateIndex >= 0) {
    OSStatus (*selectPtr)(int);
    selectPtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                                  CFSTR("selectCandidate"));
    if (selectPtr)
      res = (*selectPtr)((*inHandle)->fCandidateIndex -
                         (*inHandle)->fLayoutBegin);
  }

  // call function to show window
  showPtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                              CFSTR("orderWindowFront"));
  if (showPtr)
    res = (*showPtr)(inQDX, inQDY);

  (*inHandle)->fWindowOpened = true;

  return res;
}

OSStatus
HideCandidateWindow(MUIMSessionHandle inHandle)
{
  OSStatus res = noErr;
  OSStatus (*hidePtr)();

  //if (!(*inHandle)->fWindowOpened)
  //  return noErr;

  // call function to hide window
  hidePtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                              CFSTR("orderWindowBack"));

  if (hidePtr)
    res = (*hidePtr)();

  (*inHandle)->fWindowOpened = false;

  return res;
}

static Boolean
TrimIndex(MUIMSessionHandle inHandle)
{
  Boolean changed = false;

  DEBUG_PRINT("TrimIndex() fCandidateIndex=%ld fLayoutBegin=%lu fDisplayLimit=%lu\n",
              (*inHandle)->fCandidateIndex,
              (*inHandle)->fLayoutBegin,
              (*inHandle)->fDisplayLimit);

  if ((*inHandle)->fDisplayLimit != 0) {
    while ((*inHandle)->fLayoutBegin + (*inHandle)->fDisplayLimit
           <= (*inHandle)->fCandidateIndex) {
      changed = true;
      (*inHandle)->fLayoutBegin += (*inHandle)->fDisplayLimit;
    }  
    while ((*inHandle)->fLayoutBegin > (*inHandle)->fCandidateIndex) {
      changed = true;
      (*inHandle)->fLayoutBegin -= (*inHandle)->fDisplayLimit;
    }
    if ((*inHandle)->fLayoutBegin < 0) {
      changed = true;
      (*inHandle)->fLayoutBegin = 0;
    }
  }
  else {
    while ((*inHandle)->fLayoutBegin + NR_CANDIDATES
           <= (*inHandle)->fCandidateIndex) {
      changed = true;
      (*inHandle)->fLayoutBegin = NR_CANDIDATES;
    }  
    while ((*inHandle)->fLayoutBegin > (*inHandle)->fCandidateIndex) {
      changed = true;
      (*inHandle)->fLayoutBegin -= NR_CANDIDATES;
    }
    if ((*inHandle)->fLayoutBegin < 0) {
      changed = true;
      (*inHandle)->fLayoutBegin = 0;
    }
  }

  DEBUG_PRINT("TrimIndex() [updated] fCandidateIndex=%ld fLayoutBegin=%lu fDisplayLimit=%lu\n",
              (*inHandle)->fCandidateIndex,
              (*inHandle)->fLayoutBegin,
              (*inHandle)->fDisplayLimit);

  return changed;
}

static void
UpdateCandidate(MUIMSessionHandle inHandle)
{
  OSStatus res = noErr;
  int i;
  OSStatus (*clearCandPtr)();
  OSStatus (*addCandPtr)(UniCharPtr, int, UniCharPtr, int);
  
  clearCandPtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                                   CFSTR("clearCandidate"));
  if (addCandPtr)
    res = (*clearCandPtr)();

  /* XXX: Consider if display_limit == 0 */
  for (i = 0;
       i < NR_CANDIDATES && i < (*inHandle)->fDisplayLimit; i++) {
    if (i < (*inHandle)->fNRCandidates - (*inHandle)->fLayoutBegin) {
      char *headStr, *candStr;
      CFMutableStringRef cfStr;
      int headLen, candLen;
      UniCharPtr headUni, candUni;
      uim_candidate cand =
        uim_get_candidate((*inHandle)->fUC,
                          (*inHandle)->fLayoutBegin + i, i);
      headStr = (char *) uim_candidate_get_heading_label(cand);
      candStr = (char *) uim_candidate_get_cand_str(cand);

      if (headStr && candStr) {
        cfStr = CFStringCreateMutable(NULL, 0);
        CFStringAppendCString(cfStr, headStr, kCFStringEncodingUTF8);
        headLen = CFStringGetLength(cfStr);
        headUni = (UniCharPtr) malloc(sizeof(UniChar) * (headLen + 1));
        CFStringGetCharacters(cfStr, CFRangeMake(0, headLen), headUni);
        CFRelease(cfStr);

        cfStr = CFStringCreateMutable(NULL, 0);
        CFStringAppendCString(cfStr, candStr, kCFStringEncodingUTF8);
        candLen = CFStringGetLength(cfStr);
        candUni = (UniCharPtr) malloc(sizeof(UniChar) * (candLen + 1));
        CFStringGetCharacters(cfStr, CFRangeMake(0, candLen), candUni);
        CFRelease(cfStr);

        if (headUni && candUni) {
          addCandPtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                                         CFSTR("addCandidate"));
          if (addCandPtr)
            res = (*addCandPtr)(headUni, headLen, candUni, candLen);
        }
      }
      uim_candidate_free(cand);
    }
    else {
      addCandPtr = CFBundleGetFunctionPointerForName((*inHandle)->fBundleRef,
                                                     CFSTR("addCandidate"));
      if (addCandPtr)
        res = (*addCandPtr)(NULL, 0, NULL, 0);
    }
  }
}

static OSStatus 
HandleBundleCommand(int commandID) {
  OSStatus res = noErr;

  DEBUG_PRINT("HandleBundleCommand() commandID=%d\n", commandID);

#if 0
  if (commandID == kEventCandClicked) {
    OSStatus (*funcPtr)(CFStringRef message);

    funcPtr = CFBundleGetFunctionPointerForName(fBundleRef, CFSTR("changeText"));
    require(funcPtr, CantFindFunction);
    res = (*funcPtr)(CFSTR("button pressed!"));
    require_noerr(osStatus, CantCallFunction);
  }
 CantFindFunction:
 CantCallFunction:
#endif

  return res;
}
