/* -*- mode:c++; coding:shift_jis-mac; tab-width:8; c-basic-offset:4; indent-tabs-mode:nil -*- */
/*
  Copyright (c) 2004 MacUIM Project
  http://www.digital-genes.com/~yatsu/macuim/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
*/

#define UseExtendedThingResource 1

#include <Carbon/Carbon.r>

#include "MUIMScript.h"

resource 'thng' (128)
{
    'tsvc',				/* The component type. Must be 'tsvc' (text service). */
    'inpm',				/* The component subtype. Must be 'inpm' (input method). */
    'appl',				/* This must be a unique vendor code. */
    0x8000 + kMUIMScript * 0x100 +
    kMUIMLanguage,			/* 0x8000 + script code * 256 + language code.
                                           For example, if the text service is Japanese --
                                           smJapanese (1) and langJapanese (14) the value is
                                           0x8000 + 0x0100 + 0x000B = 0x0000810B */
    kAnyComponentFlagsMask,		/* Must be kAnyComponentFlagsMask. */
    'dlle', kBaseResourceID,		/* A reference to our dispatch code. */
    'STR ', kBaseResourceID,
    'STR ', kBaseResourceID,
    'ICON', kBaseResourceID,
    0x00010000,
    componentHasMultiplePlatforms,
    15872 + kMUIMScript * 0x200,
    {
        0x8000 + kMUIMScript * 0x100 +
        kMUIMLanguage,			/* 0x8000 + script code * 256 + language code.
                                           For example, if the text service is Japanese --
                                           smJapanese (1) and langJapanese (14) the value is
                                           0x8000 + 0x0100 + 0x000B = 0x0000810B */
        'dlle', kBaseResourceID, 1000
    }
};

resource 'dlle' (kBaseResourceID) {
	"MUIMComponentDispatch"
};

/*  Pencil Icon Resources - These resources define the icon that is used as our pencil
    menu title. */

data 'ics#' (kBaseResourceID + 1) {
	$"0000 0038 0054 00A2 0146 028A 0514 0A28 1450 38A0 4540 4280 4300 6200 7C00 0000"
	$"0000 0038 007C 00FE 01FE 03FE 07FC 0FF8 1FF0 3FE0 7FC0 7F80 7F00 7E00 7C00 0000"
};

data 'ics4' (kBaseResourceID + 1) {
	$"0000 0000 0000 0000 0000 0000 00FF F000 0000 0000 0F70 7F00 0000 0000 F707 C7F0"
	$"0000 000F 707C 75F0 0000 00F7 07C7 55F0 0000 0F70 7C75 5F00 0000 F707 C755 F000"
	$"000F 707C 755F 0000 00F7 07C7 55F0 0000 0FC2 CC75 5F00 0000 0F2C 2C55 F000 0000"
	$"0FC2 C25F 0000 0000 0FFC 2CF0 0000 0000 0FFF FF00 0000 0000 0000 0000 0000 0000"
};

data 'ics8' (kBaseResourceID + 1) {
	$"0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 FFFF FF00 0000"
	$"0000 0000 0000 0000 00FF 2A00 54FF 0000 0000 0000 0000 0000 FF2A 0054 5454 FF00"
	$"0000 0000 0000 00FF 2A00 5454 54AB FF00 0000 0000 0000 FF2A 0054 5454 ABAB FF00"
	$"0000 0000 00FF 2A00 5454 54AB ABFF 0000 0000 0000 FF2A 0054 5454 ABAB FF00 0000"
	$"0000 00FF 2A00 5454 54AB ABFF 0000 0000 0000 FF2A 0054 5454 ABAB FF00 0000 0000"
	$"00FF 0808 0854 54AB ABFF 0000 0000 0000 00FF 0808 0808 ABAB FF00 0000 0000 0000"
	$"00FF 0808 0833 ABFF 0000 0000 0000 0000 00FF FF08 3333 FF00 0000 0000 0000 0000"
	$"00FF FFFF FFFF 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000"
};

/*  Keyboard Icon Resources - These resources define the icon that is used to represent our
    text service in the keyboard menu, menu bar, and System Preferences. */

data 'kcs#' (kBaseResourceID) {
	$"0000 0280 0280 0280 600C 783C 6C6C 3C78 0000 0100 0380 E00E 7BBC 3FF8 0FE0 0000"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};

data 'kcs4' (kBaseResourceID) {
	$"0000 0000 0000 0000 0000 00F0 F000 0000 0000 00F0 F000 0000 0000 00F0 F000 0000"
	$"0FF0 0000 0000 FF00 0FFF F000 00FF FF00 0FF0 FF00 0FF0 FF00 00FF FF00 0FFF F000"
        $"0000 0000 0000 0000 0000 000F 0000 0000 0000 00FF F000 0000 FFF0 0000 0000 FFF0"
	$"0FFF F0FF F0FF FF00 00FF FFFF FFFF F000 0000 FFFF FFF0 0000 0000 0000 0000 0000"
};

data 'kcs8' (kBaseResourceID) {
	$"0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 FF00 FF00 0000 0000 0000"
	$"0000 0000 0000 FF00 FF00 0000 0000 0000 0000 0000 0000 FF00 FF00 0000 0000 0000"
	$"00FF FF00 0000 0000 0000 0000 FFFF 0000 00FF FFFF FF00 0000 0000 FFFF FFFF 0000"
	$"00FF FF00 FFFF 0000 00FF FF00 FFFF 0000 0000 FFFF FFFF 0000 00FF FFFF FF00 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 00FF 0000 0000 0000 0000"
	$"0000 0000 0000 FFFF FF00 0000 0000 0000 FFFF FF00 0000 0000 0000 0000 FFFF FF00"
	$"00FF FFFF FF00 FFFF FF00 FFFF FFFF 0000 0000 FFFF FFFF FFFF FFFF FFFF FF00 0000"
	$"0000 0000 FFFF FFFF FFFF FF00 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000"
};

resource 'MENU' (kBaseResourceID + 1)
{
    kBaseResourceID,
    textMenuProc,
    allEnabled,
    enabled,
    "00000",
    {
        "Show Keyboard Palette", noIcon, "K", noMark, plain,
        "Show Send Event Palette", noIcon, "D", noMark, plain,
        "-", noIcon, noKey, noMark, plain,
        "Convert To Lowercase", noIcon, "L", noMark, plain,
        "Convert To Uppercase", noIcon, "U", noMark, plain
    }
};

resource 'xmnu' (kBaseResourceID + 1)
{
    versionZero
    {
        {
            dataItem {'SHKP', kMenuShiftModifier + kMenuControlModifier + kMenuNoCommandModifier,
                      currScript, 0, 0, noHierID, sysFont, naturalGlyph},
            dataItem {'SHDP', kMenuShiftModifier + kMenuControlModifier + kMenuNoCommandModifier,
                      currScript, 0, 0, noHierID, sysFont, naturalGlyph},
            skipItem {},
            dataItem {'CLOW', kMenuShiftModifier + kMenuControlModifier + kMenuNoCommandModifier,
                      currScript, 0, 0, noHierID, sysFont, naturalGlyph},
            dataItem {'CUPP', kMenuShiftModifier + kMenuControlModifier + kMenuNoCommandModifier,
                      currScript, 0, 0, noHierID, sysFont, naturalGlyph}
        }
    }
};

resource 'STR ' (kBaseResourceID)
{
    "MacUIM"
};

resource 'STR#' (kBaseResourceID + 1)
{
    {
	"Show Keyboard Palette",
        "Hide Keyboard Palette",
	"Show Send Event Palette",
        "Hide Send Event Palette"
    }
};
