/* -*- mode:objc; coding:utf-8; tab-width:8; c-basic-offset:2; indent-tabs-mode:nil -*- */
/*
  Copyright (c) 2004 MacUIM Project
  http://www.digital-genes.com/~yatsu/macuim/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.
*/

#import <uim/uim.h>
#import "Preference.h"
#import "MacUIMPrefPane.h"

@implementation MacUIMPrefPane
 
/**
 * Deallocate
 */
- (void)dealloc
{
  if (numModules > 0 && imModules) {
    int i;
    for (i = 0; i < numModules; i++) {
      free(imModules[i]->name);
      free(imModules[i]->lang);
    }
    free(imModules);
  }
  [super dealloc];
}

- (id)initWithBundle:(NSBundle *)bundle
{
  uim_context uc;

  // Initialize the location of our preferences
  if ((self = [super initWithBundle:bundle]) != nil) {
    appID = CFSTR(kAppID);
  }

  numModules = 0;
  imModules = NULL;

  uim_init();
  uc = uim_create_context(NULL, "UTF-8",
			  NULL, NULL, uim_iconv, NULL);
  if (uc) {
    numModules = uim_get_nr_im(uc);
    printf("MacUIMPrefPane::initWithBundle() numModules=%d imButton=%p\n",
           numModules, imButton);
    imModules = (IMModule **) malloc(sizeof(IMModule *) * numModules);
    if (*imModules != NULL) {
      int i;
      for (i = 0; i < numModules; i++) {
        imModules[i] = (IMModule *) malloc(sizeof(IMModule));
        if (imModules[i]) {
          imModules[i]->index = i;
          imModules[i]->name = strdup(uim_get_im_name(uc, i));
          imModules[i]->lang = strdup(uim_get_im_language(uc, i));

          printf("%s (%s)\n",
                 imModules[i]->name,
                 imModules[i]->lang);
        }
      }
    }
    uim_release_context(uc);
  }

  return self;
}

- (void)mainViewDidLoad
{
  CFPropertyListRef imVal;
  int i;

  // Load the value
  imVal = CFPreferencesCopyAppValue(CFSTR("InputMethod"), appID);

#if 0
  if (imVal && CFGetTypeID(imVal) == CFStringGetTypeID()) {
    if (CFStringCompare((CFStringRef) imVal, CFSTR(kIMStrAnthy), NULL)
        == kCFCompareEqualTo)
      [imButton selectItemAtIndex:kIMTypeAnthy];
    else if (CFStringCompare((CFStringRef) imVal, CFSTR(kIMStrPRIME), NULL)
             == kCFCompareEqualTo)
      [imButton selectItemAtIndex:kIMTypePRIME];
    else
      [imButton selectItemAtIndex:kIMTypeSKK];
  }
  else
    [imButton selectItemAtIndex:kIMTypeSKK];
#endif

  [imButton removeAllItems];

  for (i = 0; i < numModules; i++) {
    if (strlen(imModules[i]->lang) > 0)
      [imButton addItemWithTitle:[NSString stringWithFormat:@"%s (%s)",
                                           imModules[i]->name,
                                           imModules[i]->lang]];
    else
      [imButton addItemWithTitle:[NSString stringWithFormat:@"%s",
                                           imModules[i]->name,
                                           imModules[i]->lang]];
  }

  if (imVal && CFGetTypeID(imVal) == CFStringGetTypeID()) {
    NSString *current = (NSString *) imVal;
    for (i = 0; i < numModules; i++) {
      if ([current isEqualToString:[NSString stringWithCString:imModules[i]->name]]) {
        [imButton selectItemAtIndex:i];
        break;
      }
    }
  }

  [tab selectFirstTabViewItem:self];
}

- (void)didUnselect
{
  CFNotificationCenterRef center;

  [self prefSync];

  // Write out all the changes
  CFPreferencesAppSynchronize(appID);

  // Post a notification that the preferences have changed
  center = CFNotificationCenterGetDistributedCenter();
  CFNotificationCenterPostNotification(center,
                                       CFSTR("Preferences Changed"),
                                       appID, NULL, TRUE);
}

/**
 * Imput method changed
 */
- (IBAction)imChange:(id)sender
{
  [self prefSync];
  
  // Force a synchronization so our preference is "live"
  CFPreferencesAppSynchronize(appID);
}

- (void)prefSync
{
  int i = [[imButton objectValue] intValue];

  CFPreferencesSetAppValue(CFSTR("InputMethod"),
                           CFSTR(kDefaultIM), appID);

  if ([[imButton objectValue] intValue] < numModules) {
    if (imModules && imModules[i])
      CFPreferencesSetAppValue(CFSTR("InputMethod"),
                               (CFStringRef) [NSString stringWithCString:imModules[i]->name],
                               appID);
  }
}

@end
