-- --------------------------------------------------------------------------------------------------
-- 基本テーブルデータ登録スクリプト
-- ベースシステム(フレームワーク)で最小限必要な初期データの登録を行う
-- --------------------------------------------------------------------------------------------------

-- システム設定マスター
-- システムの動作に影響する設定を管理する
INSERT INTO _system_config (sc_id,                         sc_value, sc_name,                sc_index) VALUES
('system_name',                 'Magic3',     'システム名称',                    0),
('db_version',                  '2008090201', 'DBバージョン',                    1),
('server_id',                   '',           'サーバ識別用ID',                  2),
('default_lang',                'ja',         'デフォルト言語',                  3),
('multi_language',               '0',          '多言語対応',                      4),
('csv_upload_encoding',         'SJIS-win',   'CSVアップロードエンコード',       5),
('csv_download_encoding',       'SJIS-win',   'CSVダウンロードエンコード',       6),
('csv_delim_code',              ',',          'CSV区切りコード',                 7),
('csv_nl_code',                 '\r\n',       'CSV改行コード',                   8),
('csv_file_suffix',             '.csv',       'CSVファイル拡張子',               9),
('permit_init_system',          '0',          'システム初期化許可',              10),
('permit_change_lang',          '1',          '処理言語変更許可',                11),
('permit_detail_config',        '0',          'システム詳細設定許可',            12),
('regenerate_session_id',       '0',          'セッションID毎回更新',            13),
('script_cache_in_browser',     '1',          'ブラウザのスクリプトキャッシュ',  14),
('site_in_public',              '1',          'サイト公開',                      15),
('site_m_in_public',            '1',          '携帯サイト公開',                  16),
('site_access_exception_ip',    '',           'サイトアクセス制御なしIP',        17),
('toppage_image_path',          '',           'トップページ画像パス',            18),
('mobile_encoding',             'SJIS',       '携帯用画面エンコード',            19),
('install_dt',                  '',           'インストール日時',                20),
('log_dir',                     '',           'ログ出力ディレクトリ',            21),
('work_dir',                    '',           '作業用ディレクトリ',              22);

-- 多言語対応文字列マスター
INSERT INTO _language_string
(ls_id,               ls_language_id, ls_value,       ls_name,              ls_index) VALUES
('widget_alias_name', 'ja',           'ウィジェット', 'ウィジェットの別名', 0);

-- 言語マスター
INSERT INTO `_language` (`ln_id`, `ln_name`, `ln_name_en`, `ln_priority`) VALUES
('ja', '日本語',     'Japanese', 0),
('en', '英語',       'English',  1),
('de', 'ドイツ語',   'German',   2),
('fr', 'フランス語', 'French',   3),
('es', 'スペイン語', 'Spanish',  4),
('it', 'イタリア語', 'Italian',  5),
('zh', '中国語',     'Chinese',  6),
('ko', '韓国語',     'Korean',   7),
('ru', 'ロシア語',   'Russian',  8),
('el', 'ギリシャ語', 'Greek',    9),
('la', 'ラテン語',   'Latin',    10),
('ms', 'マレー語',   'Malay',    11),
('ar', 'アラビア語', 'Arabic',   12);

-- バージョン管理マスター
INSERT INTO _version (vs_id,         vs_value,     vs_name)
VALUES               ('basic_table', '2008013001', '基本テーブルのバージョン');

-- ログインユーザマスター
INSERT INTO `_login_user` (`lu_id`, `lu_account`, `lu_password`, `lu_name`,  `lu_user_type`, `lu_assign`, `lu_create_dt`) VALUES
(1,     'admin',    md5('admin'),     '管理者', 100,          'sy,',       now());

-- 管理画面メニューデータ
INSERT INTO _nav_item
(ni_id, ni_parent_id, ni_index, ni_nav_id,    ni_task_id,                     ni_group_id, ni_view_control, ni_param, ni_name,    ni_help_title, ni_help_body, ni_visible) VALUES
(100,   0,            0,        'admin_menu', '_page',                        '',          0,               '',       '画面管理', '画面管理', 'Webサイトのデザインや機能を管理します。', true),
(101,   100,          0,        'admin_menu', 'pagedef',                      '',          0,               '',           'PC用画面編集', 'PC用画面編集', 'PC用Webサイトの画面を作成します。', true),
(102,   100,          1,        'admin_menu', 'pagedef_mobile',               '',          0,               '',           '携帯用画面編集', '携帯用画面編集', '携帯用Webサイトの画面を作成します。', true),
(103,   100,          2,        'admin_menu', 'widgetlist',                   '',          0,               '',       'ウィジェット管理', 'ウィジェット管理', 'ウィジェットの管理を行います。', true),
(104,   100,          3,        'admin_menu', 'templist',                     '',          0,               '',       'テンプレート管理', 'テンプレート管理', 'テンプレートの管理を行います。', true),
(105,   100,          4,        'admin_menu', 'pageother',                    '',          0,               '',       'システムマスター管理', 'システムマスター管理', 'システムに関するデータの管理を行います。', true),
(200,   0,            1,        'admin_menu', '_login',                       '',          0,               '',       'ログイン管理', '', '', true),
(201,   200,          0,        'admin_menu', 'userlist',                     '',          0,               '',       'ユーザ一覧',   'ユーザ一覧', 'ログイン可能なユーザを管理します。', true),
(202,   200,          1,        'admin_menu', 'loginstatus',                  '',          0,               '',       'ログイン状況', 'ログイン状況', 'ユーザのログイン状況を表示します。', true),
(300,   0,            2,        'admin_menu', '_config',                      '',          0,               '',       'システム管理', '', '', true),
(301,   300,          0,        'admin_menu', 'configsite',                   '',          0,               '',       '基本情報', '基本情報', 'サイト運営者の設定を行います。メールアドレスは必須項目です。', true),
(302,   300,          1,        'admin_menu', 'configsys',                    '',          0,               '',       'システム情報', 'システム情報', 'システム全体の設定、運用状況を管理します。', true),
(303,   300,          2,        'admin_menu', 'initsystem',                   '',          0,               '',       'DBメンテナンス', 'DBメンテナンス', 'データの初期化などDBのメンテナンスを行います。', true),
(304,   300,          3,        'admin_menu', 'editmenu',                     '',          0,               '',       '管理メニュー編集', '管理メニュー編集', '管理機能のメインメニューを編集します。', true),
(399,   0,            3,        'admin_menu', '_399',                         '',          1,               '',       '改行', '', '', true),
(1100,  0,            11,       'admin_menu', '_others',                      '',          0,               '',       'その他', '', '', true),
(1101,  1100,         0,        'admin_menu', 'logout',                       '',          0,               '',       'ログアウト', 'ログアウト', '管理機能からログアウトします。', true);

-- テンプレート表示位置マスター
INSERT INTO `_template_position` (`tp_id`,       `tp_name`, `tp_description`, `tp_sort_order`) VALUES
('main',      'main',      '',             0),
('left',      'left',      '',             1),
('right',     'right',      '',             2),
('center',    'center',      '',             3),
('top',       'top',      '',             4),
('bottom',    'bottom',      '',             5),
('header',    'header',      '',             6),
('footer',    'footer',      '',             7),
('navi',      'navi',      '',             8),
('inset',     'inset',      '',             9),
('banner',    'banner',      '',             10),
('newsflash', 'newsflash',      '',          11),
('legals',    'legals',      '',             12),
('pathway',   'pathway',      '',            13),
('toolbar',   'toolbar',      '',            14),
('cpanel',    'cpanel',      '',             15),
('user1',     'user1',      '',             16),
('user2',     'user2',      '',             17),
('user3',     'user3',      '',             18),
('user4',     'user4',      '',             19),
('user5',     'user5',      '',             20),
('user6',     'user6',      '',             21),
('user7',     'user7',      '',             22),
('user8',     'user8',      '',             23),
('user9',     'user9',      '',             24),
('advert1',   'advert1',      '',             25),
('advert2',   'advert2',      '',             26),
('advert3',   'advert3',      '',             27),
('advert4',   'advert4',      '',             28),
('advert5',   'advert5',      '',             29),
('icon',      'icon',      '',             30),
('debug',     'debug',      'デバッグ用',   31);

-- ウィジェット情報マスター
INSERT INTO _widgets (wd_id, wd_name, wd_type, wd_params, wd_author, wd_copyright, wd_license, wd_official_level, wd_add_script_lib, wd_read_scripts, wd_read_css, wd_available, wd_editable, wd_has_admin, wd_enable_operation, wd_use_instance_def, wd_is_initialized, wd_launch_index, wd_install_dt, wd_create_dt) VALUES
('admin_menu',       '管理用メニュー',             'ADMN',  '',     'Naoki Hirata', 'Magic3.org', 'GPL', 10,      '', true,            true,        false,        false,       false,        false,          false, true, 100, now(),now()),
('admin_menu2',       '管理用メニュー2',             'ADM2',  '',     'Naoki Hirata', 'Magic3.org', 'GPL', 10,    '', true,            true,        false,        false,       false,        false,          false, true, 100, now(),now()),
('admin_main',       '管理用画面',                 'ADBD',  '',     'Naoki Hirata', 'Magic3.org', 'GPL', 10,     'pagedef=jquery-ui-plus;pagedef_mobile=jquery-ui-plus;', true,            true,        false,        false,       false,        true,          false, true, 0,   now(),now());

-- ページIDマスター
INSERT INTO _page_id (pg_id,         pg_type, pg_default_sub_id, pg_path,       pg_name,          pg_description,                     pg_priority, pg_is_public, pg_mobile, pg_editable) VALUES
('index',       0,       'content',      'index',       'index',          'PC用アクセスポイント',                0,true,false,true),
('m_index',     0,       'content',      'm/index',     'm_index',        '携帯用アクセスポイント',              1,true,true,true),
('admin_index', 0,       'content',         'admin/index', 'admin_index',    '管理用アクセスポイント',           2,true,false,false),
('face',        1,       '',                '',            'トップ専用',     'トップ専用画面用',                 0,true,false,true),
('content',     1,       '',                '',            'コンテンツ',     'コンテンツ画面用',                 1,true,false,false),
('shop',        1,       '',                '',            'ECショップ',     'ECショップ画面用',                 2,true,false,true),
('shop_safe',        1,       '',                '',            'ECショップ(セキュリティ保護)',     'ECショップ(セキュリティ保護)画面用',                 3,true,false,true),
('bbs',         1,       '',                '',            '掲示板',         '掲示板画面用',                     4,true,false,true),
('blog',        1,       '',                '',            'ブログ',         'ブログ画面用',                     5,true,false,true),
('photo',       1,       '',                '',            'フォトアルバム', 'フォトアルバム画面用',             6,true,false,true),
('contact',     1,       '',                '',            'お問い合わせ',   'お問い合わせ画面用',               7,true,false,true),
('reserve',     1,       '',                '',            '予約',           '予約画面用',                       8,true,false,true),
('safe',        1,       '',                '',            'セキュリティ保護',   'セキュリティ保護画面用',       9,true,false,true),
('custom_admin',1,       '',                '',            '自由編集',       '管理用自由編集画面用',             100,false,false,true),
('test',        1,       '',                '',            'テスト用',       'テスト用非公開画面',               101,false,false,true);

-- ページ定義マスター
INSERT INTO `_page_def` (`pd_id`,         `pd_sub_id`, `pd_position_id`, `pd_index`, `pd_widget_id`,       `pd_config_id`, `pd_visible`, `pd_editable`, `pd_update_dt`) VALUES
('admin_index', '',        'top',          1,        'admin_menu2',       0,                   true,       false,       now()),
('admin_index', 'content',        'main',         1,        'admin_main',       0,                   true,       false,       now()),
('admin_index', 'custom_admin',   'left',         1,        'release_info',       0,                   true,       false,       now());

-- サイト定義マスター
INSERT INTO `_site_def` (`sd_id`,              `sd_language_id`, `sd_value`,         `sd_create_dt`) VALUES
('head_description', 'ja',           '', now()),
('head_keywords',    'ja',           '',     now()),
('head_robots',      'ja',           '',  now()),
('head_title',      'ja',           '',  now()),
('site_name',        'ja',           '',     now()),
('site_owner',       'ja',           '',     now()),
('site_copyright',  'ja',           '',     now()),
('site_email',       'ja',           '',     now()),
('license_key',  'ja',           '',     now()),
('license_email',       'ja',           '',     now()),
('license_name',  'ja',           '',     now()),
('license_zipcode',  'ja',           '',     now()),
('license_address',  'ja',           '',     now()),
('license_fax',  'ja',           '',     now());
