<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_product_displayWidgetContainer.php 867 2008-07-28 09:04:54Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_product_displayDb.php');

class admin_ec_product_displayWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// DB接続オブジェクト
	var $categoryPathArray;	// 選択中のカテゴリーの階層
	private $paramObj;		// パラメータ保存用オブジェクト
	private $idArray = array();		// 表示中のID
	private $currentSubList = array();		// 現在の選択中の表題に属する商品項目リスト
	private $imgSize;			// 選択中の画像サイズ
	const MAX_HIER_LEVEL = 20;		// カテゴリー階層最大値
	const DEFAULT_ROW_COUNT = 2;			// 表示する行の数
	const DEFAULT_COLUMN_COUNT = 3;			// 表示する列の数
	const PRODUCT_IMAGE_SMALL = 'small-product';		// 小サイズ商品画像ID
	const PRODUCT_IMAGE_MEDIUM = 'standard-product';		// 中サイズ商品画像ID
	const PRODUCT_IMAGE_LARGE = 'large-product';		// 大サイズ商品画像ID
	const DEFAULT_LIST_COUNT = 10;			// 最大リスト表示数		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_product_displayDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;

		// ユーザ情報、表示言語
		$userInfo		= $gEnvManager->getCurrentUserInfo();
		$this->langId	= $gEnvManager->getDefaultLanguage();
		$defaultLangName = $gEnvManager->getDefaultLanguageNameByCurrentLanguage();// デフォルト言語の現在の表示名を取得

		// デフォルト値設定
		$this->selType = 0;			// 現在の表題
		$title = '[未設定]';	// タイトル
		$detailLabel = 'もっと詳しく...';	// 詳細へのリンク
		$isVisibleAnytime = 0;		// 常に表示するかどうか
		$rowCount = self::DEFAULT_ROW_COUNT;			// 表示する行の数
		$columnCount = self::DEFAULT_COLUMN_COUNT;			// 表示する列の数
		$this->imgSize = self::PRODUCT_IMAGE_MEDIUM;				// 選択中の画像サイズ
		$nameVisible = 1;			// 商品名表示
		$codeVisible = 0;			// 商品コード表示
		$priceVisible = 1;			// 商品価格表示
		$descVisible = 0;			// 商品説明表示
		$imgVisible = 1;			// 商品画像表示
		$detailVisible = 0;			// 詳細ボタン表示
		
		$viewStyleType = 0;		// 表示形式(0=画像+商品名称,1=画像+商品説明)
		$useComment = 0;		// コメント欄を表示するかどうか
		$commentPos = 0;		// コメント欄の位置(0=下、1=上)
			
		// 呼び出し元からの設定値
		$act = $request->trimValueOf('act');
		if (empty($act)){		// 初期呼び出し時
			$defSerial = $request->trimValueOf('_defserial');		// ページ定義のレコードシリアル番号
			$configId = $request->trimValueOf('_defconfig');

			// 定義IDが設定されている場合は取得
			if (!empty($configId)) $this->selType = $configId;
		}
			
		if (empty($this->selType)) $this->selType = $request->trimValueOf('seltype');		// 選択中の表示タイプインデックス
		if (empty($this->selType)) $this->selType = 0;
		$index = $request->trimValueOf('index');		// 処理対象項目インデックス
		
		$value = $request->trimValueOf('defserial');		// ページ定義のレコードシリアル番号
		if (!empty($value)) $defSerial = $value;
		
		// 保存値を取得
		$this->paramObj = $this->getWidgetParamObj();
		if (empty($this->paramObj)){		// 保存値がないとき
			// 初期オブジェクトを作成
			$this->paramObj = array();
			$this->paramObj[] = new stdClass;
			$this->paramObj[0]->title	= '新着';// タイトル
			$this->paramObj[0]->detailLabel	= $detailLabel;// 詳細へのリンク
			$this->paramObj[0]->rowCount	= $rowCount;			// 表示する行の数
			$this->paramObj[0]->columnCount	= $columnCount;			// 表示する列の数
			$this->paramObj[0]->imgSize	= $this->imgSize;				// 選択中の画像サイズ
			$this->paramObj[0]->nameVisible	= $nameVisible;			// 商品名表示
			$this->paramObj[0]->codeVisible	= $codeVisible;			// 商品コード表示
			$this->paramObj[0]->priceVisible	= $priceVisible;			// 商品価格表示
			$this->paramObj[0]->descVisible	= $descVisible;			// 商品説明表示
			$this->paramObj[0]->imgVisible	= $imgVisible;			// 商品画像表示
			$this->paramObj[0]->detailVisible	= $detailVisible;			// 詳細ボタン表示
			
			$this->paramObj[] = new stdClass;
			$this->paramObj[1]->title	= 'おすすめ';// タイトル
			$this->paramObj[1]->detailLabel	= $detailLabel;// 詳細へのリンク
			$this->paramObj[1]->rowCount	= $rowCount;			// 表示する行の数
			$this->paramObj[1]->columnCount	= $columnCount;			// 表示する列の数
			$this->paramObj[1]->imgSize	= $this->imgSize;				// 選択中の画像サイズ
			$this->paramObj[1]->nameVisible	= $nameVisible;			// 商品名表示
			$this->paramObj[1]->codeVisible	= $codeVisible;			// 商品コード表示
			$this->paramObj[1]->priceVisible	= $priceVisible;			// 商品価格表示
			$this->paramObj[1]->descVisible	= $descVisible;			// 商品説明表示
			$this->paramObj[1]->imgVisible	= $imgVisible;			// 商品画像表示
			$this->paramObj[1]->detailVisible	= $detailVisible;			// 詳細ボタン表示
		}
		// 格納領域が小さいときは拡大
		for ($i = 0; $i < $this->selType - count($this->paramObj) + 1; $i++){
			$newObj = new stdClass;
			$newObj->title	= $title;// タイトル
			$newObj->detailLabel	= $detailLabel;// 詳細へのリンク
			$newObj->rowCount	= $rowCount;			// 表示する行の数
			$newObj->columnCount	= $columnCount;			// 表示する列の数
			$newObj->imgSize	= $this->imgSize;				// 選択中の画像サイズ
			$newObj->nameVisible	= $nameVisible;			// 商品名表示
			$newObj->codeVisible	= $codeVisible;			// 商品コード表示
			$newObj->priceVisible	= $priceVisible;			// 商品価格表示
			$newObj->descVisible	= $descVisible;			// 商品説明表示
			$newObj->imgVisible	= $imgVisible;			// 商品画像表示
			$newObj->detailVisible	= $detailVisible;			// 詳細ボタン表示
			$this->paramObj[] = $newObj;
		}
		$this->currentSubList = $this->paramObj[$this->selType]->subList;
		$title			= $this->paramObj[$this->selType]->title;// タイトル
		$detailLabel	= $this->paramObj[$this->selType]->detailLabel;// 詳細へのリンク
		$rowCount		= $this->paramObj[$this->selType]->rowCount;			// 表示する行の数
		$columnCount	= $this->paramObj[$this->selType]->columnCount;			// 表示する列の数
		$this->imgSize	= $this->paramObj[$this->selType]->imgSize;				// 選択中の画像サイズ
		$nameVisible	= $this->paramObj[$this->selType]->nameVisible;			// 商品名表示
		$codeVisible	= $this->paramObj[$this->selType]->codeVisible;			// 商品コード表示
		$priceVisible	= $this->paramObj[$this->selType]->priceVisible;			// 商品価格表示
		$descVisible	= $this->paramObj[$this->selType]->descVisible;			// 商品説明表示
		$imgVisible		= $this->paramObj[$this->selType]->imgVisible;			// 商品画像表示
		$detailVisible	= $this->paramObj[$this->selType]->detailVisible;			// 詳細ボタン表示
		
		if ($act == 'selcategory'){		// カテゴリー選択の場合
		} else if ($act == 'addtosub'){		// おすすめに追加の場合
			// 最大表示順を取得
			$viewIndex = 0;
			if (count($this->currentSubList)){
				for ($i = 0; $i < count($this->currentSubList); $i++){
					$subObj = $this->currentSubList[$i];
					$index = intval($subObj->index);
					if ($index > $viewIndex) $viewIndex = $index;
				}
			}
			
			$listedItem = explode(',', $request->trimValueOf('idlist'));
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_select';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				// お勧めに追加
				if ($itemValue){
					$subObj = new stdClass;
					$subObj->id = $listedItem[$i];
					$subObj->index = $viewIndex +1;
					$viewIndex++;
					$this->currentSubList[] = $subObj;
				}
			}
			// 表示順に項目をソートする
			usort($this->currentSubList, array($this, 'sortOrderByIndex'));
			
			// オブジェクトを保存
			$this->paramObj[$this->selType]->subList = $this->currentSubList;
			$ret = $this->updateWidgetParamObj($this->paramObj);
			if (!$ret) $this->setMsg(self::MSG_APP_ERR, '追加に失敗しました');
			$gPageManager->updateParentWindow();// 親ウィンドウを更新
		} else if ($act == 'updatelist'){	// おすすめリストを更新のとき
			for ($i = 0; $i < count($this->currentSubList); $i++){
				$itemName = 'item' . $i . '_view_index';
				$itemValue = $request->trimValueOf($itemName);
				$this->checkNumeric($itemValue, '表示順');
				if ($this->getMsgCount() == 0){			// エラーのないとき
					$subObj = $this->currentSubList[$i];
					$subObj->index = $itemValue;
				} else {
					break;
				}
			}
			if ($this->getMsgCount() == 0){			// エラーのないとき
				// 表示順に項目をソートする
				usort($this->currentSubList, array($this, 'sortOrderByIndex'));
			
				// オブジェクトを保存
				$this->paramObj[$this->selType]->subList = $this->currentSubList;
				$ret = $this->updateWidgetParamObj($this->paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
				$gPageManager->updateParentWindow();// 親ウィンドウを更新
			}
		} else if ($act == 'deleteline'){	// おすすめリスト項目削除のとき
			// おすすめ項目を削除
			array_splice($this->currentSubList, $index, 1);
			
			// 表示順に項目をソートする
			usort($this->currentSubList, array($this, 'sortOrderByIndex'));
			
			// オブジェクトを保存
			$this->paramObj[$this->selType]->subList = $this->currentSubList;
			$ret = $this->updateWidgetParamObj($this->paramObj);
			if ($ret){
				$this->setMsg(self::MSG_GUIDANCE, '項目を削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, '項目削除に失敗しました');
			}
			$gPageManager->updateParentWindow();// 親ウィンドウを更新
		} else if ($act == 'update'){		// 設定更新のとき
			// 入力値を取得
			$title	= $request->trimValueOf('item_title');			// ヘッダタイトル
			$detailLabel	= $request->trimValueOf('item_detail_label');// 詳細へのリンク
			$rowCount		= $request->trimValueOf('item_row');			// 表示する行の数
			$columnCount	= $request->trimValueOf('item_column');			// 表示する列の数
			$this->imgSize	= $request->trimValueOf('item_img_size');				// 選択中の画像サイズ
			$nameVisible	= ($request->trimValueOf('item_name_visible') == 'on') ? 1 : 0;			// 商品名表示
			$codeVisible	= ($request->trimValueOf('item_code_visible') == 'on') ? 1 : 0;			// 商品コード表示
			$priceVisible	= ($request->trimValueOf('item_price_visible') == 'on') ? 1 : 0;			// 商品価格表示
			$descVisible	= ($request->trimValueOf('item_desc_visible') == 'on') ? 1 : 0;			// 商品説明表示
			$imgVisible		= ($request->trimValueOf('item_img_visible') == 'on') ? 1 : 0;			// 商品画像表示
			$detailVisible	= ($request->trimValueOf('item_detail_visible') == 'on') ? 1 : 0;			// 詳細ボタン表示
			
			// 入力値のエラーチェック
			$this->checkNumeric($rowCount, '行数');
			$this->checkNumeric($columnCount, '列数');
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$this->paramObj[$this->selType]->title	= $title;// タイトル
				$this->paramObj[$this->selType]->detailLabel	= $detailLabel;// 詳細へのリンク
				$this->paramObj[$this->selType]->rowCount	= $rowCount;			// 表示する行の数
				$this->paramObj[$this->selType]->columnCount	= $columnCount;			// 表示する列の数
				$this->paramObj[$this->selType]->imgSize	= $this->imgSize;				// 選択中の画像サイズ
				$this->paramObj[$this->selType]->nameVisible	= $nameVisible;			// 商品名表示
				$this->paramObj[$this->selType]->codeVisible	= $codeVisible;			// 商品コード表示
				$this->paramObj[$this->selType]->priceVisible	= $priceVisible;			// 商品価格表示
				$this->paramObj[$this->selType]->descVisible	= $descVisible;			// 商品説明表示
				$this->paramObj[$this->selType]->imgVisible	= $imgVisible;			// 商品画像表示
				$this->paramObj[$this->selType]->detailVisible	= $detailVisible;			// 詳細ボタン表示				
				$ret = $this->updateWidgetParamObj($this->paramObj);
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
				$gPageManager->updateParentWindow();// 親ウィンドウを更新
			}
		} else if ($act == 'seldisplaytype'){		// 表示タイプを選択
			// 定義IDを更新
			$ret = $this->sysDb->updateWidgetConfigId($gEnvManager->getCurrentWidgetId(), $defSerial, $this->selType, $title);
			if ($ret){
				$message = '設定を「' . $title . '」に変更しました';
				$this->setMsg(self::MSG_GUIDANCE, $message);
			} else {
				$message = '設定「' . $title . '」の変更に失敗しました';
				$this->setMsg(self::MSG_APP_ERR, $message);
			}
			$gPageManager->updateParentWindow();// 親ウィンドウを更新
		} else {		// 初期表示の場合
			// 入力値初期化
		}
		
		// #### 商品リストを作成 ####
		$this->db->getAllProduct($this->langId, array($this, 'productListLoop'));
		//if ($this->categoryId == -1){
		//	$this->db->getProductByCategoryId(0/*カテゴリー未設定*/, $this->langId, 1, array($this, 'productListLoop'));// 単品商品リスト取得
		//} else if ($this->categoryId != 0){
		//	$this->db->getProductByCategoryId($this->categoryId, $this->langId, 1, array($this, 'productListLoop'));// 単品商品リスト取得
		//}
		
		// 表示項目のIDを設定
		$this->tmpl->addVar("_widget", "id_list", implode($this->idArray, ','));
		
		// お勧め選択項目を設定
		$this->createSubList();
		
		// 商品表示タイプメニューを作成
		$this->createDisplayTypeList();
		
		// 画像選択メニュー作成
		$this->createImgMenu();
		
		// 非表示項目の設定
		$this->tmpl->addVar("_widget", "def_serial", $defSerial);	// ページ定義のレコードシリアル番号
		//$this->tmpl->addVar("_widget", "configid", $configId);		// 定義ID
		
		// 画面にデータを埋め込む
		$this->tmpl->addVar("_widget", "title",	$title);
		$this->tmpl->addVar("_widget", "detail_label",	$detailLabel);// 詳細へのリンク
		$this->tmpl->addVar("_widget", "row",	$rowCount);// 表示する行の数
		$this->tmpl->addVar("_widget", "column",	$columnCount);// 表示する列の数
		if ($nameVisible) $this->tmpl->addVar('_widget', 'NAME_VISIBLE',	'checked');	// 商品名表示
		if ($codeVisible) $this->tmpl->addVar('_widget', 'CODE_VISIBLE',	'checked');			// 商品コード表示
		if ($priceVisible) $this->tmpl->addVar('_widget', 'PRICE_VISIBLE',	'checked');			// 商品価格表示
		if ($descVisible) $this->tmpl->addVar('_widget', 'DESC_VISIBLE',	'checked');			// 商品説明表示
		if ($imgVisible) $this->tmpl->addVar('_widget', 'IMG_VISIBLE',	'checked');			// 商品画像表示
		if ($detailVisible) $this->tmpl->addVar('_widget', 'DETAIL_VISIBLE',	'checked');			// 詳細ボタン表示
		
		// パスの設定
		$this->tmpl->addVar("_widget", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
		$this->tmpl->addVar("_widget", "root_url", $gEnvManager->getRootUrl());
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function productListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['pt_id']);
		
		$visible = '';
		if ($fetchedRow['pt_visible']){	// 項目の表示
			$visible = 'checked';
		}
		$row = array(
			'index' => $index,											// 項目インデックス
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['pt_serial']),	// シリアル番号
			'id' => $id,			// ID
			'name' => $this->convertToDispString($fetchedRow['pt_name']),		// 名前
			'code' => $this->convertToDispString($fetchedRow['pt_code']),		// 商品コード
			'view_index' => $this->convertToDispString($fetchedRow['pt_sort_order']),		// 表示順
			'lang' => $lang,													// 対応言語
			'update_user' => $this->convertToDispString($fetchedRow['lu_name']),	// 更新者
			'update_dt' => $this->convertToDispDateTime($fetchedRow['pt_create_dt']),	// 更新日時
			'visible' => $visible											// メニュー項目表示制御
		);
		$this->tmpl->addVars('productlist', $row);
		$this->tmpl->parseTemplate('productlist', 'a');
		
		// IDを保存
		$this->idArray[] = $id;
		return true;
	}
	/**
	 * おすすめ項目リスト作成
	 *
	 * @return なし						
	 */
	function createSubList()
	{
		for ($i = 0; $i < count($this->currentSubList); $i++){
			$subObj = $this->currentSubList[$i];
			$id = $subObj->id;
			
			// 行カラーの設定
			$lineColor = '';
			if ($i % 2 != 0){
				$lineColor = 'class="even"';		// 偶数行
			}
			// 商品情報を取得
			$ret = $this->db->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4);
			if ($ret){
				$name = $this->convertToDispString($row['pt_name']);		// 名前
			} else {
				$name = '商品情報取得不可';
			}
			$visible = '';
			if ($row['pt_visible']) $visible = 'checked';
			$row = array(
				'no' => $i + 1,											// 項目番号
				'index' => $i,											// 項目インデックス
				'line_color' => $lineColor,											// 行のカラー
				'id' => $id,			// ID
				'name' => $name,		// 名前
				'code' => $this->convertToDispString($row['pt_code']),		// 商品コード
				'view_index' => $subObj->index,		// 表示順
				'visible' => $visible											// メニュー項目表示制御
			);
			$this->tmpl->addVars('currentsublist', $row);
			$this->tmpl->parseTemplate('currentsublist', 'a');
		}
	}
	/**
	 * 画像サイズ選択メニュー作成
	 *
	 * @return なし						
	 */
	function createImgMenu()
	{
		$name = '小';
		$value = self::PRODUCT_IMAGE_SMALL;
		$selected = '';
		if ($value == $this->imgSize) $selected = 'selected';				// 選択中の画像サイズ
		$row = array(
			'name' => $name,		// 名前
			'value' => $value,		// 値
			'selected' => $selected	// 選択中の項目かどうか
		);
		$this->tmpl->addVars('img_size_list', $row);
		$this->tmpl->parseTemplate('img_size_list', 'a');
		
		$name = '中';
		$value = self::PRODUCT_IMAGE_MEDIUM;
		$selected = '';
		if ($value == $this->imgSize) $selected = 'selected';				// 選択中の画像サイズ
		$row = array(
			'name' => $name,		// 名前
			'value' => $value,		// 値
			'selected' => $selected	// 選択中の項目かどうか
		);
		$this->tmpl->addVars('img_size_list', $row);
		$this->tmpl->parseTemplate('img_size_list', 'a');
		
		$name = '大';
		$value = self::PRODUCT_IMAGE_LARGE;
		$selected = '';
		if ($value == $this->imgSize) $selected = 'selected';				// 選択中の画像サイズ
		$row = array(
			'name' => $name,		// 名前
			'value' => $value,		// 値
			'selected' => $selected	// 選択中の項目かどうか
		);
		$this->tmpl->addVars('img_size_list', $row);
		$this->tmpl->parseTemplate('img_size_list', 'a');
	}
	/**
	 * 商品表示タイプの選択用リスト
	 *
	 * @return なし						
	 */
	function createDisplayTypeList()
	{
		for ($i = 0; $i < count($this->paramObj); $i++){
			$targetObj = $this->paramObj[$i];
			$name = $targetObj->title;// タイトル
			$value = $i;
			$selected = '';
			if ($this->selType == $i) $selected = 'selected';
			$row = array(
				'name' => $name,		// 名前
				'value' => $value,		// 値
				'selected' => $selected	// 選択中の項目かどうか
			);
			$this->tmpl->addVars('display_type_list', $row);
			$this->tmpl->parseTemplate('display_type_list', 'a');
		}
	}
	/**
	 * オブジェクトをindexメンバーの値で昇順にソートする
	 *
	 * @param object  	$obj1			比較するオブジェクト1
	 * @param object	$obj2			比較するオブジェクト2
	 * @return int						同じとき0、1が2より大きいとき1,1がより小さいとき-1を返す
	 */
	function sortOrderByIndex($obj1, $obj2)
	{
		if ($obj1->index == $obj2->index) return 0;
		return ($obj1->index < $obj2->index) ? -1 : 1;
	}
}
?>
