<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_menu2WidgetContainer.php 1334 2008-12-11 02:54:06Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_menuDb.php');

class admin_menu2WidgetContainer extends BaseWidgetContainer
{
	var $db;	// DB接続オブジェクト

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new admin_menuDB();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		
		// システム制御画面のときはメニューを作成しないで終了
		if ($gPageManager->getSystemHandleMode() > 0){
			return;
		}
		
		if ($gEnvManager->isSystemAdmin()){	// システム管理者の場合
			$menu = $request->trimValueOf('menu');
			$openBy = $request->trimValueOf(M3_REQUEST_PARAM_OPEN_BY);		// ウィンドウオープンタイプ
			
			// ページIDを取得
			$pageSubId = $request->trimValueOf(M3_REQUEST_PARAM_PAGE_SUB_ID);
			
			// メニューの表示制御
			$menuStatus = $request->trimValueOf('showmenu');
			if (!empty($menuStatus)){
				if ($menuStatus == 'false'){
					$paramObj->showMenu = 0;	// メニューを表示するかどうか
				} else if ($menuStatus == 'true'){
					$paramObj->showMenu = 1;	// メニューを表示するかどうか
				}
				$ret = $this->updateWidgetParamObj($paramObj);
			}
			
			// タスクを取得
			$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
			$selectedItemId = 0;			// 選択中の項目ID
			$selectedParemtItemId = 0;		// 選択中の項目の親項目ID
			if (!empty($task) && $this->db->getNavItemsByTask('admin_menu', $task, $row)){
				$selectedItemId = $row['ni_id'];
				$selectedParemtItemId = $row['ni_parent_id'];
			}
			
			// メニューを作成
			$menuInner = '';
			$subItemId = 'sb';
			
			// 「トップ」作成
			$menuInner .= '<li>';
			$menuInner .= '<a href="' . $gEnvManager->getDefaultAdminUrl() .'">トップ</a>&nbsp;&nbsp;|' . M3_NL;
			$menuInner .= str_repeat(' ', 4);
			$menuInner .= '<ul>' . M3_NL;
			$menuInner .= str_repeat(' ', 4);
			$menuInner .= '</ul>' . M3_NL;
			$menuInner .= '</li>' . M3_NL;
					
			// トップレベル項目を取得
			if ($this->db->getNavItems('admin_menu', 0, $rows)){
				$topMenuCount = count($rows);
				for ($i = 0; $i < $topMenuCount; $i++){
					if ($rows[$i]['ni_view_control'] == 0){		// 改行以外のとき
						$topId = $rows[$i]['ni_id'];
					
						// サブレベル取得
						$this->db->getNavItems('admin_menu', $topId, $subRows);
						// 初期表示画面
						if (count($subRows) > 0) $firstTask = '?task=' . $subRows[0]['ni_task_id'];
					
						// 「li」タグ
						$menuInner .= '<li>';
					
						// 「a」タグ
						// リンク先を作成。「_」で始まるタスクはリンクを作成しない
						$topLink = '#';
						$linkTask = $rows[$i]['ni_task_id'];
						if (strncmp($linkTask, '_', strlen('_')) != 0) $topLink = '?task=' . $linkTask;	// 起動タスクパラメータを設定
						$menuInner .= str_repeat(' ', 4);
						$menuInner .= '<a href="' . $topLink . '">' . $this->convertToDispString($rows[$i]['ni_name']) . '</a>&nbsp;&nbsp;|' . M3_NL;
					
						// 「ul」タグ
						$menuInner .= str_repeat(' ', 4);
						$menuInner .= '<ul>' . M3_NL;
					
						// 「li」タグ
						if (count($subRows) > 0){
							for ($l = 0; $l < count($subRows); $l++){
								$menuInner .= str_repeat(' ', 8);
								$menuInner .= '<li ';
								$menuInner .= '><a href="';
								$menuInner .= '?task=' . $subRows[$l]['ni_task_id'];	// 起動タスクパラメータを設定
								if (!empty($subRows[$l]['ni_param'])){		// パラメータが存在するときはパラメータを追加
									$menuInner .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode($subRows[$l]['ni_param']);
								}
								$menuInner .= '" >' . $this->convertToDispString($subRows[$l]['ni_name']) . '</a></li>' . M3_NL;
							}
						}
						$menuInner .= str_repeat(' ', 4);
						$menuInner .= '</ul>' . M3_NL;
						$menuInner .= '</li>' . M3_NL;
					}
				}
			}
			$this->tmpl->addVar("menu", "menu_inner", $menuInner);
			$this->tmpl->addVar("menu", "widget_url", $gEnvManager->getCurrentWidgetRootUrl());	// ウィジェットのルートディレクトリ
			
			// メニューを表示
			//$showMenu = true;
			if ($menu == 'off'){	// メニュー非表示指定のとき
			} else if (!empty($openBy)){	// 別ウィンドウで表示のときは閉じるボタン表示
				$this->tmpl->setAttribute('closebutton', 'visibility', 'visible');
			} else {	// メニュー表示のとき
				$showMenu = 0;		// メニューを表示するかどうか
				$paramObj = $this->getWidgetParamObj();
				if (!empty($paramObj)){
					$showMenu = $paramObj->showMenu;			// メニューを表示するかどうか
				}
			
				if (empty($task) && empty($pageSubId)){	// トップ画面のとき
					$this->tmpl->setAttribute('menuvisiblebutton', 'visibility', 'visible');
					if ($showMenu == 0){		// メニュー非表示のとき
						$this->tmpl->addVar("menuvisiblebutton", "url", $gEnvManager->getDefaultAdminUrl() . '?showmenu=true');
						$this->tmpl->addVar("menuvisiblebutton", "label", 'メニューバーを表示');
					} else {
						$this->tmpl->addVar("menuvisiblebutton", "url", $gEnvManager->getDefaultAdminUrl() . '?showmenu=false');
						$this->tmpl->addVar("menuvisiblebutton", "label", 'メニューバーを隠す');
					}
					$this->tmpl->addVar("menuvisiblebutton", "top_url", $gEnvManager->getDefaultAdminUrl());		// トップメニュー画面URL
				}
				if ($showMenu) $this->tmpl->setAttribute('menu', 'visibility', 'visible');
				
				// トップ画面に遷移するボタンを表示
				$this->tmpl->addVar("backbutton", "top_url", $gEnvManager->getDefaultAdminUrl());		// トップメニュー画面URL
				if ((!empty($task) || !empty($pageSubId)) && $showMenu == 0){
					$this->tmpl->setAttribute('backbutton', 'visibility', 'visible');
				}
			}
		}
	}
	/**
	 * メニューを常時表示するかどうか
	 *
	 * @return bool		true=常時表示、false=表示しない
	 */
	function menubarAlwaysVisible()
	{
		return $this->db->menubarAlwaysVisible();
	}
}
?>
