<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_mainDelivmethodWidgetContainer.php 1725 2009-04-09 02:43:32Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainCartDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');
require_once($gEnvManager->getCurrentWidgetLibPath() .	'/cart.php');

class ec_mainDelivmethodWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $cartDb;		// カートアクセス用ＤＢオブジェクト
	private $productDb;	// DB接続オブジェクト
	private $ecObj;		// 価格計算
	private $cartObj;		// カート処理
	private $zipcode;	// 郵便番号
	private $stateId;	// 都道府県ID
	private $deliveryMethod;		// 配送方法
	private $cartId;
	private $userId;		// 現在のユーザ
	private $langId;		// 現在の言語
	private $productTotal;		// 商品合計額
	private $productCount;		// 商品総数
	private $demandTime;	// 希望時間帯
	private $demandDt;		// 希望日
	private $replaceNew;		// データを再取得するかどうか
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const DEFAULT_COUNTRY_ID = 'JPN';	// デフォルト国ID
	const STANDARD_PRICE = 'selling';		// 通常価格
	const NEXT_TASK = 'payment';		// 購入処理中の次の処理
	const GOBACK_TASK = 'delivery';		// 購入処理中の前の処理
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new ec_mainOrderDb();
		$this->cartDb = new ec_mainCartDb();
		$this->productDb = new productDb();
		
		// オブジェクト作成
		$this->ecObj = $this->gInstance->getObject(self::PRICE_OBJ_ID);		// 価格計算用
		$this->cartObj = new cart();		// カート処理
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'delivery_method.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$now = date("Y/m/d H:i:s");	// 現在日時
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		$this->userId = $this->gEnv->getCurrentUserId();
		$defaultCurrency = $this->ecObj->getDefaultCurrency();		// 通貨
		
		// 初期データ取得
		// クッキー読み込み、カートIDを取得。カートの商品を集計する(配送料金の計算に必要)
		$this->cartId = $request->getCookieValue(M3_COOKIE_CART_ID);
		$this->productTotal = 0;		// 合計価格
		$this->productCount = 0;		// 商品総数
		$ret = $this->cartObj->getTotalPrice($this->cartId, $this->langId, $price, $count);
		if ($ret){
			$this->productTotal = $price;
			$this->productCount = $count;	// 商品総数
		} else {
			// カート内の商品の価格が変更されている場合はカート画面へ遷移
		}
		
		$act = $request->trimValueOf('act');
		$this->deliveryMethod = $request->trimValueOf('item_delivery_method');	// 配送方法
		
		$this->replaceNew = false;		// データを再取得するかどうか
		if ($act == 'regist'){			// 配送先仮登録
			$this->checkInput($this->deliveryMethod, 'お届け方法', 'お届け方法が選択されていません');
			
			// エラーなしの場合
			if ($this->getMsgCount() == 0){
				// 保存値を取得
				if (empty($this->userId)){			// 非会員の購入の場合
					$cid = $this->gAccess->getClientId();			// ブラウザのクライアントID
					$ret = $this->db->getOrderSheetByClientId($cid, $row);		// クライアントIDで注文情報を取得
					if (!$ret) $this->db->delOrderSheetByClientId($this->gAccess->getClientId());		// エラーのときはエラーデータを削除
				} else {
					// 受注処理
					$cid = '';			// ブラウザのクライアントIDは使用しない
					$ret = $this->db->getOrderSheet($this->userId, $this->langId, $row);
				}
				if ($ret){
					// 配送料計算に必要な変数を取得
					$this->zipcode = $row['oe_deliv_zipcode'];	// 郵便番号
					$this->stateId = $row['oe_deliv_state_id'];	// 都道府県

					// 配送料金を求める
					$currency_id = $defaultCurrency;
					$subtotal = $this->productTotal;		// 商品合計
					$deliv_fee = 0;		// 配送料
					$this->demandTime = '';	// 希望時間帯
					$this->demandDt = $this->gEnv->getInitValueOfTimestamp();		// 希望日
					$appoint_dt = $this->gEnv->getInitValueOfTimestamp();		// 予定納期
					if ($this->db->getDelivMethod($this->deliveryMethod, $this->langId, 0/*デフォルトのセットID*/, $delivMethodRow)){
						$iWidgetId	= $delivMethodRow['do_iwidget_id'];	// インナーウィジェットID
						if (!empty($iWidgetId)){
							// パラメータをインナーウィジェットに設定し、計算結果を取得
							$optionParam->id = $delivMethodRow['do_id'];
							$optionParam->init = true;		// 初期データ取得
							$optionParam->userId = $this->userId;					// ログインユーザID
							$optionParam->languageId = $this->langId;		// 言語ID
							$optionParam->cartId = $this->cartId;					// 商品のカート
							$optionParam->productTotal = $subtotal;				// 商品総額
							$optionParam->productCount = $this->productCount;	// 商品総数
							$optionParam->zipcode = $this->zipcode;		// 配送先の郵便番号
							$optionParam->stateId = $this->stateId;		// 配送先の都道府県
							if ($this->calcIWidgetParam($iWidgetId, $delivMethodRow['do_id'], $delivMethodRow['do_param'], $optionParam, $resultObj)){
								if (isset($resultObj->price)) $deliv_fee = $resultObj->price;		// 配送料金
								if (isset($resultObj->date)) $this->demandDt = $resultObj->date;	// 希望日
								if (isset($resultObj->time)) $this->demandTime = $resultObj->time;	// 希望時間帯
							}
						}
					}
					$charge = 0;		// 手数料
					$discount = 0;		// 値引き額
					$total = $subtotal - $discount + $deliv_fee + $charge;		// 総支払額を求める
						
					$ret = $this->db->updateOrderSheet($this->userId, $this->langId, $cid,
						$row['oe_custm_id'], $row['oe_custm_name'], $row['oe_custm_name_kana'], $row['oe_custm_person'], $row['oe_custm_person_kana'],
						$row['oe_custm_zipcode'], $row['oe_custm_state_id'], $row['oe_custm_address1'], $row['oe_custm_address2'], $row['oe_custm_phone'], $row['oe_custm_fax'], $row['oe_custm_email'], $row['oe_custm_country_id'], 
						$row['oe_deliv_id'], $row['oe_deliv_name'], $row['oe_deliv_name_kana'], $row['oe_deliv_person'], $row['oe_deliv_person_kana'],
						$row['oe_deliv_zipcode'], $row['oe_deliv_state_id'], $row['oe_deliv_address1'], $row['oe_deliv_address2'], $row['oe_deliv_phone'], $row['oe_deliv_fax'], $row['oe_deliv_email'], $row['oe_deliv_country_id'],
						$row['oe_bill_id'], $row['oe_bill_name'], $row['oe_bill_name_kana'], $row['oe_bill_person'], $row['oe_bill_person_kana'], 
						$row['oe_bill_zipcode'], $row['oe_bill_state_id'], $row['oe_bill_address1'], $row['oe_bill_address2'], $row['oe_bill_phone'], $row['oe_bill_fax'], $row['oe_bill_email'], $row['oe_bill_country_id'],
						$this->deliveryMethod, $row['oe_pay_method_id'], $row['oe_card_type'], $row['oe_card_owner'], $row['oe_card_number'], $row['oe_card_expires'],
						$this->demandDt, $this->demandTime, $appoint_dt, $currency_id, $subtotal, $discount, $deliv_fee, $charge, $total);
					if ($ret){
						$this->replaceNew = true;		// データを再取得
						
						// エラーがなければ次の画面へ
						$nextPage = $this->gEnv->createCurrentPageUrl() . '&task=' . self::NEXT_TASK;
						$this->gPage->redirect($nextPage);
						return;
					}
				}
				$this->setAppErrorMsg('データ更新に失敗しました');
			}
		} else {		// 初期表示
			$this->replaceNew = true;		// データを再取得
			
			// すでにデータが登録されている場合は登録データを表示
			if (empty($this->userId)){			// 非会員の購入の場合
				$ret = $this->db->getOrderSheetByClientId($this->gAccess->getClientId(), $row);// クライアントIDから登録データを取得
				if (!$ret) $this->db->delOrderSheetByClientId($this->gAccess->getClientId());		// エラーのときはエラーデータを削除
			} else {		// 会員の購入の場合
				$ret = $this->db->getOrderSheet($this->userId, $this->langId, $row);
			}
			if ($ret){			// データが既に登録済みのとき
				$this->zipcode = $row['oe_deliv_zipcode'];
				$this->stateId = $row['oe_deliv_state_id'];
				$this->deliveryMethod = $row['oe_deliv_method_id'];			// 支払方法
				$this->demandTime = $row['oe_demand_time'];			// 希望時間帯
				$this->demandDt = $row['oe_demand_dt'];			// 希望日
			}
		}
		// 配送方法メニューを作成
		$this->db->getAllDelivMethod($this->langId, 0/*デフォルトのセットID*/, array($this, 'delivMethodLoop'));
		
		// 遷移先を設定
		$this->tmpl->addVar("_widget", "goback_url", $this->gEnv->createCurrentPageUrl() . '&task=' . self::GOBACK_TASK);		// 戻りボタン用画面
	}
	/**
	 * 取得した配送方法をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function delivMethodLoop($index, $fetchedRow, $param)
	{
		$isCurrent = false;			// 選択中の配送方法
		if ($fetchedRow['do_id'] == $this->deliveryMethod) $isCurrent = true;		// 選択中の配送方法
		
		$checked = '';
		if ($isCurrent) $checked = 'checked';

		// 出力を初期化
		$price = 0;
		$content = '';
		
		// 配送料金を求める
		$iWidgetId	= $fetchedRow['do_iwidget_id'];	// インナーウィジェットID
		if (!empty($iWidgetId)){
			// パラメータをインナーウィジェットに設定し、計算結果を取得
			$optionParam->id = $fetchedRow['do_id'];		// ユニークなID(配送方法ID)
			// データの更新方法を設定
			if ($this->replaceNew){		// データを再取得するかどうか
				$optionParam->init = true;		// 初期データ取得
			} else {
				$optionParam->init = false;		// 画面からの入力データを使用
			}
			$optionParam->userId = $this->userId;					// ログインユーザID
			$optionParam->languageId = $this->langId;		// 言語ID
			$optionParam->cartId = $this->cartId;					// 商品のカート
			$optionParam->productTotal = $this->productTotal;				// 商品総額
			$optionParam->productCount = $this->productCount;		// 商品総数
			$optionParam->zipcode = $this->zipcode;		// 配送先の郵便番号
			$optionParam->stateId = $this->stateId;		// 配送先の都道府県

			if ($isCurrent){		// 選択中の配送方法のとき
				$optionParam->time = $this->demandTime;		// 希望時間帯
				$optionParam->date = $this->demandDt;			// 希望日
			}
			if ($this->calcIWidgetParam($iWidgetId, $fetchedRow['do_id'], $fetchedRow['do_param'], $optionParam, $resultObj)){
				$price = $resultObj->price;		// 配送料金
			}
			// インナーウィジェットの画面を取得
			$this->setIWidgetParam($iWidgetId, $fetchedRow['do_id'], $fetchedRow['do_param'], $optionParam);// パラメータをインナーウィジェットに設定
			$content = $this->getIWidgetContent($iWidgetId, $fetchedRow['do_id']);	// 通常画面を取得
		}
		// 送料が0円のときは「無料」表示
		$unit = '円';
		if (empty($price)){
			$price = '';
			$unit = '無料';
		}
		$row = array(
			'value'		=> $this->convertToDispString($fetchedRow['do_id']),			// ID
			'name'		=> $this->convertToDispString($fetchedRow['do_name']),		// 表示名
			'desc'		=> $fetchedRow['do_description'],							// 説明(HTMLが含まれる)
			'price'		=> $price,							// 配送料金
			'unit'		=> $unit,							// 単位
			'def_content'		=> $content,		// ユーザ選択用コンテンツ
			'checked'	=> $checked														// 選択中かどうか
		);
		$this->tmpl->addVars('deliv_method_list', $row);
		$this->tmpl->parseTemplate('deliv_method_list', 'a');
		return true;
	}
}
?>
