<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_dispBaseWidgetContainer.php 2048 2009-07-07 06:12:22Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_ec_dispBaseWidgetContainer extends BaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _postAssign($request, &$param)
	{
		// 表示画面を決定
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($task)) $task = 'other';
		
		// パンくずリストを作成
		switch ($task){
			case 'other':		// その他設定
				$linkList = ' &gt;&gt; 基本設定 &gt;&gt; その他';// パンくずリスト
				break;
		}
		// ####### 上段メニューの作成 #######
		$menuText = '<div id="configmenu-upper">' . M3_NL;
		$menuText .= '<ul>' . M3_NL;
		
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId();
				
		// カテゴリー管理
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId() . '&task=category';
		if ($task == 'category' ||
			$task == 'category_detail'){		
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>カテゴリー管理</span></a></li>' . M3_NL;
		
		// 商品管理
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId() . '&task=productlist';
		if ($task == 'product' || 		// 商品詳細
			$task == 'productlist' || 	// 商品一覧
			$task == 'productcsv' ||		// CSVデータ
			$task == 'imageupload'){		// 画像アップロード
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>商品管理</span></a></li>' . M3_NL;
		
		// 受注管理
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId() . '&task=order';
		if ($task == 'order' ||
			$task == 'order_detail'){
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>受注管理</span></a></li>' . M3_NL;
		
		// 在庫管理
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId() . '&task=stock';
		if ($task == 'stock' ||
			$task == 'stockplan' ||
			$task == 'stockplan_detail'){
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>在庫管理</span></a></li>' . M3_NL;
		
		// 会員管理
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId() . '&task=member';
		if ($task == 'member' ||
			$task == 'member_detail' ||
			$task == 'membercsv'	){			// 会員CSVデータ
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>会員管理</span></a></li>' . M3_NL;
		
		// 基本設定
		$current = '';
		$link = $this->gEnv->getDefaultAdminUrl() . '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_CONFIG_WIDGET . 
				'&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . $this->gEnv->getCurrentWidgetId() . '&task=keyword';
		if ($task == 'shopinfo' ||		// ショップ情報
			$task == 'mailinfo' ||		// メール送信情報
			$task == 'paymethod' ||		// 支払方法
			$task == 'paymethod_detail' ||		// 支払方法(詳細)
			$task == 'delivmethod' ||		// 配送方法
			$task == 'delivmethod_detail' ||		// 配送方法(詳細)
			$task == 'customer' ||		// 取引先
			$task == 'customer_detail' ||		// 取引先(詳細)
			$task == 'keyword' ||		// 文字列変換設定
			$task == 'keyword_detail' ||		// 文字列変換設定(詳細)
			$task == 'other'){		// その他設定
			$current = 'id="current"';
		}
		$menuText .= '<li ' . $current . '><a href="'. $link .'"><span>基本設定</span></a></li>' . M3_NL;
		
		// 上段メニュー終了
		$menuText .= '</ul>' . M3_NL;
		$menuText .= '</div>' . M3_NL;
		


		// 作成データの埋め込み
		$linkList = '<div id="configmenu-top"><label>' . 'Eコマース' . $linkList . '</div>';
		//$outputText .= '<table width="100%"><tr><td><div id="configmenu-top"><label>' . $linkList . '</label></div></td></tr><tr><td>' . M3_NL . $menuText . '</td></tr></table>' . M3_NL;
		$outputText .= '<table width="90%"><tr><td>' . $linkList . $menuText . '</td></tr></table>' . M3_NL;
		$this->tmpl->addVar("_widget", "menu_items", $outputText);
	}
}
?>
