<?php
/**
 * ヘルプリソースファイル
 * index.php
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: index.php 2047 2009-07-07 04:42:11Z fishbone $
 * @link       http://www.magic3.org
 */
// 直接アクセスの防止
defined('M3_SYSTEM') or die('Access error: Direct access denied.');

global $HELP;

// ########## カテゴリー管理 ##########
$HELP['category_list']['title'] = '商品カテゴリー一覧';
$HELP['category_list']['body'] = '商品カテゴリー一覧です。商品カテゴリーは商品のカテゴリー分けに使用します。';
$HELP['category_detail']['title'] = '商品カテゴリー詳細';
$HELP['category_detail']['body'] = '商品カテゴリーの情報を編集します。';
$HELP['category_new_btn']['title'] = '新規ボタン';
$HELP['category_new_btn']['body'] = '新規に商品カテゴリーを追加します。';
$HELP['category_edit_btn']['title'] = '編集ボタン';
$HELP['category_edit_btn']['body'] = '選択されている商品カテゴリーを編集します。<br>商品カテゴリーを選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['category_del_btn']['title'] = '削除ボタン';
$HELP['category_del_btn']['body'] = '選択されている商品カテゴリーを削除します。<br>商品カテゴリーを選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['category_ret_btn']['title'] = '戻るボタン';
$HELP['category_ret_btn']['body'] = '商品カテゴリー一覧へ戻ります。';
$HELP['category_check']['title'] = '選択用チェックボックス';
$HELP['category_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['category_id']['title'] = '商品カテゴリーID';
$HELP['category_id']['body'] = '商品カテゴリーのIDです。';
$HELP['category_name']['title'] = '商品カテゴリー名';
$HELP['category_name']['body'] = '商品カテゴリーの名前です。';
$HELP['category_index']['title'] = '表示順';
$HELP['category_index']['body'] = '商品カテゴリーを一覧表示する際の表示順です。';
$HELP['category_visible']['title'] = '公開';
$HELP['category_visible']['body'] = '商品カテゴリーを購入者に公開するかどうかを制御します。';

// ########## 商品管理 ##########
$HELP['product_list']['title'] = '商品一覧';
$HELP['product_list']['body'] = '商品一覧です。';
$HELP['product_detail']['title'] = '商品詳細';
$HELP['product_detail']['body'] = '商品の情報を編集します。';
$HELP['product_search']['title'] = '商品情報検索';
$HELP['product_search']['body'] = '商品情報を検索します。';
$HELP['product_detail_btn']['title'] = '商品詳細ボタン';
$HELP['product_detail_btn']['body'] = '商品の詳細情報を表示します。';
$HELP['product_new_btn']['title'] = '新規ボタン';
$HELP['product_new_btn']['body'] = '新規に商品を追加します。';
$HELP['product_edit_btn']['title'] = '編集ボタン';
$HELP['product_edit_btn']['body'] = '選択されている商品を編集します。<br>商品を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['product_del_btn']['title'] = '削除ボタン';
$HELP['product_del_btn']['body'] = '選択されている商品を削除します。<br>商品を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['product_ret_btn']['title'] = '戻るボタン';
$HELP['product_ret_btn']['body'] = '商品一覧へ戻ります。';
$HELP['product_search_btn']['title'] = '商品情報検索ボタン';
$HELP['product_search_btn']['body'] = '商品情報を検索します。';

// ########## 配送方法 ##########
$HELP['delivmethod_list']['title'] = '配送方法一覧';
$HELP['delivmethod_list']['body'] = '配送方法一覧です。配送方法は、購入者が商品の配送方法を選択するための項目です。';
$HELP['delivmethod_detail']['title'] = '配送方法詳細';
$HELP['delivmethod_detail']['body'] = '配送方法の情報を編集します。';
$HELP['delivmethod_new_btn']['title'] = '新規ボタン';
$HELP['delivmethod_new_btn']['body'] = '新規に配送方法を追加します。';
$HELP['delivmethod_edit_btn']['title'] = '編集ボタン';
$HELP['delivmethod_edit_btn']['body'] = '選択されている配送方法を編集します。<br>配送方法を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['delivmethod_del_btn']['title'] = '削除ボタン';
$HELP['delivmethod_del_btn']['body'] = '選択されている配送方法を削除します。<br>配送方法を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['delivmethod_ret_btn']['title'] = '戻るボタン';
$HELP['delivmethod_ret_btn']['body'] = '配送方法一覧へ戻ります。';
$HELP['delivmethod_preview_btn']['title'] = 'プレビューボタン';
$HELP['delivmethod_preview_btn']['body'] = '購入者が配送方法を選択するときの実際の画面です。';
$HELP['delivmethod_check']['title'] = '選択用チェックボックス';
$HELP['delivmethod_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['delivmethod_id']['title'] = '配送方法ID';
$HELP['delivmethod_id']['body'] = '配送方法のIDです。IDは新規登録時に任意のアルファベット文字で設定します。';
$HELP['delivmethod_name']['title'] = '配送方法名';
$HELP['delivmethod_name']['body'] = '配送方法の名前です。';
$HELP['delivmethod_index']['title'] = '表示順';
$HELP['delivmethod_index']['body'] = '配送方法を一覧表示する際の表示順です。';
$HELP['delivmethod_visible']['title'] = '公開';
$HELP['delivmethod_visible']['body'] = '配送方法を購入者に公開するかどうかを制御します。';
$HELP['delivmethod_desc']['title'] = '説明';
$HELP['delivmethod_desc']['body'] = '購入者が配送方法を選択するときの詳細説明です。';
$HELP['delivmethod_calc']['title'] = '料金計算方法';
$HELP['delivmethod_calc']['body'] = '配送料金を自動計算する場合はこの選択肢から選びます。';
$HELP['delivmethod_calc_detail']['title'] = '料金計算詳細';
$HELP['delivmethod_calc_detail']['body'] = '配送料金を自動計算する場合の詳細設定です。';

// ########## 支払方法 ##########
$HELP['paymethod_list']['title'] = '支払方法一覧';
$HELP['paymethod_list']['body'] = '支払方法一覧です。支払方法は、購入者が商品の支払方法を選択するための項目です。';
$HELP['paymethod_detail']['title'] = '支払方法詳細';
$HELP['paymethod_detail']['body'] = '支払方法の情報を編集します。';
$HELP['paymethod_new_btn']['title'] = '新規ボタン';
$HELP['paymethod_new_btn']['body'] = '新規に支払方法を追加します。';
$HELP['paymethod_edit_btn']['title'] = '編集ボタン';
$HELP['paymethod_edit_btn']['body'] = '選択されている支払方法を編集します。<br>支払方法を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['paymethod_del_btn']['title'] = '削除ボタン';
$HELP['paymethod_del_btn']['body'] = '選択されている支払方法を削除します。<br>支払方法を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['paymethod_ret_btn']['title'] = '戻るボタン';
$HELP['paymethod_ret_btn']['body'] = '支払方法一覧へ戻ります。';
$HELP['paymethod_preview_btn']['title'] = 'プレビューボタン';
$HELP['paymethod_preview_btn']['body'] = '購入者が支払方法を選択するときの実際の画面です。';
$HELP['paymethod_check']['title'] = '選択用チェックボックス';
$HELP['paymethod_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['paymethod_id']['title'] = '支払方法ID';
$HELP['paymethod_id']['body'] = '支払方法のIDです。IDは新規登録時に任意のアルファベット文字で設定します。';
$HELP['paymethod_name']['title'] = '支払方法名';
$HELP['paymethod_name']['body'] = '支払方法の名前です。';
$HELP['paymethod_index']['title'] = '表示順';
$HELP['paymethod_index']['body'] = '支払方法を一覧表示する際の表示順です。';
$HELP['paymethod_visible']['title'] = '公開';
$HELP['paymethod_visible']['body'] = '支払方法を購入者に公開するかどうかを制御します。';
$HELP['paymethod_desc']['title'] = '説明';
$HELP['paymethod_desc']['body'] = '購入者が支払方法を選択するときの詳細説明です。';
$HELP['paymethod_calc']['title'] = '料金計算方法';
$HELP['paymethod_calc']['body'] = '支払手数料を自動計算する場合はこの選択肢から選びます。';
$HELP['paymethod_calc_detail']['title'] = '料金計算詳細';
$HELP['paymethod_calc_detail']['body'] = '支払手数料を自動計算する場合の詳細設定です。';

// ########## 置換文字列 ##########
$HELP['keyword_list']['title'] = '置換文字列一覧';
$HELP['keyword_list']['body'] = '置換文字列一覧です。置換文字列は、コンテンツテキストに埋め込み、コンテンツ表示時に自動変換される文字列です。';
$HELP['keyword_detail']['title'] = '置換文字列詳細';
$HELP['keyword_detail']['body'] = '置換文字列の情報を編集します。';
$HELP['keyword_new_btn']['title'] = '新規ボタン';
$HELP['keyword_new_btn']['body'] = '新規に置換文字列を追加します。';
$HELP['keyword_edit_btn']['title'] = '編集ボタン';
$HELP['keyword_edit_btn']['body'] = '選択されている置換文字列を編集します。<br>置換文字列を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['keyword_del_btn']['title'] = '削除ボタン';
$HELP['keyword_del_btn']['body'] = '選択されている置換文字列を削除します。<br>置換文字列を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['keyword_ret_btn']['title'] = '戻るボタン';
$HELP['keyword_ret_btn']['body'] = '置換文字列一覧へ戻ります。';
$HELP['keyword_check']['title'] = '選択用チェックボックス';
$HELP['keyword_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['keyword_key']['title'] = '置換キー文字列';
$HELP['keyword_key']['body'] = 'コンテンツテキストに埋め込むキー文字列です。コンテンツ表示時に、この文字列が「置換内容」に変換されます。';
$HELP['keyword_name']['title'] = '置換文字列名';
$HELP['keyword_name']['body'] = '置換文字列の管理上の名前です。';
$HELP['keyword_value']['title'] = '置換内容';
$HELP['keyword_value']['body'] = 'コンテンツ表示時に、コンテンツ上の置換キーから変換される文字列です。';

// ########## 会員管理 ##########
$HELP['member_list']['title'] = 'Eコマース会員一覧';
$HELP['member_list']['body'] = 'Eコマース会員一覧です。右のメニューから「正会員」「仮会員」の種別を選択します。自分で会員登録を行った会員は、一旦仮会員で登録された後、最初のログインで自動的に正会員に変更されます。';
$HELP['member_detail']['title'] = 'Eコマース会員詳細';
$HELP['member_detail']['body'] = 'Eコマース会員の情報を設定します。';
$HELP['member_csv']['title'] = 'Eコマース会員CSVデータ';
$HELP['member_csv']['body'] = 'Eコマースの正会員の情報をCSV形式でアップロードやダウンロードを行います。';
$HELP['member_new_btn']['title'] = '新規ボタン';
$HELP['member_new_btn']['body'] = '新規にEコマース会員を追加します。';
$HELP['member_edit_btn']['title'] = '編集ボタン';
$HELP['member_edit_btn']['body'] = '選択されているEコマース会員を編集します。<br>会員を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['member_del_btn']['title'] = '削除ボタン';
$HELP['member_del_btn']['body'] = '選択されているEコマース会員を削除します。<br>会員を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['member_ret_btn']['title'] = '戻るボタン';
$HELP['member_ret_btn']['body'] = 'Eコマース会員一覧へ戻ります。';
$HELP['member_csv_download_btn']['title'] = '会員CSVデータダウンロード';
$HELP['member_csv_download_btn']['body'] = 'Eコマース正会員の情報をCSV形式のファイルで一括ダウンロードします。';
$HELP['member_csv_upload_btn']['title'] = '会員CSVデータアップロード';
$HELP['member_csv_upload_btn']['body'] = 'Eコマース正会員の情報をCSV形式のファイルで一括アップロードします。会員Noがすでに存在するデータは、アップロードするデータで更新されます。アップロードするファイルを左の参照ボタンから選択してください。';
$HELP['member_check']['title'] = '選択用チェックボックス';
$HELP['member_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['member_view_no']['title'] = 'No';
$HELP['member_view_no']['body'] = '項目番号';
$HELP['member_no']['title'] = '会員No';
$HELP['member_no']['body'] = '自由設定可能な会員Noです。';
$HELP['member_name']['title'] = '会員名';
$HELP['member_name']['body'] = '会員名を設定します。';
$HELP['member_name_kana']['title'] = '会員名カナ';
$HELP['member_name_kana']['body'] = '会員名の読みカナを設定します。';
$HELP['member_email']['title'] = 'Eメール';
$HELP['member_email']['body'] = '会員のEメールアドレスを設定します。';
$HELP['member_gender']['title'] = '会員性別';
$HELP['member_gender']['body'] = '会員の性別を設定します。';
$HELP['member_state']['title'] = '都道府県';
$HELP['member_state']['body'] = '会員の住所の都道府県です。';
$HELP['member_zip']['title'] = '郵便番号';
$HELP['member_zip']['body'] = '会員の郵便番号です。';
$HELP['member_add1']['title'] = '住所1';
$HELP['member_add1']['body'] = '会員の住所の市区町村を設定します。';
$HELP['member_add2']['title'] = '住所2';
$HELP['member_add2']['body'] = '会員の住所の建物名以降を設定します。';
$HELP['member_phone']['title'] = '電話番号';
$HELP['member_phone']['body'] = '会員の電話番号を設定します。';
$HELP['member_fax']['title'] = 'FAX';
$HELP['member_fax']['body'] = '会員のFAX番号を設定します。';
$HELP['member_mobile']['title'] = '携帯電話';
$HELP['member_mobile']['body'] = '会員の携帯電話番号を設定します。';
$HELP['member_birth']['title'] = '生年月日';
$HELP['member_birth']['body'] = '会員の生年月日を設定します。';
$HELP['member_pwd']['title'] = 'パスワード';
$HELP['member_pwd']['body'] = 'パスワードを再作成して、会員にメールで送信します。会員はログインを行って、任意のパスワードを設定します。';

// ########## 受注管理 ##########
$HELP['order_list']['title'] = '受注一覧';
$HELP['order_list']['body'] = '受注情報の一覧を表示します。';
$HELP['order_detail']['title'] = '受注詳細';
$HELP['order_detail']['body'] = '受注情報の詳細です。';
$HELP['order_search']['title'] = '受注情報検索';
$HELP['order_search']['body'] = '受注情報を検索します。';
$HELP['order_deliv']['title'] = '配送先';
$HELP['order_deliv']['body'] = '商品の配送先を示します。';
$HELP['order_bill']['title'] = '請求先';
$HELP['order_bill']['body'] = '支払の請求先を示します。';
$HELP['order_content']['title'] = '受注内容';
$HELP['order_content']['body'] = '受注内容を示します。';

$HELP['order_new_btn']['title'] = '新規ボタン';
$HELP['order_new_btn']['body'] = '新規に受注情報を追加します。';
$HELP['order_edit_btn']['title'] = '編集ボタン';
$HELP['order_edit_btn']['body'] = '選択されている受注情報を編集します。<br>受注情報を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['order_del_btn']['title'] = '削除ボタン';
$HELP['order_del_btn']['body'] = '選択されている受注情報を削除します。<br>受注情報を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['order_ret_btn']['title'] = '戻るボタン';
$HELP['order_ret_btn']['body'] = '受注一覧へ戻ります。';
$HELP['order_check']['title'] = '選択用チェックボックス';
$HELP['order_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['order_no']['title'] = '受注No';
$HELP['order_no']['body'] = '受注用の番号です。受注時に自動的に作成されます。';
$HELP['order_name']['title'] = '顧客名';
$HELP['order_name']['body'] = '発注した顧客の名前です。';
$HELP['order_name_kana']['title'] = '顧客名カナ';
$HELP['order_name_kana']['body'] = '顧客名の読みカナを設定します。';
$HELP['order_email']['title'] = 'Eメール';
$HELP['order_email']['body'] = '顧客のEメールアドレスを設定します。';
$HELP['order_zip']['title'] = '郵便番号';
$HELP['order_zip']['body'] = '顧客の郵便番号です。';
$HELP['order_state']['title'] = '都道府県';
$HELP['order_state']['body'] = '顧客の住所の都道府県です。';
$HELP['order_add1']['title'] = '住所1';
$HELP['order_add1']['body'] = '顧客の住所の市区町村を設定します。';
$HELP['order_add2']['title'] = '住所2';
$HELP['order_add2']['body'] = '顧客の住所の建物名以降を設定します。';
$HELP['order_phone']['title'] = '電話番号';
$HELP['order_phone']['body'] = '顧客の電話番号を設定します。';
$HELP['order_fax']['title'] = 'FAX';
$HELP['order_fax']['body'] = '顧客のFAX番号を設定します。';
$HELP['order_deliv_name']['title'] = '配送先名';
$HELP['order_deliv_name']['body'] = '配送先の名前です。';
$HELP['order_deliv_name_kana']['title'] = '配送先名カナ';
$HELP['order_deliv_name_kana']['body'] = '配送先の読みカナを設定します。';
$HELP['order_deliv_zip']['title'] = '郵便番号';
$HELP['order_deliv_zip']['body'] = '配送先の郵便番号です。';
$HELP['order_deliv_state']['title'] = '都道府県';
$HELP['order_deliv_state']['body'] = '配送先の住所の都道府県です。';
$HELP['order_deliv_add1']['title'] = '住所1';
$HELP['order_deliv_add1']['body'] = '配送先の住所の市区町村を設定します。';
$HELP['order_deliv_add2']['title'] = '住所2';
$HELP['order_deliv_add2']['body'] = '配送先の住所の建物名以降を設定します。';
$HELP['order_deliv_phone']['title'] = '電話番号';
$HELP['order_deliv_phone']['body'] = '配送先の電話番号を設定します。';
$HELP['order_deliv_fax']['title'] = 'FAX';
$HELP['order_deliv_fax']['body'] = '配送先のFAX番号を設定します。';
$HELP['order_bill_name']['title'] = '請求先名';
$HELP['order_bill_name']['body'] = '請求先の名前です。';
$HELP['order_bill_name_kana']['title'] = '請求先名カナ';
$HELP['order_bill_name_kana']['body'] = '請求先の読みカナを設定します。';
$HELP['order_bill_zip']['title'] = '郵便番号';
$HELP['order_bill_zip']['body'] = '請求先の郵便番号です。';
$HELP['order_bill_state']['title'] = '都道府県';
$HELP['order_bill_state']['body'] = '請求先の住所の都道府県です。';
$HELP['order_bill_add1']['title'] = '住所1';
$HELP['order_bill_add1']['body'] = '請求先の住所の市区町村を設定します。';
$HELP['order_bill_add2']['title'] = '住所2';
$HELP['order_bill_add2']['body'] = '請求先の住所の建物名以降を設定します。';
$HELP['order_bill_phone']['title'] = '電話番号';
$HELP['order_bill_phone']['body'] = '請求先の電話番号を設定します。';
$HELP['order_bill_fax']['title'] = 'FAX';
$HELP['order_bill_fax']['body'] = '請求先のFAX番号を設定します。';

$HELP['order_paymethod']['title'] = '支払方法';
$HELP['order_paymethod']['body'] = '顧客が選択した支払方法を示します。';
$HELP['order_delivmethod']['title'] = '配送方法';
$HELP['order_delivmethod']['body'] = '顧客が選択した配送方法を示します。';

$HELP['order_total']['title'] = '購入額';
$HELP['order_total']['body'] = '手数料、送料を含む受注総額です。';
$HELP['order_status']['title'] = 'ステータス';
$HELP['order_status']['body'] = '受注情報の状態を示します。';
$HELP['order_regist_dt']['title'] = '受注日時';
$HELP['order_regist_dt']['body'] = '受注した日時を示します。';
$HELP['order_deliv_dt']['title'] = '配送日時';
$HELP['order_deliv_dt']['body'] = '配送予定の日時を示します。';
$HELP['order_update_dt']['title'] = '更新日時';
$HELP['order_update_dt']['body'] = '受注情報の更新日時を示します。';
$HELP['order_update_user']['title'] = '更新者';
$HELP['order_update_user']['body'] = '受注情報の更新者を示します。';

// ########## 在庫管理 ##########
$HELP['stock_list']['title'] = '商品在庫一覧';
$HELP['stock_list']['body'] = '商品別の在庫状況を一覧を表示します。';
$HELP['stockplan_list']['title'] = '在庫予定一覧';
$HELP['stockplan_list']['body'] = '在庫予定情報の一覧を表示します。';
$HELP['stockplan_detail']['title'] = '在庫予定詳細';
$HELP['stockplan_detail']['body'] = '在庫予定情報の詳細です。';

$HELP['stock_day_today']['title'] = '現在在庫数';
$HELP['stock_day_today']['body'] = '今日の開始時点での在庫数を示します。棚卸位置からの集計結果で示します。棚卸が見つからない場合は「-」が表示されます。';
$HELP['stock_day_7']['title'] = '7日後在庫数';
$HELP['stock_day_7']['body'] = '7日後の開始時点での在庫数を示します。棚卸位置からの集計結果で示します。棚卸が見つからない場合は「-」が表示されます。';
$HELP['stock_day_30']['title'] = '30日後在庫数';
$HELP['stock_day_30']['body'] = '30日後の開始時点での在庫数を示します。棚卸位置からの集計結果で示します。棚卸が見つからない場合は「-」が表示されます。';

$HELP['stockplan_new_btn']['title'] = '新規ボタン';
$HELP['stockplan_new_btn']['body'] = '新規に在庫予定情報を追加します。';
$HELP['stockplan_edit_btn']['title'] = '編集ボタン';
$HELP['stockplan_edit_btn']['body'] = '選択されている在庫予定情報を編集します。<br>在庫予定情報を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['stockplan_del_btn']['title'] = '削除ボタン';
$HELP['stockplan_del_btn']['body'] = '選択されている在庫予定情報を削除します。<br>在庫予定情報を選択するには、一覧の左端のチェックボックスにチェックを入れます。';
$HELP['stockplan_ret_btn']['title'] = '戻るボタン';
$HELP['stockplan_ret_btn']['body'] = '在庫予定一覧へ戻ります。';
$HELP['stockplan_check']['title'] = '選択用チェックボックス';
$HELP['stockplan_check']['body'] = '編集や削除を行う項目を選択します。';
$HELP['stockplan_total']['title'] = '在庫数';
$HELP['stockplan_total']['body'] = '棚卸位置からの集計結果を示します。棚卸が見つからない場合は「-」が表示されます。';

// ########## その他 ##########
$HELP['other_default_currency']['title'] = 'デフォルト通貨';
$HELP['other_default_currency']['body'] = 'Eコマースで使用する通貨です。';
$HELP['other_use_email']['title'] = 'メール送信機能使用';
$HELP['other_use_email']['body'] = 'Eコマース機能でメール送信機能を使用するかどうかを設定します。';
$HELP['other_auto_email']['title'] = '自動送信メールの送信元メールアドレス';
$HELP['other_auto_email']['body'] = '会員に自動的にメールが送られる場合の送信元のメールアドレスです。';
$HELP['other_product_list_count']['title'] = '商品一覧の表示項目数';
$HELP['other_product_list_count']['body'] = '商品を一覧表示する場合の商品の表示項目数です。';
?>
