<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: update_content_boxDb.php 1432 2009-01-12 10:26:59Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class update_content_boxDb extends BaseDb
{
	/**
	 * 閲覧数が多い順にコンテンツリストを取得
	 *
	 * @param string   $langId		言語
	 * @param string   $typeId		コンテンツタイプ
	 * @param bool	   $all			すべてのデータを取得するか、ユーザ制限のないデータを取得するかを指定
	 * @param function $callback	コールバック関数
	 * @return						なし
	 */
	function getContentList($langId, $typeId, $all, $callback)
	{
		$params = array();
		$queryStr  = 'SELECT * FROM content ';
		$queryStr .=   'WHERE cn_deleted = false ';
		$queryStr .=     'AND cn_visible = true ';
		$queryStr .=     'AND cn_type = ? ';$params[] = $typeId;
		$queryStr .=     'AND cn_language_id = ? ';$params[] = $langId;
		if (!$all) $queryStr .=    'AND cn_user_limited = false ';		// ユーザ制限のないデータ
		$queryStr .=   'ORDER BY cn_create_dt DESC';
		$this->selectLoop($queryStr, $params, $callback);
	}
}
?>
