<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: _installCompleteWidgetContainer.php 2363 2009-09-26 14:45:44Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class _installCompleteWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
//		$this->db = new _installDB();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'complete.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gPageManager;

		$dbStatus = $request->trimValueOf('dbstatus');		// DBの状態
		$act = $request->trimValueOf('act');
		if ($act == 'delinstaller'){		// インストーラを削除の場合
			// ファイルを退避する
			$this->gInstance->getFileManager()->backupInstaller();
			
			// 管理者画面へ遷移
			$gPageManager->redirectToDirectory();
		}
		// アクセス用URLを表示
		$this->tmpl->addVar('_widget', 'url',			$this->gConfig->getSystemRootUrl());
		$this->tmpl->addVar('_widget', 'url_admin',	$this->gConfig->getSystemRootUrl() . '/' . M3_SYSTEM_ADMIN_DIR_NAME);
		$this->tmpl->addVar('_widget', 'user',		'admin');		// 初期管理ユーザ
		$this->tmpl->addVar('_widget', 'password',	'admin');		// 初期管理ユーザのパスワード
		$this->tmpl->addVar("_widget", "db_status", $dbStatus);
	}
}
?>
