<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainSmenudefWidgetContainer.php 2477 2009-10-28 04:14:21Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainSmenudefWidgetContainer extends admin_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $serialNo;		// 選択中の項目のシリアル番号
	private $serialArray = array();			// 表示中のシリアル番号
	private $menuId;		// 現在選択中のメニューID
	private $menuItemType;	// メニュー項目タイプ
	private $currentPageSubId;	// 現在のページサブID
	private $contentId;			// 現在のコンテンツID
	private $isExistsMenuItem;		// メニュー項目が存在するかどうか
	private $isExistsPreviewMenuItem;		// プレビューメニュー項目が存在するかどうか
	private $itemTypeArray;		// メニュー項目の種類
	const MAIN_MENU_ID = 'main_menu';			// メインメニューID
	const CONTENT_WIDGET_ID = 'default_content';			// コンテンツ編集ウィジェット
	const WIDGET_TYPE_MENU = 'menu';		// メニュー型のウィジェット(キャッシュクリア用)
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new admin_mainDb();
		
		// メニュー項目タイプ
		$this->itemTypeArray = array(	array(	'name' => 'リンク',		'value' => '0'),
										array(	'name' => 'フォルダ',	'value' => '1'),
										array(	'name' => 'テキスト',	'value' => '2'),
										array(	'name' => 'セパレータ',	'value' => '3'));
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'smenudef_detail'){		// 詳細画面
			return 'smenudef_detail.tmpl.html';
		} else {			// 一覧画面
			return 'smenudef.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'smenudef_detail'){	// 詳細画面
			return $this->createDetail($request);
		} else {			// 一覧画面
			return $this->createList($request);
		}
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		$userId		= $this->gEnv->getCurrentUserId();
		$langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		
		$fixedMode = $request->trimValueOf('fixed_mode');		// メニュー定義IDが固定かどうか
		if ($fixedMode == ''){		// 値が設定されていないときは設定
			if ($request->trimValueOf('menuid') == ''){
				$fixedMode = '0';
			} else {
				$fixedMode = '1';		// 固定
			}
		}
		$this->menuId = $request->trimValueOf('menuid');		// 現在選択中のメニュータイプ
		if ($this->menuId == '') $this->menuId = self::MAIN_MENU_ID;		// デフォルトは通常のメニュー
		$act = $request->trimValueOf('act');
		
		if ($act == 'updatemenu'){		// メニュー項目順の更新のとき
			$menuitems = $request->trimValueOf('menuitems');
			if (!empty($menuitems)){
				$menuItemNoArray = explode(',', $menuitems);
			
				// メニューの並び順を変更
				$this->db->orderMenuItems($this->menuId, 0/*1階層目*/, true/*表示項目のみ*/, $menuItemNoArray);
			}
			$this->gCache->clearCacheByWidgetType(self::WIDGET_TYPE_MENU);		// キャッシュをクリア
			$this->gPage->updateParentWindow();// 親ウィンドウを更新
		} else if ($act == 'delete'){		// メニュー項目の削除
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					$delItems[] = $listedItem[$i];
				}
			}
			if (count($delItems) > 0){
				$ret = $this->db->delMenuItems(implode($delItems, ','));
				if ($ret){		// データ削除成功のとき
					$this->setGuidanceMsg('データを削除しました');
				} else {
					$this->setAppErrorMsg('データ削除に失敗しました');
				}
			}
			$this->gCache->clearCacheByWidgetType(self::WIDGET_TYPE_MENU);		// キャッシュをクリア
			$this->gPage->updateParentWindow();// 親ウィンドウを更新
		}
		// メニューID選択メニュー作成
		$this->db->getMenuIdList(array($this, 'menuIdListLoop'));
		
		// メニュー項目一覧を作成
		$this->createMenuList($this->menuId);
		
		// メニュー項目が存在しないときはメニューのプレビューを表示しない
		if (!$this->isExistsMenuItem) $this->tmpl->setAttribute('itemlist', 'visibility', 'hidden');		// メニュー項目一覧
		if (!$this->isExistsPreviewMenuItem) $this->tmpl->setAttribute('menuitemlist', 'visibility', 'hidden');// メニュープレビュー
		if ($fixedMode == '1') $this->tmpl->addVar("_widget", "sel_menu_id_disabled", 'disabled');			// メニューIDの選択可否
		
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
		$this->tmpl->addVar('_widget', 'content_widget_id', self::CONTENT_WIDGET_ID);// コンテンツ表示ウィジェット
		$this->tmpl->addVar('_widget', 'admin_url', $this->getUrl($this->gEnv->getDefaultAdminUrl()));// 管理者URL
		$this->tmpl->addVar("_widget", "fixed_mode", $fixedMode);		// メニュー定義IDが固定かどうか
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		$userId		= $this->gEnv->getCurrentUserId();
		$langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		
		$fixedMode = $request->trimValueOf('fixed_mode');		// メニュー定義IDが固定かどうか
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		$value = $request->trimValueOf('item_sel_menuid');
		if ($value != '') $this->serialNo = $value;			// メニュー項目が選択されている場合はシリアル番号を更新
		$this->menuId = $request->trimValueOf('menuid');		// 現在選択中のメニューID
		
		$name = $request->trimValueOf('item_name');
		$desc = $request->trimValueOf('item_desc');
		$this->menuItemType = $request->trimValueOf('item_type');
		if ($this->menuItemType == '') $this->menuItemType = '0';		// デフォルトの項目タイプは通常リンク
		$linkType = $request->trimValueOf('item_link_type');
		$visible = ($request->trimValueOf('item_visible') == 'on') ? 1 : 0;		// メニュー項目表示制御チェックボックス
		$this->currentPageSubId = $request->trimValueOf('item_sub_id');			// ページサブID
		$this->contentId = $request->trimValueOf('item_content_id');			// コンテンツID
		$url = $request->trimValueOf('item_url');		// 入力URL		
		$url = str_replace($this->gEnv->getRootUrl(), M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $url);// マクロ変換
		
		$reloadData = false;		// データの再読み込み
		if ($act == 'add'){// 新規追加
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkInput($this->menuId, 'メニューID');
			$this->checkInput($url, 'リンク先');

			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->addMenuItem($this->menuId, 0, $name, $desc, 0/*項目順は自動設定*/, $this->menuItemType, $linkType, $url, $visible, $newId);
				if ($ret){
					$this->setGuidanceMsg('データを追加しました');
					
					$this->serialNo = $newId;		// メニュー項目IDを更新
					$reloadData = true;		// データの再読み込み
				} else {
					$this->setAppErrorMsg('データ追加に失敗しました');
				}
				$this->gCache->clearCacheByWidgetType(self::WIDGET_TYPE_MENU);		// キャッシュをクリア
			}
		} else if ($act == 'update'){		// 項目更新の場合
			// 入力チェック
			$this->checkInput($name, '名前');
			$this->checkInput($url, 'リンク先');

			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateMenuItem($this->serialNo, $name, $desc, $this->menuItemType, $linkType, $url, $visible);
				if ($ret){
					$this->setGuidanceMsg('データを更新しました');
					
					$reloadData = true;		// データの再読み込み
				} else {
					$this->setAppErrorMsg('データ更新に失敗しました');
				}
				$this->gCache->clearCacheByWidgetType(self::WIDGET_TYPE_MENU);		// キャッシュをクリア
			}
		} else if ($act == 'delete'){		// 項目削除の場合
			$ret = $this->db->delMenuItems($this->serialNo);
			if ($ret){		// データ削除成功のとき
				$this->setGuidanceMsg('データを削除しました');
			} else {
				$this->setAppErrorMsg('データ削除に失敗しました');
			}
			$this->gCache->clearCacheByWidgetType(self::WIDGET_TYPE_MENU);		// キャッシュをクリア
		} else if ($act == 'select'){	// ページサブIDを変更
			if ($this->currentPageSubId == '_root'){
				$url = M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . '/';
			} else if ($this->currentPageSubId == '_other'){		// 任意設定以外のとき
				$url = '';
			} else {
				$url = $this->gEnv->getDefaultUrl() . '?' . M3_REQUEST_PARAM_PAGE_SUB_ID . '=' . $this->currentPageSubId;
				if (!empty($this->contentId)) $url .= '&' . M3_REQUEST_PARAM_CONTENT_ID . '=' . $this->contentId;
			}
		} else {
			$reloadData = true;		// データの再読み込み
		}
		if ($reloadData){		// データの再読み込み
			if (empty($this->serialNo)){		// 新規項目追加のとき
				$name = '';		// 名前
				$linkType = 0;	// リンクタイプ
				$visible = 1;
				$url = '';	// リンク先
			} else {
				$ret = $this->db->getMenuItem($this->serialNo, $row);
				if ($ret){
					// 取得値を設定
					$this->serialNo = $row['md_id'];			// ID
					$name = $row['md_name'];		// 名前
					$desc = $row['md_description'];		// 説明
					$this->menuItemType = $row['md_type'];		// 項目タイプ
					$linkType = $row['md_link_type'];	// リンクタイプ
					$visible = $row['md_visible'];
					$url = $row['md_link_url'];	// リンク先
					
					// リンク先を解析
					if ($url == M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END . '/'){		// トップのとき
						$this->currentPageSubId = '_root';
					} else {
						// システム以下へのリンクかチェック
						$testUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $url);		// マクロ展開
						$ret = $this->gEnv->parseUrl($testUrl, $pageId, $pageSubId, $paramArray);
						if (!$ret) $this->currentPageSubId = '_other';		// 他サイトへのリンクのとき
					}
				}
			}
		}
		
		// リンク先を実URLに変換
		$url = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $url);		// マクロ展開

		$contentType = '';		// コンテンツタイプ(ページ属性)
		if ($this->currentPageSubId == '_root'){
			$this->tmpl->setAttribute('input_no_url', 'visibility', 'visible');// URL非表示データ
			$this->tmpl->addVar('_widget', 'root_selected', 'selected');		// ページサブID選択
		} else if ($this->currentPageSubId == '_other'){
			$this->tmpl->setAttribute('input_url', 'visibility', 'visible');// URL入力エリア表示
			$this->tmpl->addVar('_widget', 'other_selected', 'selected');		// ページサブID選択
		} else {		// ルート、任意設定以外のとき
			$this->tmpl->setAttribute('input_no_url', 'visibility', 'visible');// URL非表示データ

			// URLを解析
			$ret = $this->gEnv->parseUrl($url, $pageId, $pageSubId, $paramArray);
			if ($ret){
				$this->currentPageSubId = $pageSubId;

				// ページ情報を取得
				$ret = $this->db->getPageInfo($this->gEnv->getDefaultPageId(), $this->currentPageSubId, $row);
				if ($ret){
					$contentType = $row['pn_content_type'];
				}

				// 表示データタイプごとの処理
				$url = $this->gEnv->getDefaultUrl();
				switch ($contentType){
					case M3_VIEW_TYPE_CONTENT:				// 汎用コンテンツ
						$this->contentId = $paramArray[M3_REQUEST_PARAM_CONTENT_ID];
						$url .= '?' . M3_REQUEST_PARAM_CONTENT_ID . '=' . $this->contentId;
						break;
					case M3_VIEW_TYPE_PRODUCT:				// 製品
					case M3_VIEW_TYPE_BBS:					// BBS
					case M3_VIEW_TYPE_BLOG:				// ブログ
					case M3_VIEW_TYPE_WIKI:				// wiki
					default:
						$url .= '?' . M3_REQUEST_PARAM_PAGE_SUB_ID . '=' . $this->currentPageSubId;
						break;
				}
			}
		}
		
		// 表示データタイプごとの表示処理
		switch ($contentType){
			case M3_VIEW_TYPE_CONTENT:				// 汎用コンテンツ
				$this->tmpl->setAttribute('sel_content', 'visibility', 'visible');// コンテンツ選択メニュー表示
				$this->db->getVisibleAllContents(array($this, 'contentListLoop'), $langId);
				break;
			case M3_VIEW_TYPE_PRODUCT:				// 製品
				break;
			case M3_VIEW_TYPE_BBS:					// BBS
				break;
			case M3_VIEW_TYPE_BLOG:				// ブログ
				break;
			case M3_VIEW_TYPE_WIKI:				// wiki
				break;
			default:
				break;
		}
		
		// リンク先設定用メニュー
		$this->db->getPageIdList(array($this, 'pageSubIdLoop'), 1);// ウィジェットサブIDメニュー作成

		// メニュー項目タイプメニュー
		$this->createItemTypeMenu();
		
		// メニューID選択メニュー作成
		$this->db->getAllMenuItems($this->menuId, array($this, 'menuIdLoop'));
		
		// ### 入力値を再設定 ###
		$this->tmpl->addVar("_widget", "sel_item_name", $name);		// 名前
		$this->tmpl->addVar("_widget", "desc", $desc);		// 説明
		$this->tmpl->addVar("_widget", "sel_url", $url);		// 表示するURL
		$this->tmpl->addVar("input_url", "sel_url", $url);		// 表示するURL
		$this->tmpl->addVar("input_no_url", "sel_url", $url);		// 表示するURL
		$attrStr = '';
		if (!empty($contentType)) $attrStr = 'ページ属性：' . $contentType;
		$this->tmpl->addVar("_widget", "attr", $attrStr);		// ページ属性
		
		// リンクタイプ
		switch ($linkType){
			case 0:			// 同ウィンドウで開くリンク
				$this->tmpl->addVar("_widget", "link_type_0", 'selected');
				break;
			case 1:			// 別ウィンドウで開くリンク
				$this->tmpl->addVar("_widget", "link_type_1", 'selected');
				break;
		}
		// 項目表示、項目利用可否チェックボックス
		$visibleStr = '';
		if ($visible) $visibleStr = 'checked';
		$this->tmpl->addVar("_widget", "sel_item_visible", $visibleStr);

		// 選択中のシリアル番号、IDを設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		$this->tmpl->addVar("_widget", "menu_id", $this->menuId);		// メニューID
		$this->tmpl->addVar("_widget", "fixed_mode", $fixedMode);		// メニュー定義IDが固定かどうか
		
		// ボタンの表示制御
		if (empty($this->serialNo)){		// 新規追加項目を選択しているとき
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 「新規追加」ボタン
		} else {
			$this->tmpl->setAttribute('del_button', 'visibility', 'visible');// 「削除」ボタン
		}
	}
	/**
	 * メニュー一覧作成
	 *
	 * @param string	$menuId		メニューID
	 * @return string		ツリーメニュータグ
	 */
	function createMenuList($menuId)
	{
		if (!$this->db->getChildMenuItems($menuId, 0, $rows)) return;
		
		$itemCount = count($rows);
		for ($i = 0; $i < $itemCount; $i++){
			$row = $rows[$i];
			
			// ##### 一覧に追加 #####
			$visible = '';
			if ($row['md_visible']){
				$visible = 'checked';
			}
			// リンクタイプ
			$linkString = '';
			switch ($row['md_link_type']){
				case 0:			// 同ウィンドウで開くリンク
					$linkString = '同';
					break;
				case 1:			// 別ウィンドウで開くリンク
					$linkString = '別';
					break;
			}
			// 項目選択のラジオボタンの状態
			$serial = $this->convertToDispString($row['md_id']);
			$selected = '';
			if ($serial == $this->serialNo){
				$selected = 'checked';
			}
	
			// リンクURLからコンテンツIDを取得
			$linkUrl = $row['md_link_url'];
			// システム配下のパスであるかチェック
			$contentId = '';
			$pos = strpos($linkUrl, M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END);
			if ($pos === false){		// 見つからない場合
			} else {
				// コンテンツID取得
				list($path, $param) = explode("?", $linkUrl);
				$params = explode("&", $param);
				$count = count($params);
				for ($j = 0; $j < $count; $j++){
					list($key, $value) = explode('=', $params[$j]);
					if ($key == M3_REQUEST_PARAM_CONTENT_ID){
						$contentId = $value;
						break;
					}
				}
			}
			// リンク先を実URLに変換
			$linkUrlStr = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, '...', $linkUrl);		// 表示テキスト
			$linkUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $linkUrl);		// マクロ展開
			$linkUrlStr = '<a href="#" onclick="showUrl(\'' . $linkUrl . '\');">' . $this->convertToDispString($linkUrlStr) . '</a>';

			// コンテンツの編集ボタンの有効状態
			$enableContentLink = '';
			if (empty($contentId)) $enableContentLink = 'disabled';
	
			$itemRow = array(
				'index' => $i,													// 行番号
				'serial' => $serial,			// シリアル番号
				'id' => $this->convertToDispString($row['md_id']),			// ID
				'name' => $this->convertToDispString($row['md_name']),		// 名前
				'item_type' => $iconTag,											// メニュー項目タイプアイコン
				'link_type' => $linkString,											// リンクタイプ
				'link_str' => $linkUrlStr,											// リンクURL
				'content_id' => $contentId,											// コンテンツID
				'enable_content' => $enableContentLink,											// コンテンツの編集ボタンの有効状態
				'visible' => $visible,											// メニュー項目表示制御
				'selected' => $selected												// 項目選択用ラジオボタン
			);
			$this->tmpl->addVars('itemlist', $itemRow);
			$this->tmpl->parseTemplate('itemlist', 'a');
	
			// メニューのプレビュー
			if ($row['md_visible']){		// 表示項目のみ追加
				$this->tmpl->addVars('menuitemlist', $itemRow);
				$this->tmpl->parseTemplate('menuitemlist', 'a');
				$this->isExistsPreviewMenuItem = true;		// メニュー項目が存在するかどうか
			}
			$this->isExistsMenuItem = true;		// メニュー項目が存在するかどうか
	
			// シリアル番号を保存
			$this->serialArray[] = $serial;
		}
	}
	/**
	 * ページID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['pg_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('main_id_list', $row);
		$this->tmpl->parseTemplate('main_id_list', 'a');
		return true;
	}
	/**
	 * ページサブID、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function pageSubIdLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['pg_id'] == $this->currentPageSubId) $selected = 'selected';	// 現在のページサブID
		
		$name = $fetchedRow['pg_id'] . ' - ' . $fetchedRow['pg_name'];
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pg_id']),			// ページID
			'name'     => $this->convertToDispString($name),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('sub_id_list', $row);
		$this->tmpl->parseTemplate('sub_id_list', 'a');
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function contentListLoop($index, $fetchedRow, $param)
	{
		$selected = '';
		if ($fetchedRow['cn_id'] == $this->contentId) $selected = 'selected';	// 現在のコンテンツID
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['cn_id']),			// ページID
			'name'     => $this->convertToDispString($fetchedRow['cn_name']),			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('content_list', $row);
		$this->tmpl->parseTemplate('content_list', 'a');
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function menuIdListLoop($index, $fetchedRow, $param)
	{
		$value = $fetchedRow['mn_id'];
		$name = $fetchedRow['mn_name'];

		$selected = '';
		if ($value == $this->menuId) $selected = 'selected';
		
		$row = array(
			'value'    => $value,			// ページID
			'name'     => $name,			// ページ名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('menu_id_list', $row);
		$this->tmpl->parseTemplate('menu_id_list', 'a');
		return true;
	}
	/**
	 * メニュー項目タイプ選択メニュー作成
	 *
	 * @return なし
	 */
	function createItemTypeMenu()
	{
		for ($i = 0; $i < count($this->itemTypeArray); $i++){
			$value = $this->itemTypeArray[$i]['value'];
			$name = $this->itemTypeArray[$i]['name'];
			
			$selected = '';
			if ($value == $this->menuItemType) $selected = 'selected';
			
			$row = array(
				'value'    => $value,			// ページID
				'name'     => $name,			// ページ名
				'selected' => $selected														// 選択中かどうか
			);
			$this->tmpl->addVars('item_type_list', $row);
			$this->tmpl->parseTemplate('item_type_list', 'a');
		}
	}
	/**
	 * メニューIDをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function menuIdLoop($index, $fetchedRow, $param)
	{
		$value = $this->convertToDispString($fetchedRow['md_id']);
		$name = $this->convertToDispString($fetchedRow['md_name']);
		
		$selected = '';
		if ($value == $this->serialNo) $selected = 'selected';
			
		$row = array(
			'value'    => $value,			// メニュー項目ID
			'name'     => $name,			// メニュー項目名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('menuid_list', $row);
		$this->tmpl->parseTemplate('menuid_list', 'a');
		return true;
	}
}
?>
