<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_bbs_mainAccessWidgetContainer.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/bbs_accessDb.php');
//require_once($gEnvManager->getIncludePath() . '/common/userInfo.php');		// ユーザ情報クラス

class admin_bbs_mainAccessWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $groupRows;		// グループ情報
	const DEFAULT_LIST_COUNT = 30;			// 最大リスト表示数
//	const THIS_WIDGET_ID = '';			// ウィジェットID
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new bbs_accessDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'admin_access.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		// ユーザ情報、表示言語
		$userId = $gEnvManager->getCurrentUserId();
		$defaultLangId = $gEnvManager->getDefaultLanguage();
		
		// グループ一覧を取得
		$this->db->getAllGroupInfo($defaultLangId, $this->groupRows);
		
		$act = $request->trimValueOf('act');
		
		if ($act == 'update'){		// 更新のとき
			// カテゴリーを取得
			$this->db->getAllCategoryInfo($defaultLangId, $categoryRows);
			
			// 入力値で更新
			$isErr = false;
			for ($j = 0; $j < count($categoryRows); $j++){
				for ($i = 0; $i < count($this->groupRows); $i++){
					$categoryId = $categoryRows[$j]['sr_id'];
					$groupId = $this->groupRows[$i]['sg_id'];
					$itemNameR = 'item' . $categoryId . '_' . $groupId . '_read';
					$itemNameW = 'item' . $categoryId . '_' . $groupId . '_write';
					$canRead = ($request->trimValueOf($itemNameR) == 'on') ? 1 : 0;
					$canWrite = ($request->trimValueOf($itemNameW) == 'on') ? 1 : 0;
					$ret = $this->db->updateAccessRecord($groupId, $categoryId, $canRead, $canWrite, $userId);
					if (!$ret) $isErr = true;
				}
			}
			if ($isErr){
				$this->setAppErrorMsg('データ更新に失敗しました');
			} else {
				$this->setGuidanceMsg('データを更新しました');
			}
		}

		// グループを表示
		for ($i = 0; $i < count($this->groupRows); $i++){
			$row = array(
				'name' => $this->groupRows[$i]['sg_name']
			);
			$this->tmpl->addVars('grouplist', $row);
			$this->tmpl->parseTemplate('grouplist', 'a');
		}
		
		// カテゴリー一覧を取得
		$this->db->getAllCategory(array($this, 'itemListLoop'), $defaultLangId);
	}
	/**
	 * ユーザリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemListLoop($index, $fetchedRow, $param)
	{
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		
		$categoryId = $fetchedRow['sr_id'];
		
		// 読み込み、書き込み権限
		$this->tmpl->clearTemplate('group');
		for ($i = 0; $i < count($this->groupRows); $i++){
			// アクセス権限取得
			$groupId = $this->groupRows[$i]['sg_id'];
			$canRead = '';			// 読み込み権限
			$canWrite = '';			// 書き込み権限
			if ($this->db->getAccessRecord($groupId, $categoryId, $accessRow)){
				if ($accessRow['so_read']) $canRead = 'checked';			// 読み込み権限
				if ($accessRow['so_write']) $canWrite = 'checked';			// 書き込み権限
			}

			$row2 = array(		
					'category_id'	=> $categoryId,			// カテゴリーID
					'group_id'		=> $groupId,			// グループID
					'read'		=> $canRead,			// 読み込み権限
					'write'		=> $canWrite			// 書き込み権限
			);
			$this->tmpl->addVars('group', $row2);
			$this->tmpl->parseTemplate('group', 'a');
		}
			
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['sr_serial']),			// シリアル番号
			'id' => $this->convertToDispString($categoryId),			// ID
			'name' => $this->convertToDispString($fetchedRow['sr_name'])		// 名前
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		return true;
	}
}
?>
