<?php
/**
 * Eコマースカート処理クラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: cart.php 1681 2009-03-31 13:32:32Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainCartDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');

class cart
{
	private $cartDb;		// カートアクセス用ＤＢオブジェクト
	private $productDb;	// DB接続オブジェクト
	private $ecObj;		// 価格計算用オブジェクト
	private $cartId;
	private $langId;
	private $productTotal;				// 商品合計額
	private $productCount;		// 商品総数
	private $isErr;			// エラーステータス
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const STANDARD_PRICE = 'selling';	// 通常価格
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// DBオブジェクト作成
		$this->cartDb = new ec_mainCartDb();
		$this->productDb = new productDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * 商品の総額を取得
	 *
	 * @param string $type		通貨種別
	 * @param string $lang		言語
	 * @param float  $price		総額
	 * @param int    $count		総数
	 * @return bool				true=正常、false=異常
	 */
	public function getTotalPrice($cartId, $langId, &$price, &$count)
	{
		$this->cartId = $cartId;
		$this->langId = $langId;
		
		$this->productTotal = 0;		// 商品合計額
		$this->productCount = 0;		// 商品総数
		$this->isErr = false;
		$this->cartDb->getCartItemList($cartId, $langId, array($this, 'cartLoop'));
		if ($this->isErr){		// エラー発生のとき
			return false;
		} else {
			$price = $this->productTotal;
			$count = $this->productCount;
			return true;
		}
	}
	
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function cartLoop($index, $fetchedRow, $param)
	{
		$priceStatus = 1;	// 価格が有効であるかどうか
		$id = $fetchedRow['si_product_id'];	// 商品ID
		
		// 商品を取得
		$ret = $this->productDb->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4, $row5);
		if ($ret){
			// 商品の現在価格を取得
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
					
			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$unitPrice = $this->ecObj->getPriceWithTax($price, $dispUnitPrice);	// 税込み価格取得
			
			// 商品が表示不可のときは価格を無効とする
			if (!$row['pt_visible']) $priceStatus = 0;
		} else {
			// 商品情報が取得できないときは価格無効
			$priceStatus = 0;
		}
		
		// 価格が変更のときは、価格を無効にする
		$quantity = $fetchedRow['si_quantity'];
		$subtotal = $fetchedRow['si_subtotal'];
		$oldCurrency = $fetchedRow['si_currency_id'];
		if ($unitPrice * $quantity != $subtotal) $priceStatus = 0;
		if ($oldCurrency != $currency) $priceStatus = 0;
		
		// 価格作成
		$this->ecObj->setCurrencyType($oldCurrency, $this->langId);		// 通貨設定
		$this->ecObj->getPriceWithoutTax($subtotal, $dispPrice);				// 税込み価格取得
					
		// 価格の有効判断
		if (!$fetchedRow['si_available']) $priceStatus = 0;
		
		if (empty($priceStatus)){		// 価格無効があった場合はエラーを返す
			$this->isErr = true;			// エラーステータス
			return false;		// 処理中断
		} else {
			$this->productTotal += $subtotal;					// 合計価格
			$this->productCount += $quantity;					// 商品総数
			return true;
		}
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
}
?>
