<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_login_boxWidgetContainer.php 2256 2009-08-26 15:00:05Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');

class ec_login_boxWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	const TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
	const MAIL_OBJ_ID = 'ecmail';			// メール連携オブジェクト
	const EC_LIB_ID = "eclib";		// EC共通ライブラリオブジェクトID
	const DEFAULT_TITLE = '会員ログイン';
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->sysDb = $this->gInstance->getSytemDbObject();
		
		// メール連携オブジェクト取得
		$this->ecMailObj = $this->gInstance->getObject(self::MAIL_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'ecloginbox_login'){			// 会員ログインのとき
			// アカウント、パスワード取得
			$account = $request->trimValueOf('ec_account');
			$password = $request->trimValueOf('password');
		
			// ユーザ認証
			if ($this->gAccess->userLoginByAccount($account, $password)){
				// 初回ログインのときは、仮会員を正会員にする
				$userId = $this->gEnv->getCurrentUserId();
				if ($userId != 0){
					$ret = $this->gInstance->getObject(self::EC_LIB_ID)->makeTmpMemberToProperMember($userId);
					if ($ret){
						$ret = $this->sysDb->makeNormalLoginUser($userId);// 一般ログインユーザに設定
						
						// ######## 会員登録のメールをイントラネット側に送信 ########
						$this->ecMailObj->sendMemberInfoToBackoffice(0/*新規登録*/, $userId);
					}
				}
				// 画面を全体を再表示する
				$this->gPage->redirect($this->gEnv->getCurrentRequestUri());
				return;
			} else {
				// ログイン状態を削除
				$this->gAccess->userLogout();
				
				$this->tmpl->setAttribute('login_status', 'visibility', 'visible');		// ログイン状況
				$this->tmpl->addVar("login_status", "message", 'ログインに失敗しました');
			}
		} else if ($act == 'ecloginbox_logout'){			// 会員ログアウトのとき
			$this->gAccess->userLogout();
			
			// 画面を全体を再表示する
			$this->gPage->redirect($this->gEnv->getCurrentRequestUri());
			return;
		}
		// ログイン状態を取得
		$userName = $this->gEnv->getCurrentUserName();
		if (empty($userName)){		// ユーザがログインしていないとき
			// ログイン入力部、ログインボタン表示
			$this->tmpl->setAttribute('login_field', 'visibility', 'visible');
			$this->tmpl->setAttribute('login_button', 'visibility', 'visible');
			$this->tmpl->setAttribute('regmember_button', 'visibility', 'visible');		// 会員登録ボタン
		} else {		// ユーザがログイン中のとき
			$this->tmpl->addVar("login_status", "user_name", 'ログイン: ' . $userName . ' 様');
			
			// 会員情報、ログアウトボタン表示
			$this->tmpl->setAttribute('login_status', 'visibility', 'visible');		// ログイン状況
			$this->tmpl->setAttribute('logout_button', 'visibility', 'visible');
			$this->tmpl->setAttribute('member_button', 'visibility', 'visible');
		}
		
		// パスワード送信画面へのリンク
		$sendpwdUrl = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'task=sendpwd');
		$this->tmpl->addVar("regmember_button", "sendpwd_url", $this->getUrl($sendpwdUrl, true));
		
		// 会員登録画面へのリンク
		$regMemberUrl = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'task=regmember');
		$this->tmpl->addVar("regmember_button", "regmember_url", $this->getUrl($regMemberUrl, true));
		
		// パスワード変更画面へのリンク
		$changepwdUrl = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'task=changepwd');
		$this->tmpl->addVar("member_button", "changepwd_url", $this->getUrl($changepwdUrl, true));
		
		// 会員情報画面へのリンク
		$memberUrl = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'task=member');
		$this->tmpl->addVar("member_button", "member_url", $this->getUrl($memberUrl, true));
		
		// 注文履歴画面へのリンク
		$historyUrl = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'task=orderhistory');
		$this->tmpl->addVar("member_button", "orderhistory_url", $this->getUrl($historyUrl, true));
	}
	/**
	 * ウィジェットのタイトルを設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						ウィジェットのタイトル名
	 */
	function _setTitle($request, &$param)
	{
		return self::DEFAULT_TITLE;
	}
}
?>
