<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainConfiglangWidgetContainer.php 2844 2010-02-09 09:16:00Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainConfigsystemBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainConfiglangWidgetContainer extends admin_mainConfigsystemBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;	// システム情報取得用
	private $defaultLang;	// デフォルト言語
	private $acceptLanguage;	// アクセス可能言語
	private $serialArray = array();		// 表示されている項目シリアル番号
	const CF_ACCEPT_LANGUAGE	= 'accept_language';	// アクセス可能言語

	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new admin_mainDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'configlang.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		return $this->createDetail($request);
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		$this->defaultLang		= $this->gEnv->getDefaultLanguage();
		$act = $request->trimValueOf('act');

		if ($act == 'update'){		// 更新のとき
			// 入力チェック
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$listedItem = explode(',', $request->trimValueOf('seriallist'));
				$selItems = array();
				for ($i = 0; $i < count($listedItem); $i++){
					// 項目がチェックされているかを取得
					$itemName = 'item' . $i . '_selected';
					$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
					if ($itemValue){		// チェック項目
						$selItems[] = $listedItem[$i];
					}
				}
				$langStr = '';
				if (!empty($selItems)) $langStr = implode($selItems, ',');
				
				// アクセス可能言語を更新
				$ret = $this->sysDb->updateSystemConfig(self::CF_ACCEPT_LANGUAGE, $langStr);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else {		// 初期状態
		}
		$this->acceptLanguage = $this->gSystem->getAcceptLanguage(true/*再取得*/);
		
		// 言語一覧を取得
		$this->db->getAllLang(array($this, 'langListLoop'));

		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
	}
	/**
	 * 言語データをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function langListLoop($index, $fetchedRow, $param)
	{
		$langId = $fetchedRow['ln_id'];		// 言語ID
		
		// アクセス許可状態を取得
		$accept = '';
		if (in_array($langId, $this->acceptLanguage)) $accept = 'checked';

		$name = $fetchedRow['ln_name'];
		if ($langId == $this->defaultLang) $name .= '(デフォルト)';
		
		$row = array(
			'index'		=> $index,
			'value'		=> $this->convertToDispString($langId),			// 言語値
			'name'		=> $this->convertToDispString($name),			// 言語名
			'accept'	=> $accept														// アクセス許可状態
		);
		$this->tmpl->addVars('lang_list', $row);
		$this->tmpl->parseTemplate('lang_list', 'a');
		
		// 表示中項目のページサブIDを保存
		$this->serialArray[] = $langId;
		return true;
	}
}
?>
