<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: photoslideWidgetContainer.php 2270 2009-08-31 05:33:27Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class photoslideWidgetContainer extends BaseWidgetContainer
{
	private $langId;		// 現在の言語
	private $paramObj;		// 定義取得用
	private $css;			// 追加CSS
	private $visible;		// 表示するかどうか
	private $dispType;		// 画像リンク表示方法
	const DEFAULT_CONFIG_ID = 0;
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$this->langId = $this->gEnv->getCurrentLanguage();
		
		// 定義ID取得
		$configId = $this->gEnv->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;
		
		// パラメータオブジェクトを取得
		$this->paramObj = $this->getWidgetParamObjectWithId();

		// 指定定義IDのデータを取得
		$name = '';
		for ($i = 0; $i < count($this->paramObj); $i++){
			$id			= $this->paramObj[$i]->id;// 定義ID
			$targetObj	= $this->paramObj[$i]->object;
			if ($id == $configId){
				$name		= $targetObj->name;// 定義名
				$url		= $targetObj->url;		// 画像の読み込みディレクトリURL
				$this->css	= $targetObj->css;		// 追加CSS
				$this->dispType = $targetObj->dispType;	// 表示方法
				$effect		= $targetObj->effect;			// エフェクト
				$speed		= $targetObj->speed;
				break;
			}
		}
		if ($i < count($this->paramObj)){		// 該当する定義IDのデータが取得できたとき
			// 画像ディレクトリを読み込み
			$this->createImageList($url);
			
			// エフェクト設定を作成
			$effectStr = $this->createEffect($effect, $speed);
			$this->tmpl->addVar('show_html', 'effect', $effectStr);
			
			$this->tmpl->setAttribute('show_html', 'visibility', 'visible');
			$this->visible = true;
		}
	}
	/**
	 * CSSデータをHTMLヘッダ部に設定
	 *
	 * CSSデータをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string 						CSS文字列。出力しない場合は空文字列を設定。
	 */
	function _addCssToHead($request, &$param)
	{
		if ($this->visible){
			return $this->css;
		} else {
			return '';
		}
	}
	/**
	 * エフェクトの設定を作成
	 *
	 * @param string $effect		エフェクト
	 * @param string $speed			speedパラメータ
	 * @return string				エフェクト文字列
	 */
	function createEffect($effect, $speed)
	{
		$effectStr = '';
		if (!empty($effect)) $effectStr .= 'fx: \'' . $effect . '\'';
		if (!empty($speed)){
			if (!empty($effectStr)) $effectStr .= ',';
			$effectStr .= 'speed: \'' . $speed . '\'';
		}
		return $effectStr;
	}
	/**
	 * スライドショー用画像一覧を作成
	 *
	 * @param string $url		画像のあるディレクトリ(URL表記)
	 * @return なし							
	 */
	function createImageList($url)
	{
		// 画像ディレクトリを読み込み
		$searchPath = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getSystemRootPath(), $url);		// 画像検索パス
		$urlPath = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $url);
		
		// ファイル一覧取得
		$files = $this->getFiles($searchPath);
		
		// 表示方法によって並べ替え
		switch ($this->dispType){
			case 0:
				sort($files);
				break;
			case 1:
				shuffle($files);
				break;
		}
		
		for ($i = 0; $i < count($files); $i++){
			$imageUrl = $urlPath . '/' . $files[$i];
			$row = array(
				'url'    => $this->getUrl($imageUrl)			// ファイル名
			);
			$this->tmpl->addVars('image_list', $row);
			$this->tmpl->parseTemplate('image_list', 'a');
		}
	}
	/**
	 * 指定ディレクトリのファイル一覧を取得
	 *
	 * @param string $path		読み込みディレクトリ
	 * @return array			ファイル名一覧
	 */
	function getFiles($path)
	{
		$filenames = array();
		if (is_dir($path)){
			$dir = dir($path);
			while (($file = $dir->read()) !== false){
				$filePath = $path . '/' . $file;
				// ファイルかどうかチェック
				if (strncmp($file, '.', 1) != 0 && $file != '..' && is_file($filePath)
					&& strncmp($file, '_', 1) != 0){		// 「_」で始まる名前のファイルは読み込まない
					$filenames[] = $file;
				}
			}
			$dir->close();
		}
		return $filenames;
	}
}
?>
