<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2013 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: commentTopWidgetContainer.php 6066 2013-06-03 00:28:13Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getWidgetContainerPath('comment') . '/commentBaseWidgetContainer.php');

class commentTopWidgetContainer extends commentBaseWidgetContainer
{
	private $message;			// ユーザ向けメッセージ
	private $pageNo;				// ページ番号
//	private $now;	// 現在日時
//	private $currentDay;		// 現在日
//	private $currentHour;		// 現在時間
	private $currentPageUrl;			// 現在のページURL
	private $widgetTitle;			// ウィジェットタイトル
	private $commentVisible;		// コメントを表示する
	private $commentAccept;		// コメントを受け付ける
	private $isExistsComment;	// 表示するコメントがあるかどうか
	private $useTitle;		// コメント入力項目(タイトルあり)
	private $useAuthor;		// コメント入力項目(投稿者名あり)
	private $useEmail;		// コメント入力項目(Eメールあり)
	private $useUrl;		// コメント入力項目(URLあり)
	private $useAvatar;		// コメント入力項目(アバターあり)
	private $addLib = array();		// 追加スクリプト
	private $avatarSize;		// アバター画像サイズ
//	const CONTENT_TYPE = 'bg';
	const COMMENT_ID_SEPARATOR	= ':';			// コメントID作成用セパレータ
	const DEFAULT_TITLE = 'コメント';		// デフォルトのウィジェットタイトル名
	const LINK_PAGE_COUNT		= 5;			// リンクページ数
	
	const MESSAGE_NOT_PERMITTED_REFER		= '閲覧は許可されていません';				// コメント閲覧権限がない場合
	const MESSAGE_NOT_PERMITTED_POST		= '投稿は許可されていません';				// コメント投稿権限がない場合
	const MESSAGE_NO_COMMENT		= 'コメントは投稿されていません';				// コメントが投稿されていないメッセージ


	const COMMENT_PERMA_HEAD	= 'comment-';		// コメントパーマリンク
	const COMMENT_TITLE_FORMAT		= '「%s」についてのコメント';	// コメント用タイトルフォーマット
	const COMMENT_TITLE		= ' についてのコメント';	// コメント用タイトル
	const NO_COMMENT_TITLE = 'タイトルなし';				// 未設定時のコメントタイトル
	const DEFAULT_VIEW_COUNT	= 10;				// デフォルトの表示記事数

	const COOKIE_LIB = 'jquery.cookie';		// 名前保存用クッキーライブラリ

	const AVATAR_TITLE_TAIL = 'のアバター';
	const EDIT_ICON_MIN_POS = 30;			// 編集アイコンの位置
	const EDIT_ICON_NEXT_POS = 35;			// 編集アイコンの位置
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'main.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$contentsId = '';			// 共通コンテンツID
		$contentType = $this->gPage->getContentType();
//		$avatarFormat = $this->gInstance->getImageManager()->getDefaultAvatarFormat();		// 画像フォーマット取得
//		$this->gInstance->getImageManager()->parseImageFormat($avatarFormat, $imageType, $imageAttr, $this->avatarSize);		// 画像情報取得
		
		switch ($contentType){
			case M3_VIEW_TYPE_CONTENT:				// 汎用コンテンツ
				$contentsId = $request->trimValueOf(M3_REQUEST_PARAM_CONTENT_ID);
				if (empty($contentsId)) $contentsId = $request->trimValueOf(M3_REQUEST_PARAM_CONTENT_ID_SHORT);
				break;
			case M3_VIEW_TYPE_PRODUCT:				// 商品情報(Eコマース)
				$contentsId = $request->trimValueOf(M3_REQUEST_PARAM_PRODUCT_ID);
				if (empty($contentsId)) $contentsId = $request->trimValueOf(M3_REQUEST_PARAM_PRODUCT_ID_SHORT);
				break;
			case M3_VIEW_TYPE_BBS:					// BBS
				$contentsId = $request->trimValueOf(M3_REQUEST_PARAM_BBS_THREAD_ID);
				if (empty($contentsId)) $contentsId = $request->trimValueOf(M3_REQUEST_PARAM_BBS_THREAD_ID_SHORT);
				break;
			case M3_VIEW_TYPE_BLOG:				// ブログ
				$contentsId = $request->trimValueOf(M3_REQUEST_PARAM_BLOG_ENTRY_ID);
				if (empty($contentsId)) $contentsId = $request->trimValueOf(M3_REQUEST_PARAM_BLOG_ENTRY_ID_SHORT);
				break;
			case M3_VIEW_TYPE_WIKI:				// wiki
				$contentsId = $request->getWikiPageFromQuery();		// 「=」なしのパラメータはwikiパラメータとする
				break;
			case M3_VIEW_TYPE_USER:				// ユーザ作成コンテンツ
				$contentsId = $request->trimValueOf(M3_REQUEST_PARAM_ROOM_ID);
				if (empty($contentsId)) $contentsId = $request->trimValueOf(M3_REQUEST_PARAM_ROOM_ID_SHORT);
				break;
			case M3_VIEW_TYPE_EVENT:				// イベント情報
				$contentsId = $request->trimValueOf(M3_REQUEST_PARAM_EVENT_ID);
				if (empty($contentsId)) $contentsId = $request->trimValueOf(M3_REQUEST_PARAM_EVENT_ID_SHORT);
				break;
			case M3_VIEW_TYPE_PHOTO:				// フォトギャラリー
				$contentsId = $request->trimValueOf(M3_REQUEST_PARAM_PHOTO_ID);
				if (empty($contentsId)) $contentsId = $request->trimValueOf(M3_REQUEST_PARAM_PHOTO_ID_SHORT);
				break;
		}
		// 共通コンテンツIDがない場合は非表示にする
		if (empty($contentsId)){
			$this->cancelParse();		// テンプレート変換処理中断
			return;
		}
		
		// コメント定義取得
		$ret = self::$_mainDb->getConfig($contentType, ''/*全体の定義*/, $row);
		if ($ret){
			$viewType				= $row[commentCommonDef::FD_VIEW_TYPE];				// コメントタイプ(フラット)
			$viewCount				= $row[commentCommonDef::FD_MAX_COUNT];			// 表示項目数
			$viewDirection			= $row[commentCommonDef::FD_VIEW_DIRECTION];				// 表示順
			$this->commentVisible	= $row[commentCommonDef::FD_VISIBLE];		// コメントを表示する
			$commentVisibleDefault	= $row[commentCommonDef::FD_VISIBLE_D];		// コメントを表示する(個別デフォルト)
			$this->commentAccept	= $row[commentCommonDef::FD_ACCEPT_POST];		// コメントを受け付ける
			$commentAcceptDefault	= $row[commentCommonDef::FD_ACCEPT_POST_D];		// コメントを受け付ける(個別デフォルト)
			$userLimited			= $row[commentCommonDef::FD_USER_LIMITED];		// ユーザ制限あり
			$permitHtml				= $row[commentCommonDef::FD_PERMIT_HTML];		// HTMLあり
			$permitImage			= $row[commentCommonDef::FD_PERMIT_IMAGE];		// 画像あり
			$maxLength				= $row[commentCommonDef::FD_MAX_LENGTH];			// 文字数
			$this->useTitle			= $row[commentCommonDef::FD_USE_TITLE];		// タイトルあり
			$this->useAuthor		= $row[commentCommonDef::FD_USE_AUTHOR];		// 投稿者名あり
			$this->useEmail			= $row[commentCommonDef::FD_USE_EMAIL];		// Eメールあり
			$this->useUrl			= $row[commentCommonDef::FD_USE_URL];		// URLあり
			$this->useAvatar		= $row[commentCommonDef::FD_USE_AVATAR];		// アバターあり
		} else {		// 定義が取得できないとき
			$this->cancelParse();		// テンプレート変換処理中断
			return;
		}
		// コンテンツ個別のコメント定義取得
		// 全体の定義の否定形を最優先する
		$ret = self::$_mainDb->getConfig($contentType, $contentsId, $row);
		if ($ret){
			if ($this->commentVisible) $this->commentVisible	= $row[commentCommonDef::FD_VISIBLE];		// コメントを表示する
			if ($this->commentAccept) $this->commentAccept		= $row[commentCommonDef::FD_ACCEPT_POST];		// コメントを受け付ける
		} else {		// 個別の定義がない場合はデフォルトを取得
			if ($this->commentVisible) $this->commentVisible	= $commentVisibleDefault;		// コメントを表示する
			if ($this->commentAccept) $this->commentAccept		= $commentAcceptDefault;		// コメントを受け付ける
		}
		// コメント非表示の場合は終了
		if (!$this->commentVisible){
			$this->cancelParse();		// テンプレート変換処理中断
			return;
		}
		// 初期設定値
//		$this->now = date("Y/m/d H:i:s");	// 現在日時
//		$this->currentDay = date("Y/m/d");		// 日
//		$this->currentHour = (int)date("H");		// 時間
		$this->currentPageUrl = $this->gEnv->createCurrentPageUrl();// 現在のページURL
		$sendButtonLabel = 'コメントを投稿';		// 送信ボタンラベル
		$sendStatus = 0;		// 送信状況
		$inputEnabled = true;			// 入力の許可状態
		
		// 入力値取得
		$act = $request->trimValueOf('act');
		$pageNo = $request->trimIntValueOf('page', '1');				// ページ番号
		$title = $request->trimValueOf('title');
		$author = $request->trimValueOf('author');			// 投稿者名
		$email = $request->trimValueOf('email');
		$url = $request->trimValueOf('url');
		$comment = $request->trimValueOf('comment');
		$sendStatus = intval($request->trimValueOf('sendstatus'));			// 送信ステータス
		if ($sendStatus < 0 || 2 < $sendStatus) $sendStatus = 0;
		$postTicket = $request->trimValueOf('ticket');		// POST確認用
		
		// コメントIDの確認
		$isCommentValid = false;
		$commentId = $request->trimValueOf('commentid');			// コメントID
		if (!empty($commentId) && $commentId = md5($contentType . self::COMMENT_ID_SEPARATOR . $contentsId)) $isCommentValid = true;
		
		if ($act == 'checkcomment' && $sendStatus == 0){		// コメント確認のとき
			if (!empty($postTicket) && $postTicket == $request->getSessionValue(M3_SESSION_POST_TICKET) && $isCommentValid){		// 正常なPOST値のとき
				// 入力チェック
				if (empty($maxLength)){		// 空のときは長さのチェックなし
					$this->checkInput($comment, 'コメント内容');
				} else {
					$this->checkLength($comment, 'コメント内容', $maxLength);
				}
				if ($this->useEmail) $this->checkMailAddress($email, 'Eメール', true);

				// エラーなしの場合は確認画面表示
				if ($this->getMsgCount() == 0){
					$this->setGuidanceMsg('この内容でコメントを投稿しますか?');
				
					// 入力の変更不可
					$sendButtonLabel = 'コメントを投稿';		// 送信ボタンラベル
					$sendStatus = 1;// 送信状況を「確定」に変更
					$inputEnabled = false;			// 入力の許可状態
					
					$this->tmpl->addVar("add_comment", "title_disabled", 'readonly');
					$this->tmpl->addVar("user_info", "name_disabled", 'readonly');
					$this->tmpl->addVar("user_info", "email_disabled", 'readonly');
					$this->tmpl->addVar("add_comment", "url_disabled", 'readonly');
					$this->tmpl->addVar("add_comment", "body_disabled", 'readonly');
					$this->tmpl->setAttribute('cancel_button', 'visibility', 'visible');		// キャンセルボタン表示
				}
				// ハッシュキー作成
				$postTicket = md5(time() . $this->gAccess->getAccessLogSerialNo());
				$request->setSessionValue(M3_SESSION_POST_TICKET, $postTicket);		// セッションに保存
			} else {		// ハッシュキーが異常のとき
				// 送信ステータスを初期化
				$sendStatus = 0;
				
				$request->unsetSessionValue(M3_SESSION_POST_TICKET);		// セッション値をクリア
			}
			
			// 入力値を戻す
//			$this->tmpl->addVar("add_comment", "title", $this->convertToDispString($commentTitle));
//			$this->tmpl->addVar("user_info", "name", $this->convertToDispString($name));
//			$this->tmpl->addVar("user_info", "email", $this->convertToDispString($email));
//			$this->tmpl->addVar("add_comment", "url", $this->convertToDispString($url));
//			$this->tmpl->addVar("add_comment", "body", $this->convertToDispString($comment));
//			$this->tmpl->addVar("_widget", "entry_id", $this->convertToDispString($this->entryId));		// 記事ID
		} else if ($act == 'sendcomment' && $sendStatus == 1){	// コメント受信のとき
			if (!empty($postTicket) && $postTicket == $request->getSessionValue(M3_SESSION_POST_TICKET) && $isCommentValid){		// 正常なPOST値のとき
				if ($this->getMsgCount() == 0){
					$ret = false;
					if (!empty($comment) &&
						!empty($postTicket) && $postTicket == $request->getSessionValue(M3_SESSION_POST_TICKET)){		// 正常なPOST値のとき
						// コメントを保存
						$ret = $this->commentDb->addCommentItem($this->entryId, $this->_langId, $commentTitle, $comment, $url, $name, $email, $this->_userId, $this->now, $newSerial);
				
						// 記事更新日を更新
						if ($ret) $ret = self::$_mainDb->updateEntryDt($this->entryId, $this->_langId);
					}
					if ($ret){
						$this->setGuidanceMsg('コメントを投稿しました');
					} else {
						$this->setUserErrorMsg('コメントの投稿に失敗しました');
					}
				//$request->unsetSessionValue(M3_SESSION_POST_TICKET);		// セッション値をクリア
					// 項目を入力不可に設定
					$inputEnabled = false;			// 入力の許可状態

					// 送信ステータスを更新
					$sendStatus = 2;
					
					$request->unsetSessionValue(M3_SESSION_POST_TICKET);		// セッション値をクリア
				} else {		// 送信時入力エラーの場合は初期画面に戻す
					// 送信ステータスを更新
					$sendStatus = 0;
					
					// ハッシュキー作成
					$postTicket = md5(time() . $this->gAccess->getAccessLogSerialNo());
					$request->setSessionValue(M3_SESSION_POST_TICKET, $postTicket);		// セッションに保存
				}
			} else {		// ハッシュキーが異常のとき
				// 送信ステータスを初期化
				$sendStatus = 0;
					
				$request->unsetSessionValue(M3_SESSION_POST_TICKET);		// セッション値をクリア
			}
		} else if ($act == 'sendcancel' && $sendStatus == 1){	// コメントキャンセルのとき
			if (!empty($postTicket) && $postTicket == $request->getSessionValue(M3_SESSION_POST_TICKET) && $isCommentValid){		// 正常なPOST値のとき
				// 送信ステータスを更新
				$sendStatus = 0;

				// ハッシュキー作成
				$postTicket = md5(time() . $this->gAccess->getAccessLogSerialNo());
				$request->setSessionValue(M3_SESSION_POST_TICKET, $postTicket);		// セッションに保存
			} else {		// ハッシュキーが異常のとき
				// 送信ステータスを初期化
				$sendStatus = 0;
				
				$request->unsetSessionValue(M3_SESSION_POST_TICKET);		// セッション値をクリア
			}
		} else {
			// 送信ステータスを初期化
			$sendStatus = 0;
				
			// ハッシュキー作成
			$postTicket = md5(time() . $this->gAccess->getAccessLogSerialNo());
			$request->setSessionValue(M3_SESSION_POST_TICKET, $postTicket);		// セッションに保存
		}
		
		// タイトル作成
		$this->widgetTitle = $this->createTitle($contentType, $contentsId);
		
		// ##### コメントを表示 #####
		$showComment = false;		// コメント表示するかどうか
		if (!$userLimited || ($userLimited && $this->gEnv->isCurrentUserLogined())){		// ユーザ制限なし、または、ユーザ制限ありでログイン済みの場合
			if ($sendStatus == 0){		// 初期表示の場合はすべてのコメントを表示
				//$this->tmpl->setAttribute('show_comment', 'visibility', 'visible');		// 既存コメントを表示
						
				// コメント総数取得
				$totalCount = self::$_mainDb->getCommentCount($contentType, $this->_langId, $contentsId, true/*公開コメントのみ*/);
				$pageLink = $this->createPageLink($pageNo, $totalCount, $viewCount, $this->currentPageUrl);
		
				// コメント取得
				self::$_mainDb->getComment($contentType, $this->_langId, $contentsId, $viewCount, $pageNo, $viewDirection, array($this, 'itemsLoop'));
			
				// コメントがない場合はリストを非表示
				//if (!$this->isExistsComment) $this->tmpl->setAttribute('comment_list', 'visibility', 'hidden');
				if ($this->isExistsComment) $this->tmpl->setAttribute('show_comment', 'visibility', 'visible');		// 既存コメントを表示
			} else {
				// 初期表示以外の場合はリプライ先のコメントのみ表示
				
				// コメント入力エリアをトップに表示
				$this->tmpl->setAttribute('scrollup_comment', 'visibility', 'visible');
			}
			
			$showComment = true;		// コメント表示するかどうか
		} else {
			$this->message = self::MESSAGE_NOT_PERMITTED_REFER;		// 閲覧不可メッセージ
		}

		// コメントを受け付けるときは、コメント入力欄を表示
		if ($showComment && $this->commentAccept){
			$this->tmpl->setAttribute('add_comment', 'visibility', 'visible');		// コメント投稿欄を表示
			
			if ($this->useTitle){
				$this->tmpl->setAttribute('input_title', 'visibility', 'visible');		// タイトルあり
			}
			if ($this->useAuthor){
				$this->tmpl->setAttribute('input_author', 'visibility', 'visible');		// 投稿者名あり
			}
			if ($this->useEmail){
				$this->tmpl->setAttribute('input_email', 'visibility', 'visible');		// Eメールあり
			}
			if ($this->useUrl){
				$this->tmpl->setAttribute('input_url', 'visibility', 'visible');		// URLあり
			}
			
			//if ($this->useAvatar) $this->tmpl->setAttribute('input_title', 'visibility', 'visible');		// アバターあり
			
			/*
			if (!self::$_configArray[commentCommonDef::CF_COMMENT_USER_LIMITED]){	// ユーザ制限なしのときは名前、メールアドレスを表示
				$this->tmpl->setAttribute('user_info', 'visibility', 'visible');
			}
			$this->tmpl->setAttribute('add_comment', 'visibility', 'visible');
			*/

			// コメントID作成
			$commentId = md5($contentType . self::COMMENT_ID_SEPARATOR . $contentsId);			// コメントID作成用セパレータ
			
			$this->tmpl->addVar("add_comment", "send_button_label", $sendButtonLabel);// 送信ボタンラベル
			$this->tmpl->addVar("add_comment", "send_status", $sendStatus);// 送信状況
			$this->tmpl->addVar("add_comment", "status",	$sendStatus);			// 送信ステータス
			$this->tmpl->addVar("add_comment", "ticket", $postTicket);				// 画面確認用
			$this->tmpl->addVar("add_comment", "comment_id", $commentId);				// コメントID
			
			// 名前保存用のスクリプトライブラリ追加
			$this->tmpl->setAttribute('init_cookie', 'visibility', 'visible');
			$this->tmpl->setAttribute('update_cookie', 'visibility', 'visible');
			$this->addLib[] = self::COOKIE_LIB;
			
		} else {		// コメント投稿不可の場合
			if (empty($this->message)) $this->message = self::MESSAGE_NOT_PERMITTED_POST;		// 投稿不可メッセージ
		}
		
		// コメントがないときは投稿なしメッセージを表示
		if (empty($this->message) && !$this->isExistsComment){
			$this->message = self::MESSAGE_NO_COMMENT;
		}
		
		// 初期表示の場合はメッセージを表示
		if ($sendStatus == 0 && !empty($this->message)){
			$this->tmpl->setAttribute('message', 'visibility', 'visible');
			$this->tmpl->addVar("message", "message", $this->convertToDispString($this->message));
		}
	}
	/**
	 * ウィジェットのタイトルを設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						ウィジェットのタイトル名
	 */
	function _setTitle($request, &$param)
	{
		return $this->widgetTitle;
	}
	/**
	 * タイトル作成
	 *
	 * @param string $contentType		コンテンツタイプ
	 * @param string $contentsId		共通コンテンツID
	 * @param string					タイトル
	 */
	function createTitle($contentType, $contentsId)
	{
		$title = self::DEFAULT_TITLE;
		
		switch ($contentType){
			case M3_VIEW_TYPE_CONTENT:				// 汎用コンテンツ
				$ret = self::$_mainDb->getContentById(''/*PC用コンテンツ*/, $this->_langId, $contentsId, $row);
				if ($ret) $contentName = $row['cn_name'];
				break;
			case M3_VIEW_TYPE_PRODUCT:				// 商品情報(Eコマース)
				$ret = self::$_mainDb->getProductById($contentsId, $this->_langId, $row);
				if ($ret) $contentName = $row['pt_name'];
				break;
			case M3_VIEW_TYPE_BBS:					// BBS
				// 未使用
				break;
			case M3_VIEW_TYPE_BLOG:				// ブログ
				$ret = self::$_mainDb->getEntryById($contentsId, $this->_langId, $row);
				if ($ret) $contentName = $row['be_name'];
				break;
			case M3_VIEW_TYPE_WIKI:				// wiki
				$contentName = $contentsId;
				break;
			case M3_VIEW_TYPE_USER:				// ユーザ作成コンテンツ
				$ret = self::$_mainDb->getRoomById($contentsId, $this->_langId, $row);
				if ($ret) $contentName = $row['ur_name'];
				break;
			case M3_VIEW_TYPE_EVENT:				// イベント情報
				$ret = self::$_mainDb->getEventById($contentsId, $this->_langId, $row);
				if ($ret) $contentName = $row['ee_name'];
				break;
			case M3_VIEW_TYPE_PHOTO:				// フォトギャラリー
				$ret = self::$_mainDb->getPhotoById($contentsId, $this->_langId, $row);
				if ($ret) $contentName = $row['ht_name'];
				break;
		}
		if (!empty($contentName)){
			$title = sprintf(self::COMMENT_TITLE_FORMAT, $contentName);
		}
		return $title;
	}
	/**
	 * JavascriptライブラリをHTMLヘッダ部に設定
	 *
	 * JavascriptライブラリをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string,array 				Javascriptライブラリ。出力しない場合は空文字列を設定。
	 */
	function _addScriptLibToHead($request, &$param)
	{
		return $this->addLib;
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		$permalink = '#' . self::COMMENT_PERMA_HEAD . $fetchedRow['bo_no'];		// コメントパーマリンク
		$commentTitle = $fetchedRow['bo_name'];			// コメントタイトル
		if (empty($commentTitle)) $commentTitle = self::NO_COMMENT_TITLE;
		$commentTitle = '<a href="' . $permalink . '">' . $this->convertToDispString($commentTitle) . '</a>';
	
		// コメント投稿ユーザ名
		if (self::$_configArray[commentCommonDef::CF_COMMENT_USER_LIMITED]){	// ユーザ制限のときはログインユーザ名を取得
			$userName = $this->convertToDispString($fetchedRow['lu_name']);
		} else {
			$userName = $this->convertToDispString($fetchedRow['bo_user_name']);	// 入力値を使用
		}
		$url = $fetchedRow['bo_url'];
		if (!empty($url)) $url = '<a href="' . $this->convertUrlToHtmlEntity($url) . '" target="_blank">URL</a>';
		$comment = '<div class="blog_comment_body">' . $this->convertToPreviewText($this->convertToDispString($fetchedRow['bo_html'])) . '</div>';		// 改行コードをbrタグに変換
	
		// アバター
		$avatarUrl = $this->gInstance->getImageManager()->getAvatarUrl($fetchedRow['lu_avatar']);
		$avatarTitle = $this->convertToDispString($userName) . self::AVATAR_TITLE_TAIL;
		$avatarTag = '<img src="' . $this->getUrl($avatarUrl) . '" width="' . $this->avatarSize . '" height="' . $this->avatarSize . 
						'" border="0" alt="' . $avatarTitle . '" title="' . $avatarTitle . '" />';

		// Magic3マクロ変換
		// あらかじめ「CM_」タグをすべて取得する?
		$contentParam = array();
		$contentParam[M3_TAG_MACRO_COMMENT_AUTHOR] = $this->convertToDispString($userName);			// コンテンツ置換キー(著者)
		$contentParam[M3_TAG_MACRO_COMMENT_DATE] = $this->timestampToDate($fetchedRow['bo_regist_dt']);		// コンテンツ置換キー(登録日)
		$contentParam[M3_TAG_MACRO_COMMENT_TIME] = $this->timestampToTime($fetchedRow['bo_regist_dt']);		// コンテンツ置換キー(登録時)
		$contentParam[M3_TAG_MACRO_AVATAR] = $avatarTag;
		$contentParam[M3_TAG_MACRO_TITLE] = $commentTitle;
		$contentParam[M3_TAG_MACRO_BODY] = $comment;
		$contentParam[M3_TAG_MACRO_URL] = $url;
		$commentText = $this->createComment($contentParam);

		$commentRow = array(
			'comment'		=> $commentText			// コメント内容
		);
		$this->tmpl->addVars('comment_list', $commentRow);
		$this->tmpl->parseTemplate('comment_list', 'a');


		// コメントへのリンク
		$commentLink = '';
		if ($this->viewMode != 10 && $this->commentAccept){	// 記事単体表示でコメントを表示する場合
			$commentLink = '<strong><a href="' . $this->convertUrlToHtmlEntity($linkUrl . '#comment') . '" >コメント(' . $commentCount . ')</a></strong>';	// コメントへのリンク
		}
		
		$row = array(
			'entry' => $entryText,	// 投稿記事
			'button_list' => $buttonList	// 記事編集ボタン
		);
		$this->tmpl->addVars('comment_list', $row);
		$this->tmpl->parseTemplate('comment_list', 'a');
		$this->isExistsComment = true;				// 表示データがあるかどうか
		return true;
	}
	/**
	 * ページリンク作成
	 *
	 * @param int $pageNo			ページ番号(1～)。ページ番号が範囲外にある場合は自動的に調整
	 * @param int $totalCount		総項目数
	 * @param int $viewItemCount	1ページあたりの項目数
	 * @param string $baseUrl		リンク用のベースURL
	 * @return string				リンクHTML
	 */
	function createPageLink(&$pageNo, $totalCount, $viewItemCount, $baseUrl)
	{
		// 表示するページ番号の修正
		$pageCount = (int)(($totalCount -1) / $viewItemCount) + 1;		// 総ページ数
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;

		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			// ページ数1から「LINK_PAGE_COUNT」までのリンクを作成
			$maxPageCount = $pageCount < self::LINK_PAGE_COUNT ? $pageCount : self::LINK_PAGE_COUNT;
			for ($i = 1; $i <= $maxPageCount; $i++){
				if ($i == $pageNo){
					$link = '&nbsp;' . $i;
				} else {
					$linkUrl = $this->getUrl($baseUrl . '&page=' . $i, true/*リンク用*/);
					$link = '&nbsp;<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >' . $i . '</a>';
				}
				$pageLink .= $link;
			}
			// 残りは「...」表示
			if ($pageCount > self::LINK_PAGE_COUNT) $pageLink .= '&nbsp;...';
		}
		if ($pageNo > 1){		// 前ページがあるとき
			$linkUrl = $this->getUrl($baseUrl . '&page=' . ($pageNo -1), true/*リンク用*/);
			$link = '<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >前へ</a>';
			$pageLink = $link . $pageLink;
		}
		if ($pageNo < $pageCount){		// 次ページがあるとき
			$linkUrl = $this->getUrl($baseUrl . '&page=' . ($pageNo +1), true/*リンク用*/);
			$link = '&nbsp;<a href="' . $this->convertUrlToHtmlEntity($linkUrl) . '" >次へ</a>';
			$pageLink .= $link;
		}
		return $pageLink;
	}
	/**
	 * 詳細コンテンツを作成
	 *
	 * @param int $viewMode				表示モード
	 * @param array	$contentParam		コンテンツ作成用パラメータ
	 * @return string			作成コンテンツ
	 */
	function createDetailContent($viewMode, $contentParam)
	{
		static $initContentText;
		
		if (!isset($initContentText)){
			if ($viewMode == 10){		// 記事単体表示の場合
				$initContentText = self::$_configArray[commentCommonDef::CF_LAYOUT_ENTRY_SINGLE];			// コンテンツレイアウト(記事詳細)
			} else {
				$initContentText = self::$_configArray[commentCommonDef::CF_LAYOUT_ENTRY_LIST];			// コンテンツレイアウト(記事一覧)
			}
		}
		
		// コンテンツを作成
		$contentText = $initContentText;
		$keys = array_keys($contentParam);
		for ($i = 0; $i < count($keys); $i++){
			$key = $keys[$i];
			$value = str_replace('\\', '\\\\', $contentParam[$key]);	// ##### (注意)preg_replaceで変換値のバックスラッシュが解釈されるので、あらかじめバックスラッシュを2重化しておく必要がある
			
			$pattern = '/' . preg_quote(M3_TAG_START . $key) . ':?(.*?)' . preg_quote(M3_TAG_END) . '/u';
			$contentText = preg_replace($pattern, $value, $contentText);
		}
		return $contentText;
	}
	/**
	 * コメントを作成
	 *
	 * @param array	$contentParam		コンテンツ作成用パラメータ
	 * @return string			作成コンテンツ
	 */
	function createComment($contentParam)
	{
		static $initContentText;
		if (!isset($initContentText)) $initContentText = self::$_configArray[commentCommonDef::CF_LAYOUT_COMMENT_LIST];			// コンテンツレイアウト(コメント一覧)
		
		// コンテンツを作成
		$contentText = $initContentText;
		$keys = array_keys($contentParam);
		for ($i = 0; $i < count($keys); $i++){
			$key = $keys[$i];
			$value = str_replace('\\', '\\\\', $contentParam[$key]);	// ##### (注意)preg_replaceで変換値のバックスラッシュが解釈されるので、あらかじめバックスラッシュを2重化しておく必要がある
			
			$pattern = '/' . preg_quote(M3_TAG_START . $key) . ':?(.*?)' . preg_quote(M3_TAG_END) . '/u';
			$contentText = preg_replace($pattern, $value, $contentText);
		}
		return $contentText;
	}
}
?>
