# coding: UTF-8

require 'mailutils/mail_encoder'

#=単純なメールエンコーダーです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: simple_mail_encoder.rb 734 2012-06-16 08:16:38Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class SimpleMailEncoder < MailEncoder

	def initialize(to_encoding)
		@to_encoding = to_encoding
	end

	def encode(content, from_encoding)
		begin
			if from_encoding != nil then
				return content.encode(@to_encoding, from_encoding)
			else
				return content.encode(@to_encoding)
			end
		rescue StandardError => e
			M2W_LOGGER.error(e)
			if RUBY_VERSION < '1.9.0' then
				return content
			else
				return content.encode(@to_encoding, from_encoding, :invalid => :replace, :undef => :replace)
			end
		end
	end

end
