package jp.dip.commonsense.android.mametalk;

import android.app.Dialog;
import android.content.Context;
import android.database.Cursor;
import android.provider.Im;
import android.provider.Im.ContactsColumns;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;

public abstract class AbstractGroupChatInvitationDialog extends Dialog implements View.OnClickListener {

	private ListView listView;
	
	public AbstractGroupChatInvitationDialog(Context context) {
		super(context);
		setContentView(R.layout.group_chat_invitation_dialog);
		setTitle(R.string.dialog_title_groupchat_invitation);
		listView = (ListView)findViewById(android.R.id.list);
		listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@SuppressWarnings("unchecked")
			@Override
			public void onItemClick(AdapterView adapterview, View view, int i, long l) {
				CheckBox checkBox = (CheckBox)view.findViewById(R.id.contact_checkbox);
				checkBox.setChecked(!checkBox.isChecked());
			}
		});
		Button addButton = (Button) findViewById(R.id.invite_button);
		addButton.setOnClickListener(this);
		fillData();
	}

	private void fillData() {
    	Cursor cursor = getContext().getContentResolver()
    			.query(Im.Contacts.CONTENT_URI, null, "type=0", null, null);
    	getListView().setAdapter(new SimpleCursorAdapter(getContext(), R.layout.selectable_contact_row, cursor,
    				new String[] { ContactsColumns.NICKNAME },
    				new int[] { R.id.nickname_view }));
    	
    }

	public ListView getListView() {
		return listView;
	}
	
}
