package jp.dip.commonsense.android.mametalk;

import java.util.ArrayList;

import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;

import com.google.android.gtalkservice.IGTalkSession;

public class GroupChatCreaterDialog extends AbstractGroupChatInvitationDialog {
	
	private IGTalkSession gtalkSession;
	
	public GroupChatCreaterDialog(Context context, IGTalkSession gtalkSession) {
		super(context);
		this.gtalkSession = gtalkSession;
	}

	@Override
	public void onClick(View view) {
		if (view.getId() == R.id.invite_button) {
			int size = getListView().getCount();
			ArrayList<String> contacts = new ArrayList<String>();
			for (int i = 0; i < size; i++) {
				View v = getListView().getChildAt(i);
				CheckBox check = (CheckBox)v.findViewById(R.id.contact_checkbox);
				if (check.isChecked()) {
					TextView text = (TextView)v.findViewById(R.id.nickname_view);
					contacts.add(text.getText().toString());
				}
			}
			TextView error = (TextView)findViewById(R.id.error_message_view);
			if (contacts.size() == 0) {
				error.setVisibility(View.VISIBLE);
				error.setText("Please select one contact or more.");
				return;
			}
			GTalkUtils.createGroupChatSession(gtalkSession, "", contacts);
			dismiss();
		}
	}
}
