package jp.dip.commonsense.android.mametalk;

import android.app.Dialog;
import android.content.Context;
import android.database.Cursor;
import android.provider.Im;
import android.provider.Im.GroupMemberColumns;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;

public class ParticipantsDialog extends Dialog {
	
	private ListView listView;
	private long groupId;
	
	public ParticipantsDialog(Context context, long groupId) {
		super(context);
		setContentView(R.layout.contacts);
		setTitle("Group Chat members");
		listView = (ListView)findViewById(android.R.id.list);
		listView.setEmptyView(findViewById(android.R.id.empty));
		this.groupId = groupId; 
		fillData();
	}
	
	private void fillData() {
		Cursor cursor = getContext().getContentResolver().query(
    			Im.GroupMembers.CONTENT_URI, null, GroupMemberColumns.GROUP + "=" + groupId, null, null);
    	listView.setAdapter(new SimpleCursorAdapter(getContext(), R.layout.contact_row, cursor,
    				new String[] { GroupMemberColumns.NICKNAME },
    				new int[] { R.id.nickname_view }));
    }
}
