package jp.dip.commonsense.android.mametalk;

import java.util.HashMap;

import jp.dip.commonsense.android.provider.Mametalk;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.Log;

public class PresenceProvider extends ContentProvider {

	private SQLiteDatabase mDB;

    private static final String TAG = "PresenceProvider";
    private static final String DATABASE_NAME = "presence.db";
    private static final int DATABASE_VERSION = 2;
    private static final String TABLE_NAME = "presences";

    private static HashMap<String, String> PRESENCES_LIST_PROJECTION_MAP;
    
    private static final int PRESENCES = 1;
    private static final int PRESENCE_ID = 2;
    
    private static final UriMatcher URI_MATCHER;
    
    private static class DatabaseHelper extends SQLiteOpenHelper {

        @Override
        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE " + TABLE_NAME + " (_id INTEGER PRIMARY KEY,"
                    + "mode INTEGER," + "status TEXT" + ");");
            setupInitData(db);
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.w(TAG, "Upgrading database from version " + oldVersion + " to "
                    + newVersion + ", which will destroy all old data");
            db.execSQL("DROP TABLE IF EXISTS " + TABLE_NAME);
            onCreate(db);
        }
        
        private void setupInitData(SQLiteDatabase db) {
        	db.execSQL("INSERT INTO " + TABLE_NAME + " VALUES(0, 0, 'Offline');");
        	db.execSQL("INSERT INTO " + TABLE_NAME + " VALUES(1, 2, 'Don''t disturb');");
        	db.execSQL("INSERT INTO " + TABLE_NAME + " VALUES(2, 3, 'Away');");
        	db.execSQL("INSERT INTO " + TABLE_NAME + " VALUES(3, 5, 'Available');");
        }
    }
    
    static {
        URI_MATCHER = new UriMatcher(UriMatcher.NO_MATCH);
        URI_MATCHER.addURI("jp.dip.commonsense.android.provider.Mametalk", "presences", PRESENCES);
        URI_MATCHER.addURI("jp.dip.commonsense.android.provider.Mametalk", "presences/#", PRESENCE_ID);

        PRESENCES_LIST_PROJECTION_MAP = new HashMap<String, String>();
        PRESENCES_LIST_PROJECTION_MAP.put(BaseColumns._ID, "_id");
        PRESENCES_LIST_PROJECTION_MAP.put(Mametalk.Presences.MODE, "mode");
        PRESENCES_LIST_PROJECTION_MAP.put(Mametalk.Presences.STATUS, "status");
    }
    
	@Override
	public boolean onCreate() {
		@SuppressWarnings("synthetic-access")
		DatabaseHelper dbHelper = new DatabaseHelper();
        mDB = dbHelper.openDatabase(getContext(), DATABASE_NAME, null, DATABASE_VERSION);
        return (mDB == null) ? false : true;
	}
    
	@Override
	public String getType(Uri uri) {
		switch (URI_MATCHER.match(uri)) {
        case PRESENCES:
            return "vnd.android.cursor.dir/vnd.mametalk.presence";

        case PRESENCE_ID:
            return "vnd.android.cursor.item/vnd.mametalk.presence";

        default:
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String selection,
			String[] selectionArgs, String sort) {
	    SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        switch (URI_MATCHER.match(uri)) {
        case PRESENCES:
            qb.setTables(TABLE_NAME);
            qb.setProjectionMap(PRESENCES_LIST_PROJECTION_MAP);
            break;

        case PRESENCE_ID:
            qb.setTables(TABLE_NAME);
            qb.appendWhere("_id=" + uri.getPathSegments().get(1));
            break;

        default:
            throw new IllegalArgumentException("Unknown URI " + uri);
        }

        // If no sort order is specified use the default
        String orderBy;
        if (TextUtils.isEmpty(sort)) {
            orderBy = Mametalk.Presences.DEFAULT_SORT_ORDER;
        } else {
            orderBy = sort;
        }

        Cursor c = qb.query(mDB, projection, selection, selectionArgs, null, null, orderBy);
        c.setNotificationUri(getContext().getContentResolver(), uri);
        return c;
	}
	
	@Override
	public Uri insert(Uri uri, ContentValues initialValues) {
		long rowID;
        ContentValues values;
        if (initialValues != null) {
            values = new ContentValues(initialValues);
        } else {
            values = new ContentValues();
        }

        if (URI_MATCHER.match(uri) != PRESENCES) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        
        rowID = mDB.insert(TABLE_NAME, "mode", values);
        if (rowID > 0) {
        	Uri contentUri = ContentUris.withAppendedId(Mametalk.Presences.CONTENT_URI, rowID);
            getContext().getContentResolver().notifyChange(contentUri, null);
            return contentUri;
        }

        throw new SQLException("Failed to insert row into " + uri);
	}

	@Override
	public int update(Uri uri, ContentValues values, String where, String[] whereArgs) {
		int count;
        switch (URI_MATCHER.match(uri)) {
        case PRESENCES:
            count = mDB.update(TABLE_NAME, values, where, whereArgs);
            break;

        case PRESENCE_ID:
            String segment = uri.getPathSegments().get(1);
            count = mDB
                    .update(TABLE_NAME, values, "_id="
                            + segment
                            + (!TextUtils.isEmpty(where) ? " AND (" + where
                                    + ')' : ""), whereArgs);
            break;

        default:
            throw new IllegalArgumentException("Unknown URI " + uri);
        }

        getContext().getContentResolver().notifyChange(uri, null);
        return count;
	}

	@Override
	public int delete(Uri uri, String where, String[] whereArgs) {
		int count;
        switch (URI_MATCHER.match(uri)) {
        case PRESENCES:
            count = mDB.delete(TABLE_NAME, where, whereArgs);
            break;

        case PRESENCE_ID:
            String segment = uri.getPathSegments().get(1);
            count = mDB
                    .delete(TABLE_NAME, "_id="
                            + segment
                            + (!TextUtils.isEmpty(where) ? " AND (" + where
                                    + ')' : ""), whereArgs);
            break;

        default:
            throw new IllegalArgumentException("Unknown URI " + uri);
        }

        getContext().getContentResolver().notifyChange(uri, null);
        return count;
	}
}
