package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.R;
import android.app.Dialog;
import android.content.Context;
import android.os.DeadObjectException;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.google.android.gtalkservice.IGTalkSession;

public class ChatInvitationDialog extends Dialog implements View.OnClickListener {

	private IGTalkSession xmppSession = null;
	
	public ChatInvitationDialog(Context c, IGTalkSession session) {
		super(c);
		this.xmppSession = session;
		setContentView(R.layout.chat_invitation_dialog);
		setTitle(R.string.dialog_title_chat_invitation);
		Button addButton = (Button) findViewById(R.id.invite_button);
		addButton.setOnClickListener(this);
	}
	
    private boolean isValidContact(String contact) {
        if (TextUtils.isEmpty(contact)) {
            return false;
        }
        if (contact.indexOf('@') == -1) {
            return false;
        }
        return true;
    }
    
	@Override
	public void onClick(View view) {
		if (view.getId() == R.id.invite_button) {
			EditText contactText = (EditText) findViewById(R.id.newcontact_edit);
			TextView messageText = (TextView) findViewById(R.id.message_view);
			if (!isValidContact(contactText.getText().toString())) {
				messageText.setText("Invalid contactname. Please enter Gmail or Google apps. username.");
				return;
			}
	        try {
	            xmppSession.inviteContact(contactText.getText().toString(), null);
	        } catch (DeadObjectException ex) {
	            Log.e(this.getClass().getName(), "caught " + ex);
	        }
	        dismiss();
		}
	}
}
