package jp.dip.commonsense.android.mametalk.dialog;

import jp.dip.commonsense.android.mametalk.R;
import jp.dip.commonsense.android.mametalk.util.GTalkUtils;
import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;

import com.google.android.gtalkservice.IChatSession;

public class GroupChatInvitationDialog extends AbstractGroupChatInvitationDialog {
	
	private IChatSession chatSession;
	
	public GroupChatInvitationDialog(Context context, IChatSession chatSession) {
		super(context);
		this.chatSession = chatSession;
	}
	
	@Override
	protected void onStart() {
		super.onStart();
	}

	@Override
	public void onClick(View view) {
		if (view.getId() == R.id.invite_button) {
			int size = getListView().getCount();
			int checkedCount = 0;
			for (int i = 0; i < size; i++) {
				View v = getListView().getChildAt(i);
				CheckBox check = (CheckBox)v.findViewById(R.id.contact_checkbox);
				if (check.isChecked()) {
					TextView text = (TextView)v.findViewById(R.id.nickname_view);
					GTalkUtils.inviteContact(chatSession, text.getText().toString());
					checkedCount++;
				}
			}
			TextView error = (TextView)findViewById(R.id.error_message_view);
			if (checkedCount == 0) {
				error.setVisibility(View.VISIBLE);
				error.setText(R.string.message_unchecked);
				return;
			}
			dismiss();
		}
	}
}
