package jp.dip.commonsense.android.mametalk.util;


import jp.dip.commonsense.android.mametalk.R;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;

public class MessageUtils {
	private MessageUtils() {
		//
	}
	public static void showMessage(Context context, CharSequence msg) {
		showMessage(context, "", msg);
    }
	public static void showMessage(Context context, CharSequence title, CharSequence msg) {
		getBaseDialog(context, title, msg).show();
    }
	public static AlertDialog.Builder getBaseDialog(Context context) {
		return getBaseDialog(context, "", "");
	}
	public static AlertDialog.Builder getBaseDialog(Context context, CharSequence msg) {
		return getBaseDialog(context, "", msg);
	}
	public static AlertDialog.Builder getBaseDialog(Context context, CharSequence title, CharSequence msg) {
		return new AlertDialog.Builder(context)
			.setTitle(title)
			.setMessage(msg)
			.setPositiveButton(R.string.button_ok, new OnClickListener() {
				@Override
				public void onClick(DialogInterface dialoginterface, int i) {
					dialoginterface.dismiss();
				}
			});
	}
}
