# coding: utf-8
'''\
Package device initialize code
'''

__author__ = 'M.Decimal at Specurio Studio.'
__version__ = '0.1'
__date__ = '2009-12-08'
__credits__ = """\
RemoteStation PC-OP-RS1 is a product for trasmitting ir signals made by
Japanese peripheral equipment vender Buffalo,Inc.
This script was coded on Pydev, powerful python IDE by Fabio Zadrozny, and now
becoming Apatana open source product.
Of course, Pydev is plug-in for, THE GREATE IDE, Eclipse provided by Eclipse
Foundation.
"""


import logging
import platform
import os.path
import gettext


def _acn_dirname(path, gen=0):
    for i in range(0, gen + 1) :
        path = os.path.dirname(path)
    return path
os.path.ancdirname = _acn_dirname

# decision file whether script is in develop environment
IN_DEVELOP_ENV = False
DEVELOP_TOP_DIR = os.path.ancdirname(__file__, 2)
if os.path.exists(os.path.join(DEVELOP_TOP_DIR, 'setup.py')) :
    IN_DEVELOP_ENV = True

#======================================================================
# Logging SETTINGS
#
LOGGER = logging.getLogger('managers.device')

#======================================================================
# L10N
#
# setting gettext
if IN_DEVELOP_ENV :
    LOGGER.debug('Develop environment locale directory is %s' %
                 os.path.join(DEVELOP_TOP_DIR, 'locale'))
    _ = gettext.translation('managers.rsdevice',
                            os.path.join( DEVELOP_TOP_DIR, 'locale' ),
                            ).ugettext
else :
    _ = gettext.translation('managers.rsdevice', fallback=True).ugettext


#===============================================================================
# Import corresponding module for platform.
#===============================================================================
os_name = platform.system()
if not os.path.exists( os.path.join( os.path.dirname( __file__ ), os_name + '.py' ) ) :
    raise ImportError( _('%s plugin module not found') % os_name )

exec( 'import %s' % os_name )

#===============================================================================
# Set the platforms device to Device
#===============================================================================
Device = eval( os_name + '.Device' )
