package mandelbrotExplorer;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

@SuppressWarnings("serial")
public class HistoryTable extends JScrollPane {
	private JTable table;
	private DefaultTableModel tm;
	private Mandelbrot mandel;
	
	public HistoryTable(final Mandelbrot m){
		this.mandel = m;
		tm = new DefaultTableModel();
		tm.addColumn("r left");
		tm.addColumn("i top");
		tm.addColumn("r width");
		tm.addColumn("i height");
		table = new JTable(tm);
		
		table.setColumnSelectionAllowed(false);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		table.getSelectionModel().addListSelectionListener(
				new ListSelectionListener(){
					public void valueChanged(final ListSelectionEvent e) {
						if( !e.getValueIsAdjusting() ){
							final double x = ((Double)table.getValueAt(table.getSelectedRow(), 0)).doubleValue();
							final double y = ((Double)table.getValueAt(table.getSelectedRow(), 1)).doubleValue();
							final double w = ((Double)table.getValueAt(table.getSelectedRow(), 2)).doubleValue();
							final double h = ((Double)table.getValueAt(table.getSelectedRow(), 3)).doubleValue();
							
							mandel.setMandelbrotSet(new MandelbrotSet( new Point2D.Double(x , y) , w , h));
							System.out.println(new Rectangle2D.Double(x, y, w, h));;
						}
					}
				}
		);
		this.getViewport().add(table);
	}
	
	public void addRow(final MandelbrotSet m){
		final Double[] rd ={ new Double(m.getLeft()),new Double(m.getTop()),new Double(m.getScaleR()),new Double(m.getScaleI()) };
		tm.addRow(rd);
		
		//----------@XN[̂
		final JScrollBar sb = this.getVerticalScrollBar();
		sb.setValue(sb.getMaximum());
		System.out.printf("min:%d,max:%d,val:%d\n",sb.getMinimum(),sb.getMaximum(),sb.getValue());
	}

}
